/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.reporting;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.monitoring.Operation;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.reporting.CastorXmlTransformer;
import nl.b3p.kaartenbalie.reporting.Report;
import nl.b3p.kaartenbalie.reporting.castor.HourlyLoad;
import nl.b3p.kaartenbalie.reporting.castor.MonitorReport;
import nl.b3p.kaartenbalie.reporting.castor.Parameters;
import nl.b3p.kaartenbalie.reporting.castor.RequestLoad;
import nl.b3p.kaartenbalie.reporting.castor.RequestSummary;
import nl.b3p.kaartenbalie.reporting.castor.ResponseFrequency;
import nl.b3p.kaartenbalie.reporting.castor.ResponseTime;
import nl.b3p.kaartenbalie.reporting.castor.Service;
import nl.b3p.kaartenbalie.reporting.castor.ServiceProvider;
import nl.b3p.kaartenbalie.reporting.castor.ServiceProviders;
import nl.b3p.kaartenbalie.reporting.castor.TypeSummary;
import nl.b3p.ogc.wfs.v110.WfsServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportThread
extends Thread {
    private static final Log log = LogFactory.getLog(ReportThread.class);
    private static final String[] SERVICES = new String[]{"WMS", "WFS"};
    protected Organization organization;
    protected EntityManager em = null;
    private Date startDate;
    private Date endDate;
    private String xsl;
    private String name;
    private String type;

    public void init(Map parameters) throws Exception {
        this.setParameters(parameters);
        if (this.type == null || this.type.length() == 0) {
            this.type = "xml";
        }
        if (this.name == null || this.name.length() == 0) {
            this.name = this.type;
        }
        try {
            log.debug((Object)"Creating local entity manager ......");
            this.em = MyEMFDatabase.getEntityManagerFactory().createEntityManager();
        }
        catch (Throwable e) {
            log.warn((Object)"Error creating local entity manager: ", e);
            if (this.em != null && this.em.isOpen()) {
                this.em.close();
            }
            this.em = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            EntityTransaction tx = this.em.getTransaction();
            long processStart = System.currentTimeMillis();
            Report report = new Report();
            tx = this.em.getTransaction();
            tx.begin();
            try {
                report.setOrganization(this.organization);
                report.setStartDate(this.startDate);
                report.setEndDate(this.endDate);
                report.setName(this.name);
                String mime = (String)CastorXmlTransformer.getContentTypes().get(this.type);
                report.setReportMime(mime);
                this.em.persist((Object)report);
                this.em.flush();
                tx.commit();
            }
            catch (Exception ex) {
                tx.rollback();
                throw ex;
            }
            try {
                Parameters parameters = new Parameters();
                parameters.setDateEnd(new org.exolab.castor.types.Date(this.endDate));
                parameters.setDateStart(new org.exolab.castor.types.Date(this.startDate));
                parameters.setId(Integer.toString(report.getId()));
                parameters.setOrganization(this.organization.getName());
                parameters.setTimeStamp(new Date());
                MonitorReport mr = this.createMonitorReport();
                Long procTime = new Long(System.currentTimeMillis() - processStart);
                parameters.setProcessingTime(procTime.longValue());
                mr.setParameters(parameters);
                report.setProcessingTime(procTime);
                if (this.type.equalsIgnoreCase("html")) {
                    CastorXmlTransformer cxt = new CastorXmlTransformer(this.xsl, MyEMFDatabase.localPath());
                    report.setReportXML(cxt.createHtml((Object)mr));
                } else {
                    CastorXmlTransformer cxt = new CastorXmlTransformer();
                    report.setReportXML(cxt.createXml((Object)mr));
                }
            }
            catch (Exception e) {
                StringBuffer rerror = new StringBuffer();
                rerror.append("<error>");
                rerror.append(e.getLocalizedMessage());
                StackTraceElement[] ste = e.getStackTrace();
                if (ste.length > 0) {
                    rerror.append(" at ");
                    rerror.append(ste[0].toString());
                }
                rerror.append("</error>");
                report.setReportXML(rerror.toString());
            }
            tx = this.em.getTransaction();
            tx.begin();
            try {
                this.em.merge((Object)report);
                this.em.flush();
                tx.commit();
            }
            catch (Exception ex) {
                tx.rollback();
                throw ex;
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        finally {
            log.debug((Object)"Closing local entity manager ......");
            if (this.em != null && this.em.isOpen()) {
                this.em.close();
            }
            this.em = null;
        }
    }

    protected MonitorReport createMonitorReport() {
        MonitorReport mr = new MonitorReport();
        for (int i = 0; i < SERVICES.length; ++i) {
            ServiceProviders serviceProviders;
            ResponseFrequency responseFrequency;
            RequestSummary requestSummary;
            Service service = new Service();
            service.setName(SERVICES[i]);
            RequestLoad requestLoad = this.createRequestLoad(service.getName());
            if (requestLoad != null) {
                service.setRequestLoad(requestLoad);
            }
            if ((requestSummary = this.createRequestSummary(service.getName())) != null) {
                service.setRequestSummary(requestSummary);
            }
            if ((responseFrequency = this.createResponseFrequency(service.getName())) != null) {
                service.setResponseFrequency(responseFrequency);
            }
            if ((serviceProviders = this.createServiceProviders(service.getName())) != null) {
                service.setServiceProviders(serviceProviders);
            }
            mr.addService(service);
        }
        return mr;
    }

    protected RequestLoad createRequestLoad(String service) {
        RequestLoad requestLoad = null;
        List resultList = null;
        try {
            resultList = this.em.createQuery("SELECT count(cr.timestamp), to_char(cr.timestamp, 'DD-MM-YYYY'), to_char(cr.timestamp, 'HH24'), sum(ro.bytesReceivedFromUser), sum(ro.bytesSentToUser), avg(ro.duration), max(ro.duration) FROM ClientRequest AS cr LEFT JOIN cr.requestOperations AS ro WHERE cr.service = :service AND cr.organizationId = :organizationId AND cr.timestamp BETWEEN :startDate AND :endDate AND ro.type = :type GROUP BY to_char(cr.timestamp, 'DD-MM-YYYY'), to_char(cr.timestamp, 'HH24') ORDER BY to_char(cr.timestamp, 'DD-MM-YYYY'), to_char(cr.timestamp, 'HH24') ASC").setParameter("service", (Object)service).setParameter("type", (Object)new Integer(5)).setParameter("startDate", (Object)this.startDate).setParameter("endDate", (Object)this.endDate).setParameter("organizationId", (Object)this.organization.getId()).getResultList();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        if (resultList != null && resultList.size() > 0) {
            requestLoad = new RequestLoad();
            for (Object[] result : resultList) {
                if (result == null || result.length != 7) continue;
                HourlyLoad hourlyLoad = new HourlyLoad();
                Long count = (Long)result[0];
                hourlyLoad.setCount((count == null ? new Integer(0) : new Integer(count.intValue())).intValue());
                Date datum = FormUtils.StringToDate((String)((String)result[1]), null);
                hourlyLoad.setDate(new org.exolab.castor.types.Date(datum == null ? new Date() : datum));
                String hour = (String)result[2];
                hourlyLoad.setHour(new Integer(hour).intValue());
                Long bytesReceived = (Long)result[3];
                hourlyLoad.setBytesReceivedSum((bytesReceived == null ? new Integer(0) : new Integer(bytesReceived.intValue())).intValue());
                Long bytesSent = (Long)result[4];
                hourlyLoad.setBytesSentSum((bytesSent == null ? new Integer(0) : new Integer(bytesSent.intValue())).intValue());
                Double durationAvg = (Double)result[5];
                hourlyLoad.setDurationAvg((long)(durationAvg == null ? new Integer(0) : new Integer(durationAvg.intValue())).intValue());
                Long durationMax = (Long)result[6];
                hourlyLoad.setDurationMax((long)(durationMax == null ? new Integer(0) : new Integer(durationMax.intValue())).intValue());
                requestLoad.addHourlyLoad(hourlyLoad);
            }
        }
        return requestLoad;
    }

    protected RequestSummary createRequestSummary(String service) {
        RequestSummary requestSummary = null;
        for (int operation = 2; operation <= 5; ++operation) {
            Object[] result = null;
            try {
                result = (Object[])this.em.createQuery("SELECT count(ro.type), sum(ro.bytesReceivedFromUser), sum(ro.bytesSentToUser), sum(ro.dataSize), avg(ro.duration), max(ro.duration) FROM Operation AS ro WHERE ro.clientRequest.service = :service AND ro.clientRequest.organizationId = :organizationId AND ro.type = :type AND ro.clientRequest.timestamp BETWEEN :startDate AND :endDate GROUP BY ro.type ").setParameter("service", (Object)service).setParameter("type", (Object)new Integer(operation)).setParameter("startDate", (Object)this.startDate).setParameter("endDate", (Object)this.endDate).setParameter("organizationId", (Object)this.organization.getId()).getSingleResult();
            }
            catch (NoResultException noResultException) {
                // empty catch block
            }
            if (result == null || result.length != 6) continue;
            requestSummary = new RequestSummary();
            TypeSummary typeSummary = new TypeSummary();
            Long count = (Long)result[0];
            typeSummary.setCount((count == null ? new Integer(0) : new Integer(count.intValue())).intValue());
            Long bytesReceived = (Long)result[1];
            typeSummary.setBytesReceivedSum((bytesReceived == null ? new Integer(0) : new Integer(bytesReceived.intValue())).intValue());
            Long bytesSent = (Long)result[2];
            typeSummary.setBytesSentSum((bytesSent == null ? new Integer(0) : new Integer(bytesSent.intValue())).intValue());
            Long dataSize = (Long)result[3];
            typeSummary.setDataSizeSum((dataSize == null ? new Integer(0) : new Integer(dataSize.intValue())).intValue());
            Double durationAvg = (Double)result[4];
            typeSummary.setDurationAvg((long)(durationAvg == null ? new Integer(0) : new Integer(durationAvg.intValue())).intValue());
            Long durationMax = (Long)result[5];
            typeSummary.setDurationMax((long)(durationMax == null ? new Integer(0) : new Integer(durationMax.intValue())).intValue());
            typeSummary.setType(Operation.NAME[operation - 1]);
            requestSummary.addTypeSummary(typeSummary);
        }
        return requestSummary;
    }

    protected ResponseFrequency createResponseFrequency(String service) {
        ResponseFrequency responseFrequency = new ResponseFrequency();
        for (int operation = 2; operation <= 6; ++operation) {
            int stepSize = 1000;
            int start = 0;
            for (int i = 1; i <= 21; ++i) {
                Long msLow = new Long((i - 1) * stepSize + start);
                Long msHigh = new Long(i * stepSize + start);
                Long frequencyHits = null;
                try {
                    if (i <= 20) {
                        frequencyHits = (Long)this.em.createQuery("SELECT count(*) FROM Operation AS ro WHERE ro.clientRequest.service = :service AND ro.clientRequest.organizationId = :organizationId AND ro.type = :type AND ro.clientRequest.timestamp BETWEEN :startDate AND :endDate AND ro.duration BETWEEN :msLow AND :msHigh ").setParameter("service", (Object)service).setParameter("type", (Object)new Integer(operation)).setParameter("startDate", (Object)this.startDate).setParameter("endDate", (Object)this.endDate).setParameter("organizationId", (Object)this.organization.getId()).setParameter("msLow", (Object)msLow).setParameter("msHigh", (Object)msHigh).getSingleResult();
                    } else {
                        frequencyHits = (Long)this.em.createQuery("SELECT count(*) FROM Operation AS ro WHERE ro.clientRequest.service = :service AND ro.clientRequest.organizationId = :organizationId AND ro.type = :type AND ro.clientRequest.timestamp BETWEEN :startDate AND :endDate AND ro.duration > :msLow ").setParameter("service", (Object)service).setParameter("type", (Object)new Integer(operation)).setParameter("startDate", (Object)this.startDate).setParameter("endDate", (Object)this.endDate).setParameter("organizationId", (Object)this.organization.getId()).setParameter("msLow", (Object)msLow).getSingleResult();
                        msHigh = new Long(-1L);
                    }
                }
                catch (NoResultException noResultException) {
                    // empty catch block
                }
                if (frequencyHits == null || frequencyHits <= 0L) continue;
                ResponseTime responseTime = new ResponseTime();
                responseTime.setCount(frequencyHits == null ? 0 : frequencyHits.intValue());
                responseTime.setDurationHigh((long)(msHigh == null ? new Integer(0) : new Integer(msHigh.intValue())).intValue());
                responseTime.setDurationLow((long)(msLow == null ? new Integer(0) : new Integer(msLow.intValue())).intValue());
                responseTime.setType(Operation.NAME[operation - 1]);
                responseFrequency.addResponseTime(responseTime);
            }
        }
        if (responseFrequency.getResponseTimeCount() == 0) {
            return null;
        }
        return responseFrequency;
    }

    protected ServiceProviders createServiceProviders(String service) {
        ServiceProviders serviceProviders = null;
        List resultList = null;
        try {
            resultList = this.em.createQuery("SELECT ro.serviceProviderId, count(ro.serviceProviderId), sum(ro.bytesReceived), sum(ro.bytesSent), avg(ro.requestResponseTime), max(ro.requestResponseTime) FROM ServiceProviderRequest AS ro WHERE ro.clientRequest.service = :service AND ro.clientRequest.organizationId = :organizationId AND ro.clientRequest.timestamp BETWEEN :startDate AND :endDate GROUP BY ro.serviceProviderId ").setParameter("service", (Object)service).setParameter("startDate", (Object)this.startDate).setParameter("endDate", (Object)this.endDate).setParameter("organizationId", (Object)this.organization.getId()).getResultList();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        if (resultList != null && resultList.size() > 0) {
            serviceProviders = new ServiceProviders();
            for (Object[] result : resultList) {
                if (result == null || result.length != 6) continue;
                ServiceProvider serviceProvider = new ServiceProvider();
                serviceProvider.setName(this.getSpName((Integer)result[0], service));
                Long count = (Long)result[1];
                serviceProvider.setCount((count == null ? new Integer(0) : new Integer(count.intValue())).intValue());
                Long bytesReceived = (Long)result[2];
                serviceProvider.setBytesReceivedSum((bytesReceived == null ? new Integer(0) : new Integer(bytesReceived.intValue())).intValue());
                Long bytesSent = (Long)result[3];
                serviceProvider.setBytesSentSum((bytesSent == null ? new Integer(0) : new Integer(bytesSent.intValue())).intValue());
                Double durationAvg = (Double)result[4];
                serviceProvider.setDurationAvg((long)(durationAvg == null ? new Integer(0) : new Integer(durationAvg.intValue())).intValue());
                Long durationMax = (Long)result[5];
                serviceProvider.setDurationMax((long)(durationMax == null ? new Integer(0) : new Integer(durationMax.intValue())).intValue());
                serviceProviders.addServiceProvider(serviceProvider);
            }
        }
        return serviceProviders;
    }

    private String getSpName(Integer id, String service) {
        nl.b3p.wms.capabilities.ServiceProvider sp;
        String spName = "onbekend";
        if ("WFS".equalsIgnoreCase(service)) {
            WfsServiceProvider sp2 = (WfsServiceProvider)this.em.find(WfsServiceProvider.class, (Object)id);
            if (sp2 != null) {
                spName = sp2.getAbbr();
            }
        } else if ("WMS".equalsIgnoreCase(service) && (sp = (nl.b3p.wms.capabilities.ServiceProvider)this.em.find(nl.b3p.wms.capabilities.ServiceProvider.class, (Object)id)) != null) {
            spName = sp.getAbbr();
        }
        return spName;
    }

    public void setParameters(Map parameters) throws Exception {
        if (parameters == null) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime((Date)parameters.get("startDate"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.startDate = cal.getTime();
        cal.setTime((Date)parameters.get("endDate"));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 99);
        this.endDate = cal.getTime();
        this.organization = (Organization)parameters.get("organization");
        this.xsl = (String)parameters.get("xsl");
        this.name = (String)parameters.get("name");
        this.type = (String)parameters.get("type");
    }
}

