/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.SrsBoundingBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LayerValidator {
    private static final Log log = LogFactory.getLog(LayerValidator.class);
    private Set layers;

    public LayerValidator(Set layers) {
        this.setLayers(layers);
    }

    public Set getLayers() {
        return this.layers;
    }

    public void setLayers(Set layers) {
        this.layers = layers;
        for (Layer l : layers) {
            Set srsbb = l.getSrsbb();
            if (srsbb != null) continue;
            log.debug((Object)("Layer: " + l.getUniqueName() + " does not have a SRS"));
        }
    }

    public boolean validate() {
        return this.validateSRS().length > 0;
    }

    public SrsBoundingBox validateLatLonBoundingBox() {
        SrsBoundingBox llbb2;
        Iterator it = this.layers.iterator();
        ArrayList supportedLLBB = new ArrayList();
        while (it.hasNext()) {
            this.addLayerSupportedLLBB((Layer)it.next(), supportedLLBB);
        }
        double minx = 180.0;
        double miny = 90.0;
        double maxx = -180.0;
        double maxy = -90.0;
        for (SrsBoundingBox llbb2 : supportedLLBB) {
            double xmin = Double.parseDouble(llbb2.getMinx());
            double ymin = Double.parseDouble(llbb2.getMiny());
            double xmax = Double.parseDouble(llbb2.getMaxx());
            double ymax = Double.parseDouble(llbb2.getMaxy());
            if (xmin < minx) {
                minx = xmin;
            }
            if (ymin < miny) {
                miny = ymin;
            }
            if (xmax > maxx) {
                maxx = xmax;
            }
            if (!(ymax > maxy)) continue;
            maxy = ymax;
        }
        llbb2 = new SrsBoundingBox();
        llbb2.setMinx(Double.toString(minx));
        llbb2.setMiny(Double.toString(miny));
        llbb2.setMaxx(Double.toString(maxx));
        llbb2.setMaxy(Double.toString(maxy));
        return llbb2;
    }

    private void addLayerSupportedLLBB(Layer layer, ArrayList supported) {
        Set srsen = layer.getSrsbb();
        if (srsen == null) {
            return;
        }
        for (SrsBoundingBox srsbb : srsen) {
            String type = srsbb.getType();
            if (type == null || !type.equalsIgnoreCase("LatLonBoundingBox")) continue;
            supported.add(srsbb);
        }
        if (layer.getParent() != null) {
            this.addLayerSupportedLLBB(layer.getParent(), supported);
        }
    }

    public void addLayerSupportedSRS(Layer l, HashMap supported) {
        Set srsen = l.getSrsbb();
        if (srsen == null) {
            return;
        }
        for (SrsBoundingBox srsbb : srsen) {
            if (srsbb.getSrs() == null || srsbb.getMinx() != null || srsbb.getMiny() != null || srsbb.getMaxx() != null || srsbb.getMaxy() != null) continue;
            supported.put(srsbb.getSrs(), srsbb.getSrs());
        }
        if (l.getParent() != null) {
            this.addLayerSupportedSRS(l.getParent(), supported);
        }
    }

    public String[] validateSRS() {
        int i;
        HashMap hm = new HashMap();
        Iterator lit = this.layers.iterator();
        int tellerMeeTellendeLayers = 0;
        while (lit.hasNext()) {
            HashMap supportedByLayer = new HashMap();
            this.addLayerSupportedSRS((Layer)lit.next(), supportedByLayer);
            if (supportedByLayer.size() <= 0) continue;
            ++tellerMeeTellendeLayers;
            for (String srs : supportedByLayer.values()) {
                this.addSrsCount(hm, srs);
            }
        }
        ArrayList<String> supportedSrsen = new ArrayList<String>();
        for (Map.Entry entry : hm.entrySet()) {
            i = (Integer)entry.getValue();
            if (i < tellerMeeTellendeLayers) continue;
            supportedSrsen.add((String)entry.getKey());
        }
        if (supportedSrsen.isEmpty()) {
            supportedSrsen.add("");
        }
        String[] returnValue = new String[supportedSrsen.size()];
        for (i = 0; i < returnValue.length; ++i) {
            if (supportedSrsen.get(i) == null) continue;
            returnValue[i] = (String)supportedSrsen.get(i);
        }
        return returnValue;
    }

    private void addSrsCount(HashMap hm, String srs) {
        if (hm.containsKey(srs)) {
            int i = (Integer)hm.get(srs) + 1;
            hm.put(srs, new Integer(i));
        } else {
            hm.put(srs, new Integer("1"));
        }
    }
}

