/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.accounting.AccountManager;
import nl.b3p.kaartenbalie.core.server.accounting.ExtLayerCalculator;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPriceComposition;
import nl.b3p.kaartenbalie.core.server.accounting.entity.Transaction;
import nl.b3p.kaartenbalie.core.server.b3pLayering.ConfigLayer;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.RequestHandler;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.SpLayerSummary;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.Roles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OGCRequestHandler
implements RequestHandler {
    private static final Log log = LogFactory.getLog(OGCRequestHandler.class);
    protected User user;
    protected String url;
    protected int maxResponseTime = -1;

    protected abstract SpLayerSummary getValidLayerObjects(EntityManager var1, LayerSummary var2, Integer[] var3, boolean var4) throws Exception;

    protected SpLayerSummary getValidLayerObjects(EntityManager em, String query, LayerSummary m, Integer[] orgIds, boolean b3pLayering) throws Exception {
        String layerCode = m.getSpAbbr();
        String layerName = m.getLayerName();
        log.debug((Object)("Collect layer info for layer: " + layerName + " and service provider: " + layerCode));
        if (layerCode == null) {
            return null;
        }
        if (b3pLayering) {
            if (layerCode.equals(KBConfiguration.SERVICEPROVIDER_BASE_ABBR)) {
                SpLayerSummary layerInfo = new SpLayerSummary(new Integer(-1), new Integer(-1), layerName, KBConfiguration.SERVICEPROVIDER_BASE_HTTP, KBConfiguration.SERVICEPROVIDER_BASE_ABBR, null, null);
                return layerInfo;
            }
            return null;
        }
        if (layerCode.equals(KBConfiguration.SERVICEPROVIDER_BASE_ABBR)) {
            return null;
        }
        log.debug((Object)"BEGIN query getValidLayerObjects");
        long startTime = System.currentTimeMillis();
        List result = em.createQuery(query).setParameter("orgIds", Arrays.asList(orgIds)).setParameter("layerName", (Object)layerName).setParameter("layerCode", (Object)layerCode).getResultList();
        long endTime = System.currentTimeMillis();
        long dur = endTime - startTime;
        log.debug((Object)(dur + "ms: END query getValidLayerObjects"));
        if (result == null || result.isEmpty()) {
            log.error((Object)("layer not valid or no rights, name: " + OGCCommunication.buildFullLayerName((LayerSummary)m)));
            throw new Exception(KBConfiguration.REQUEST_NORIGHTS_EXCEPTION + ": " + OGCCommunication.buildFullLayerName((LayerSummary)m));
        }
        if (result.size() > 1) {
            log.debug((Object)("layers with duplicate names, name: " + OGCCommunication.buildFullLayerName((LayerSummary)m)));
        }
        return (SpLayerSummary)result.get(0);
    }

    public boolean isConfigInUrlAndAdmin(DataWrapper data, User user) {
        boolean isAdmin = false;
        if ("true".equalsIgnoreCase(data.getOgcrequest().getParameter("_VIEWER_CONFIG"))) {
            Set userRoles = user.getRoles();
            for (Roles role : userRoles) {
                if (!role.getRole().equalsIgnoreCase("beheerder")) continue;
                isAdmin = true;
                break;
            }
        }
        return isAdmin;
    }

    protected List getServiceProviderURLS(List<LayerSummary> lsl, Integer[] orgIds, boolean checkForQueryable, DataWrapper dw, boolean maintainOrder) throws Exception {
        SpLayerSummary layerInfo;
        ArrayList eventualSPList = new ArrayList();
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
        Map config = dw.getLayeringParameterMap();
        this.configB3pLayering(lsl, config);
        String spAbbrUrl = dw.getOgcrequest().getServiceProviderName();
        boolean b3pLayering = false;
        for (LayerSummary m : lsl) {
            layerInfo = this.getValidLayerObjects(em, m, orgIds, b3pLayering);
            if (layerInfo == null || checkForQueryable && (!checkForQueryable || layerInfo.getQueryable() == null || !layerInfo.getQueryable().equals("1"))) continue;
            this.addToServerProviderList(eventualSPList, layerInfo, maintainOrder);
        }
        b3pLayering = true;
        for (LayerSummary m : lsl) {
            layerInfo = this.getValidLayerObjects(em, m, orgIds, b3pLayering);
            if (layerInfo == null) continue;
            for (LayerSummary ls : layerInfo.getLayers()) {
                if (!"allowwithdrawals".equalsIgnoreCase(OGCCommunication.buildLayerNameWithoutSp((LayerSummary)ls))) continue;
                config.put("foundAllowTransactionsLayer", Boolean.TRUE);
            }
            this.addToServerProviderList(eventualSPList, layerInfo, maintainOrder);
        }
        return eventualSPList;
    }

    protected abstract LayerPriceComposition calculateLayerPriceComposition(DataWrapper var1, ExtLayerCalculator var2, String var3, String var4) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SpLayerSummary> prepareAccounting(Integer orgId, DataWrapper dw, List<SpLayerSummary> foundSpList) throws Exception {
        if (foundSpList == null) {
            return null;
        }
        ArrayList<SpLayerSummary> cleanedSpList = new ArrayList<SpLayerSummary>();
        AccountManager am = AccountManager.getAccountManager((Integer)orgId);
        Transaction tlu = am.beginTLU();
        Map config = dw.getLayeringParameterMap();
        boolean bAllowTransactions = true;
        Boolean bat = (Boolean)config.get("allowTransactions");
        String service = dw.getService();
        if (service != null && service.equals("WMS")) {
            bAllowTransactions = bat == null ? false : bat;
        }
        ExtLayerCalculator lc = new ExtLayerCalculator();
        Iterator<SpLayerSummary> it = foundSpList.iterator();
        try {
            while (it.hasNext()) {
                SpLayerSummary spInfo = it.next();
                List layers = spInfo.getLayers();
                if (layers == null) continue;
                ArrayList<LayerSummary> checkedLayers = new ArrayList<LayerSummary>();
                for (LayerSummary ls : layers) {
                    LayerPriceComposition lpc = this.calculateLayerPriceComposition(dw, lc, ls.getSpAbbr(), OGCCommunication.buildLayerNameWithoutSp((LayerSummary)ls));
                    boolean bIsFree = true;
                    if (lpc != null) {
                        tlu.registerUsage(lpc);
                        Boolean isFree = lpc.getLayerIsFree();
                        boolean bl = bIsFree = isFree == null ? false : isFree;
                    }
                    if (!bIsFree && !bAllowTransactions) continue;
                    checkedLayers.add(ls);
                }
                if (checkedLayers.size() <= 0) continue;
                spInfo.setLayers(checkedLayers);
                cleanedSpList.add(spInfo);
            }
        }
        finally {
            lc.closeEntityManager();
        }
        boolean bFoundAllowTransactionsLayer = true;
        Boolean bfat = (Boolean)config.get("foundAllowTransactionsLayer");
        if (service != null && service.equals("WMS")) {
            boolean bl = bFoundAllowTransactionsLayer = bfat == null ? false : bfat;
        }
        if (AccountManager.isEnableAccounting() && tlu.getCreditAlteration().doubleValue() > 0.0) {
            config.put("creditMutation", tlu.getCreditAlteration());
            config.put("pricedLayers", tlu.getPricedLayerNames());
            config.put("transactionsNeeded", Boolean.TRUE);
            if (!bAllowTransactions) {
                am.endTLU();
            }
            if (!bFoundAllowTransactionsLayer) {
                SpLayerSummary layerInfo = new SpLayerSummary(new Integer(-1), new Integer(-1), "allowwithdrawals", KBConfiguration.SERVICEPROVIDER_BASE_HTTP, KBConfiguration.SERVICEPROVIDER_BASE_ABBR, null, null);
                this.addToServerProviderList(cleanedSpList, layerInfo, true);
            }
        }
        return cleanedSpList;
    }

    public void doAccounting(Integer orgId, DataWrapper data, User user) throws Exception {
        AccountManager am = AccountManager.getAccountManager((Integer)orgId);
        Transaction transaction = am.getTLU();
        am.commitTransaction(transaction, user);
        am.endTLU();
        data.getLayeringParameterMap().put("balance", new Double(am.getBalance()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Layer getLayerByUniqueName(String uniqueName) throws Exception {
        Object identity = null;
        try {
            identity = MyEMFDatabase.createEntityManager((String)"initEM");
            log.debug((Object)"Getting entity manager ......");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"initEM");
            String[] layerCodeAndName = OGCCommunication.toCodeAndName((String)uniqueName);
            String spAbbr = layerCodeAndName[0];
            String layerName = layerCodeAndName[1];
            String query = "from Layer where name = :layerName and serviceProvider.abbr = :spAbbr";
            List ll = em.createQuery(query).setParameter("layerName", (Object)layerName).setParameter("spAbbr", (Object)spAbbr).getResultList();
            if (ll == null || ll.isEmpty()) {
                Layer layer = null;
                return layer;
            }
            for (Layer l : ll) {
                l.getMetadata();
                String dbLayerName = l.getName();
                String dbSpAbbr = l.getSpAbbr();
                if (dbLayerName == null || dbSpAbbr == null || !dbLayerName.equals(layerName) || !dbSpAbbr.equals(spAbbr)) continue;
                Layer layer = l;
                return layer;
            }
        }
        catch (Throwable e) {
            log.warn((Object)"Error creating EntityManager: ", e);
        }
        finally {
            log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"initEM");
        }
        return null;
    }

    protected void addToServerProviderList(List<SpLayerSummary> eventualSPList, SpLayerSummary layerInfo, boolean maintainOrder) {
        Object correctSpInfo = null;
        SpLayerSummary matchingSpInfo = null;
        Object lastSpInfo = null;
        int loopnum = 0;
        for (SpLayerSummary sls : eventualSPList) {
            Integer spId = sls.getServiceproviderId();
            if (spId != null && spId.intValue() == layerInfo.getServiceproviderId().intValue()) {
                matchingSpInfo = sls;
            }
            if (++loopnum != eventualSPList.size()) continue;
            lastSpInfo = sls;
        }
        if (!maintainOrder && matchingSpInfo != null) {
            correctSpInfo = matchingSpInfo;
        } else if (lastSpInfo != null && lastSpInfo.equals(matchingSpInfo)) {
            correctSpInfo = lastSpInfo;
        }
        if (correctSpInfo == null) {
            correctSpInfo = layerInfo;
            eventualSPList.add((SpLayerSummary)correctSpInfo);
        } else {
            correctSpInfo.addLayers(layerInfo.getLayers());
        }
    }

    protected void configB3pLayering(List<LayerSummary> lsl, Map config) throws Exception {
        for (LayerSummary m : lsl) {
            String layerCode = m.getSpAbbr();
            String layerName = OGCCommunication.buildLayerNameWithoutSp((LayerSummary)m);
            if (layerCode == null || layerName == null || !layerCode.equals(KBConfiguration.SERVICEPROVIDER_BASE_ABBR)) continue;
            ConfigLayer cl = ConfigLayer.forName((String)layerName);
            if (cl == null) {
                log.error((Object)("Config Layer " + layerName + " not found!"));
                throw new Exception("Config Layer " + layerName + " not found!");
            }
            cl.processConfig(config);
        }
    }

    public int getMaxResponseTime() {
        if (this.maxResponseTime <= 0) {
            this.maxResponseTime = 9999;
        }
        return this.maxResponseTime;
    }

    public void setMaxResponseTime(int maxResponseTime) {
        this.maxResponseTime = maxResponseTime;
    }
}

