/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.struts;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.reporting.Report;
import nl.b3p.kaartenbalie.reporting.ReportThread;
import nl.b3p.kaartenbalie.struts.KaartenbalieCrudAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReportingAction
extends KaartenbalieCrudAction {
    private static final Log log = LogFactory.getLog(ReportingAction.class);
    public static SimpleDateFormat reportingDate = new SimpleDateFormat("yyyy-MM-dd");
    protected static final String DOWNLOAD = "download";

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = new ExtendedMethodProperties("download");
        crudProp.setDefaultForwardName("success");
        crudProp.setDefaultMessageKey("beheer.reporting.download.succes");
        crudProp.setAlternateForwardName("failure");
        crudProp.setAlternateMessageKey("beheer.reporting.download.failed");
        map.put("download", crudProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareMethod(dynaForm, request, "list", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    private static void checkDateFields(DynaValidatorForm dynaForm) {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        if (dynaForm.get("endDate") == null || dynaForm.getString("endDate").length() == 0) {
            dynaForm.set("endDate", (Object)reportingDate.format(cal.getTime()));
        }
        if (dynaForm.get("startDate") == null || dynaForm.getString("startDate").length() == 0) {
            cal.add(2, -1);
            dynaForm.set("startDate", (Object)reportingDate.format(cal.getTime()));
        }
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = ReportingAction.getEntityManager();
        String[] deleteList = (String[])dynaForm.get("deleteReport");
        for (int i = 0; i < deleteList.length; ++i) {
            Integer id = FormUtils.StringToInteger((String)deleteList[i]);
            Report report = (Report)em.find(Report.class, (Object)id);
            if (report != null) {
                em.remove((Object)report);
            }
            em.flush();
        }
        dynaForm.initialize(mapping);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward download(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Report report;
        Integer id = FormUtils.StringToInteger((String)dynaForm.getString("id"));
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
        if (id != null && (report = (Report)em.find(Report.class, (Object)id)) != null) {
            String fileName = reportingDate.format(report.getReportDate()) + "_report_" + id;
            String xml = report.getReportXML();
            if (xml == null || xml.length() == 0) {
                xml = "empty or unfinished";
            }
            response.setContentType(report.getReportMime());
            response.setContentLength(xml.length());
            response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
            PrintWriter pw = response.getWriter();
            pw.print(xml);
        }
        return null;
    }

    public ActionForward create(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = ReportingAction.getEntityManager();
        Date startDate = reportingDate.parse((String)dynaForm.get("startDate"));
        Date endDate = reportingDate.parse((String)dynaForm.get("endDate"));
        String xsl = (String)dynaForm.get("xsl");
        String name = (String)dynaForm.get("name");
        Integer organizationId = (Integer)dynaForm.get("organizationId");
        Organization organization = (Organization)em.find(Organization.class, (Object)organizationId);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("organization", organization);
        parameterMap.put("endDate", endDate);
        parameterMap.put("startDate", startDate);
        parameterMap.put("xsl", xsl);
        parameterMap.put("name", name);
        if (xsl == null || xsl.length() == 0) {
            parameterMap.put("type", "xml");
        } else {
            parameterMap.put("type", "html");
        }
        parameterMap.put("users", organization.getMainUsers());
        ReportThread rtt = new ReportThread();
        rtt.init(parameterMap);
        rtt.start();
        dynaForm.initialize(mapping);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        super.createLists(form, request);
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = ReportingAction.getEntityManager();
        request.setAttribute("organizations", (Object)em.createQuery("FROM Organization AS org ORDER BY org.name ASC").getResultList());
        request.setAttribute("reports", (Object)em.createQuery("FROM Report AS rep ORDER BY rep.reportDate ASC").getResultList());
        ReportingAction.checkDateFields((DynaValidatorForm)form);
    }
}

