/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Iterator;
import nl.b3p.kaartenbalie.core.server.monitoring.DataMonitoring;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.service.ImageCollector;
import nl.b3p.kaartenbalie.service.KBImageTool;
import nl.b3p.kaartenbalie.service.ProviderException;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private ArrayList ics = new ArrayList();

    public ImageManager(ArrayList urlWrapper, DataWrapper dw) {
        if (urlWrapper == null || urlWrapper.isEmpty()) {
            return;
        }
        for (int i = 0; i < urlWrapper.size(); ++i) {
            ServiceProviderRequest wmsRequest = (ServiceProviderRequest)urlWrapper.get(i);
            ImageCollector ic = new ImageCollector(wmsRequest, dw, i);
            this.ics.add(ic);
        }
    }

    public void process() throws Exception {
        ImageCollector ic2 = null;
        for (ImageCollector ic2 : this.ics) {
            if (ic2.getStatus() != 0) continue;
            ic2.processNew();
        }
        for (ImageCollector ic2 : this.ics) {
            if (ic2 == null || !ic2.isAlive()) continue;
            ic2.processWaiting();
        }
    }

    public void sendCombinedImages(DataWrapper dw) throws Exception {
        ImageCollector ic = null;
        Iterator it = this.ics.iterator();
        DataMonitoring rr = dw.getRequestReporting();
        while (it.hasNext()) {
            ic = (ImageCollector)it.next();
            int status = ic.getStatus();
            if (status == 4 || ic.getBufferedImage() == null) {
                throw new ProviderException(ic.getMessage() + " (Status: " + status + ")");
            }
            if (status != 2) {
                this.log.error((Object)(ic.getMessage() + " (Status: " + status + ")"));
            }
            ServiceProviderRequest s = ic.getWmsRequest();
            rr.addServiceProviderRequest(s);
        }
        BufferedImage[] allImages = new BufferedImage[this.ics.size()];
        for (int i = 0; i < this.ics.size(); ++i) {
            ic = (ImageCollector)this.ics.get(i);
            allImages[i] = ic.getBufferedImage();
        }
        KBImageTool.writeImage((BufferedImage[])allImages, (String)"image/png", (DataWrapper)dw);
    }
}

