/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.struts;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.accounting.entity.Account;
import nl.b3p.kaartenbalie.service.LayerValidator;
import nl.b3p.kaartenbalie.service.ServiceProviderValidator;
import nl.b3p.kaartenbalie.struts.KaartenbalieCrudAction;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.wfs.v110.WfsLayer;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.HibernateException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class OrganizationAction
extends KaartenbalieCrudAction {
    private static final String SAVE_RIGHTS = "saveRights";
    private static final String EDIT_RIGHTS = "editRights";
    private static final String LIST_RIGHTS = "listRights";
    private static final String RIGHTSFW = "rights";
    private static final Log logger = LogFactory.getLog(OrganizationAction.class);
    protected static final String ORGANIZATION_LINKED_ERROR_KEY = "error.organizationstilllinked";
    protected static final String CAPABILITY_WARNING_KEY = "warning.saveorganization";
    protected static final String ORG_NOTFOUND_ERROR_KEY = "error.organizationnotfound";
    protected static final String DELETE_ADMIN_ERROR_KEY = "error.deleteadmin";
    protected static final String USER_JOINED_KEY = "beheer.org.user.joined";
    protected static final String CREDITS_JOINED_KEY = "beheer.org.credits.joined";
    protected static final String USER_ORGS_MAINSOORT = "main";

    protected Map getActionMethodPropertiesMap() {
        Map map = super.getActionMethodPropertiesMap();
        ExtendedMethodProperties crudProp = null;
        crudProp = new ExtendedMethodProperties("saveRights");
        crudProp.setDefaultForwardName("rights");
        crudProp.setDefaultMessageKey("warning.crud.savedone");
        crudProp.setAlternateForwardName("rights");
        crudProp.setAlternateMessageKey("error.crud.savefailed");
        map.put("saveRights", crudProp);
        crudProp = new ExtendedMethodProperties("editRights");
        crudProp.setDefaultForwardName("rights");
        crudProp.setAlternateForwardName("rights");
        map.put("editRights", crudProp);
        crudProp = new ExtendedMethodProperties("listRights");
        crudProp.setDefaultForwardName("rights");
        crudProp.setAlternateForwardName("rights");
        map.put("listRights", crudProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareMethod(dynaForm, request, "list", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward listRights(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareMethod(dynaForm, request, "rights", "rights");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Organization organization = this.getOrganization(dynaForm, request, false);
        if (organization == null) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.organizationnotfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateOrganizationForm(organization, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward editRights(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Organization organization = this.getOrganization(dynaForm, request, false);
        this.prepareMethod(dynaForm, request, "rights", "rights");
        if (organization == null) {
            this.addAlternateMessage(mapping, request, "error.organizationnotfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateOrganizationTree(organization, dynaForm, request);
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws HibernateException, Exception {
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = OrganizationAction.getEntityManager();
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        Organization organization = this.getOrganization(dynaForm, request, true);
        if (null == organization) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateOrganizationObject(dynaForm, organization);
        if (organization.getId() == null) {
            em.persist((Object)organization);
        } else {
            em.merge((Object)organization);
        }
        em.flush();
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward saveRights(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws HibernateException, Exception {
        Organization organization = this.getOrganization(dynaForm, request, false);
        if (null == organization) {
            this.prepareMethod(dynaForm, request, "rights", "rights");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        if (!this.isTokenValid(request)) {
            this.populateOrganizationTree(organization, dynaForm, request);
            this.prepareMethod(dynaForm, request, "rights", "rights");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        this.populateOrganizationLayers(dynaForm, organization);
        if (organization.getLayers() != null && !organization.getLayers().isEmpty() && !organization.getHasValidGetCapabilities()) {
            this.addAlternateMessage(mapping, request, null, "warning.saveorganization");
        }
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = OrganizationAction.getEntityManager();
        em.merge((Object)organization);
        em.flush();
        this.populateOrganizationTree(organization, dynaForm, request);
        this.prepareMethod(dynaForm, request, "rights", "rights");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward deleteConfirm(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        BigDecimal cb;
        Account acc;
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = OrganizationAction.getEntityManager();
        Organization organization = this.getOrganization(dynaForm, request, false);
        if (null == organization) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        MessageResources messages = this.getResources(request);
        Locale locale = this.getLocale(request);
        String userJoinedMessage = messages.getMessage(locale, "beheer.org.user.joined");
        String creditsJoinedMessage = messages.getMessage(locale, "beheer.org.credits.joined");
        StringBuffer strMessage = null;
        Set userList = organization.getUsers();
        if (userList != null && !userList.isEmpty()) {
            strMessage = new StringBuffer();
            Iterator it = userList.iterator();
            boolean notFirstUser = false;
            while (it.hasNext()) {
                User u = (User)it.next();
                if (notFirstUser) {
                    strMessage.append(", ");
                } else {
                    strMessage.append(userJoinedMessage);
                    strMessage.append(": ");
                    notFirstUser = true;
                }
                strMessage.append(u.getUsername());
            }
            this.addAlternateMessage(mapping, request, null, strMessage.toString());
        }
        if ((acc = organization.getAccount()) != null && (cb = acc.getCreditBalance()) != null && cb.doubleValue() > 0.0) {
            cb.setScale(2, RoundingMode.HALF_UP);
            strMessage = new StringBuffer();
            strMessage.append(creditsJoinedMessage);
            strMessage.append(": ");
            strMessage.append(cb.toString());
            this.addAlternateMessage(mapping, request, null, strMessage.toString());
        }
        User sessionUser = (User)request.getUserPrincipal();
        Organization sessionOrg = null;
        if (sessionUser != null) {
            sessionOrg = sessionUser.getMainOrganization();
        }
        if (sessionOrg != null && sessionOrg.getId().equals(organization.getId())) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.deleteadmin");
            return this.getAlternateForward(mapping, request);
        }
        this.prepareMethod(dynaForm, request, "delete", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws HibernateException, Exception {
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = OrganizationAction.getEntityManager();
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Organization organization = this.getOrganization(dynaForm, request, false);
        if (null == organization) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        User sessionUser = (User)request.getUserPrincipal();
        Organization sessionOrg = null;
        if (sessionUser != null) {
            sessionOrg = sessionUser.getMainOrganization();
        }
        if (sessionOrg != null && sessionOrg.getId().equals(organization.getId())) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.deleteadmin");
            return this.getAlternateForward(mapping, request);
        }
        Set mainUsers = organization.getMainUsers();
        Iterator it = mainUsers.iterator();
        while (it.hasNext()) {
            User u = (User)it.next();
            em.remove((Object)u);
            it.remove();
        }
        Set users = organization.getUsers();
        Iterator it2 = users.iterator();
        while (it2.hasNext()) {
            User u = (User)it2.next();
            em.remove((Object)u);
            it2.remove();
        }
        em.remove((Object)organization);
        em.flush();
        dynaForm.initialize(mapping);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    protected void populateOrganizationForm(Organization organization, DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        dynaForm.set("id", (Object)organization.getId().toString());
        dynaForm.set("name", (Object)organization.getName());
        dynaForm.set("street", (Object)organization.getStreet());
        dynaForm.set("number", (Object)organization.getNumber());
        dynaForm.set("addition", (Object)organization.getAddition());
        dynaForm.set("postalcode", (Object)organization.getPostalcode());
        dynaForm.set("province", (Object)organization.getProvince());
        dynaForm.set("country", (Object)organization.getCountry());
        dynaForm.set("postbox", (Object)organization.getPostbox());
        dynaForm.set("billingAddress", (Object)organization.getBillingAddress());
        dynaForm.set("visitorsAddress", (Object)organization.getVisitorsAddress());
        dynaForm.set("telephone", (Object)organization.getTelephone());
        dynaForm.set("fax", (Object)organization.getFax());
        dynaForm.set("bbox", (Object)organization.getBbox());
        dynaForm.set("code", (Object)organization.getCode());
        if (organization.getAllowAccountingLayers()) {
            dynaForm.set("allow", (Object)"on");
        } else {
            dynaForm.set("allow", (Object)"");
        }
    }

    protected void populateOrganizationTree(Organization organization, DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        dynaForm.set("id", (Object)organization.getId().toString());
        dynaForm.set("name", (Object)organization.getName());
        StringBuilder checkedLayers = new StringBuilder();
        Set wmsLayers = organization.getLayers();
        Object[] wmsOrganizationLayer = wmsLayers.toArray();
        for (int i = 0; i < wmsOrganizationLayer.length; ++i) {
            checkedLayers.append(",");
            checkedLayers.append(((Layer)wmsOrganizationLayer[i]).getUniqueName());
        }
        Set wfsLayers = organization.getWfsLayers();
        Object[] wfsOrganizationLayer = wfsLayers.toArray();
        for (int i = 0; i < wfsOrganizationLayer.length; ++i) {
            checkedLayers.append(",");
            checkedLayers.append(((WfsLayer)wfsOrganizationLayer[i]).getUniqueName());
        }
        if (checkedLayers.length() > 0) {
            request.setAttribute("checkedLayers", (Object)checkedLayers.substring(1));
        }
        JSONObject root = new JSONObject();
        root.put("name", (Object)"All Services");
        root.put("id", (Object)"allservices");
        JSONArray rootArray = new JSONArray();
        root.put("children", (Object)rootArray);
        JSONObject wmsRoot = OrganizationAction.createTree((String)"WMS Services");
        rootArray.put((Object)wmsRoot);
        JSONObject wfsRoot = OrganizationAction.createWfsTree((String)"WFS Services");
        rootArray.put((Object)wfsRoot);
        request.setAttribute("layerList", (Object)root);
    }

    private void populateOrganizationObject(DynaValidatorForm dynaForm, Organization organization) throws Exception {
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = OrganizationAction.getEntityManager();
        organization.setName(FormUtils.nullIfEmpty((String)dynaForm.getString("name")));
        organization.setStreet(FormUtils.nullIfEmpty((String)dynaForm.getString("street")));
        organization.setNumber(FormUtils.nullIfEmpty((String)dynaForm.getString("number")));
        organization.setAddition(FormUtils.nullIfEmpty((String)dynaForm.getString("addition")));
        organization.setPostalcode(FormUtils.nullIfEmpty((String)dynaForm.getString("postalcode")));
        organization.setProvince(FormUtils.nullIfEmpty((String)dynaForm.getString("province")));
        organization.setCountry(FormUtils.nullIfEmpty((String)dynaForm.getString("country")));
        organization.setPostbox(FormUtils.nullIfEmpty((String)dynaForm.getString("postbox")));
        organization.setBillingAddress(FormUtils.nullIfEmpty((String)dynaForm.getString("billingAddress")));
        organization.setVisitorsAddress(FormUtils.nullIfEmpty((String)dynaForm.getString("visitorsAddress")));
        organization.setTelephone(FormUtils.nullIfEmpty((String)dynaForm.getString("telephone")));
        organization.setFax(FormUtils.nullIfEmpty((String)dynaForm.getString("fax")));
        String bbox = FormUtils.nullIfEmpty((String)dynaForm.getString("bbox"));
        if (bbox != null) {
            String[] boxxvalues = bbox.split(",");
            if (boxxvalues.length != 4) {
                logger.error((Object)("BBOX wrong size: " + boxxvalues.length));
                throw new Exception(KBConfiguration.BBOX_EXCEPTION + " Usage: minx,miny,maxx,maxy");
            }
            double minx = 0.0;
            double miny = 0.0;
            double maxx = -1.0;
            double maxy = -1.0;
            try {
                minx = Double.parseDouble(boxxvalues[0]);
                miny = Double.parseDouble(boxxvalues[1]);
                maxx = Double.parseDouble(boxxvalues[2]);
                maxy = Double.parseDouble(boxxvalues[3]);
                if (minx > maxx || miny > maxy) {
                    logger.error((Object)("BBOX values out of range (minx, miny, maxx, maxy): " + minx + ", " + miny + ", " + maxx + ", " + maxy));
                    throw new Exception("BBOX values out of range (minx, miny, maxx, maxy): " + minx + ", " + miny + ", " + maxx + ", " + maxy);
                }
            }
            catch (Exception e) {
                logger.error((Object)("BBOX error minx, miny, maxx, maxy: " + minx + ", " + miny + ", " + maxx + ", " + maxy));
                throw new Exception(KBConfiguration.BBOX_EXCEPTION + " Usage: minx,miny,maxx,maxy");
            }
        }
        organization.setBbox(bbox);
        organization.setCode(FormUtils.nullIfEmpty((String)dynaForm.getString("code")));
        if ("on".equalsIgnoreCase(FormUtils.nullIfEmpty((String)dynaForm.getString("allow")))) {
            organization.setAllowAccountingLayers(true);
        } else {
            organization.setAllowAccountingLayers(false);
        }
        organization.setHasValidGetCapabilities(true);
    }

    private void populateOrganizationLayers(DynaValidatorForm dynaForm, Organization organization) throws Exception {
        HashSet<Layer> wmsLayers = new HashSet<Layer>();
        HashSet<WfsLayer> wfsLayers = new HashSet<WfsLayer>();
        HashSet<ServiceProvider> wmsServiceProviders = new HashSet<ServiceProvider>();
        for (String layerName : (String[])dynaForm.get("selectedLayers")) {
            Layer wmsl;
            WfsLayer wfsl = this.getWfsLayerByUniqueName(layerName);
            if (wfsl != null) {
                wfsLayers.add(wfsl);
            }
            if ((wmsl = this.getLayerByUniqueName(layerName)) == null) continue;
            wmsLayers.add(wmsl);
            ServiceProvider sp = wmsl.getServiceProvider();
            if (wmsServiceProviders.contains(sp)) continue;
            wmsServiceProviders.add(sp);
        }
        if (!wmsServiceProviders.isEmpty()) {
            LayerValidator lv = new LayerValidator(wmsLayers);
            ServiceProviderValidator spv = new ServiceProviderValidator(wmsServiceProviders);
            organization.setHasValidGetCapabilities(lv.validate() && spv.validate());
        }
        organization.setWfsLayers(wfsLayers);
        organization.setLayers(wmsLayers);
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws HibernateException, JSONException, Exception {
        super.createLists(form, request);
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = OrganizationAction.getEntityManager();
        List organizationlist = em.createQuery("from Organization order by name").getResultList();
        request.setAttribute("organizationlist", (Object)organizationlist);
    }

    protected Organization getOrganization(DynaValidatorForm dynaForm, HttpServletRequest request, boolean createNew) throws Exception {
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = OrganizationAction.getEntityManager();
        Organization organization = null;
        Integer id = this.getID(dynaForm);
        if (null == id && createNew) {
            organization = new Organization();
        } else if (null != id) {
            organization = (Organization)em.find(Organization.class, (Object)id);
        }
        return organization;
    }

    private Integer getID(DynaValidatorForm dynaForm) {
        return FormUtils.StringToInteger((String)dynaForm.getString("id"));
    }
}

