/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.struts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.kaartenbalie.core.server.accounting.ExtLayerCalculator;
import nl.b3p.kaartenbalie.core.server.accounting.entity.LayerPriceComposition;
import nl.b3p.kaartenbalie.struts.TestPricingAction;
import nl.b3p.kaartenbalie.struts.WfsPricingAction;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.wfs.v110.WfsLayer;
import nl.b3p.ogc.wfs.v110.WfsServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

public class WfsTestPricingAction
extends TestPricingAction {
    private static final Log log = LogFactory.getLog(WfsPricingAction.class);
    private static final String START_END_ERROR_KEY = "error.dateinput";
    private static final String LAYER_PLACEHOLDER_ERROR_KEY = "beheer.princing.placeholder.error";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward test(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int testSteps;
        BigDecimal testStepSize;
        Date testFrom = FormUtils.FormStringToDate((String)dynaForm.getString("testFrom"), null);
        Date testUntil = FormUtils.FormStringToDate((String)dynaForm.getString("testUntil"), null);
        if (testUntil != null && testFrom != null && testUntil.before(testFrom)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, START_END_ERROR_KEY);
            return this.getAlternateForward(mapping, request);
        }
        WfsLayer layer = null;
        String id = FormUtils.nullIfEmpty((String)this.getLayerID(dynaForm));
        if (id != null) {
            layer = this.getWfsLayerByUniqueName(id);
        }
        if (layer == null || layer.getName() == null || layer.getName().trim().length() == 0) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, LAYER_PLACEHOLDER_ERROR_KEY);
            return this.getAlternateForward(mapping, request);
        }
        String layerName = layer.getName();
        String spAbbr = layer.getSpAbbr();
        String projection = dynaForm.getString("testProjection");
        if (projection != null && projection.trim().length() == 0) {
            projection = null;
        }
        if (projection == null) {
            log.error((Object)"Projection is required!");
            throw new Exception("Projection is required!");
        }
        BigDecimal testScale = FormUtils.bdValueNull((String)dynaForm.getString("testScale"));
        if (testScale == null || testScale.doubleValue() <= 0.0) {
            testScale = new BigDecimal("100000.0");
        }
        if ((testStepSize = FormUtils.bdValueNull((String)dynaForm.getString("testStepSize"))) == null || testStepSize.doubleValue() <= 0.0) {
            testStepSize = new BigDecimal("100000.0");
        }
        if ((testSteps = FormUtils.StringToInt((String)dynaForm.getString("testSteps"))) > 20 || testSteps <= 0) {
            testSteps = 20;
        }
        ExtLayerCalculator lc = new ExtLayerCalculator();
        try {
            ArrayList<Date> testDates = new ArrayList<Date>();
            Calendar cal = Calendar.getInstance();
            cal.setTime(testFrom);
            int maxDays = 7;
            testDates.add(new Date());
            for (int dayCounter = 0; cal.getTime().before(testUntil) && dayCounter < maxDays; ++dayCounter) {
                Date testDate = cal.getTime();
                testDates.add(testDate);
                cal.add(6, 1);
            }
            ArrayList resultSet = new ArrayList();
            ArrayList<BigDecimal> scaleSet = new ArrayList<BigDecimal>();
            for (int i = 0; i < testSteps; ++i) {
                ArrayList<LayerPriceComposition> subSet = new ArrayList<LayerPriceComposition>();
                Iterator iterDates = testDates.iterator();
                scaleSet.add(testScale);
                while (iterDates.hasNext()) {
                    Date testDate = (Date)iterDates.next();
                    LayerPriceComposition lpc = lc.calculateLayerComplete(spAbbr, layerName, testDate, projection, testScale, new BigDecimal(1), 1, "WFS", "GetFeature");
                    subSet.add(lpc);
                }
                testScale = testScale.add(testStepSize);
                resultSet.add(subSet);
            }
            request.setAttribute("resultSet", resultSet);
            request.setAttribute("testDates", testDates);
            request.setAttribute("scaleSet", scaleSet);
        }
        finally {
            lc.closeEntityManager();
        }
        this.prepareMethod(dynaForm, request, "list", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        super.createLists(form, request);
        request.setAttribute("projections", (Object)KBConfiguration.SUPPORTED_PROJECTIONS);
        WfsLayer layer = null;
        String id = FormUtils.nullIfEmpty((String)this.getLayerID(form));
        if (id != null) {
            layer = this.getWfsLayerByUniqueName(id);
        }
        if (layer == null || layer.getName() == null) {
            return;
        }
        WfsServiceProvider sp = layer.getWfsServiceProvider();
        request.setAttribute("spName", (Object)sp.getTitle());
        request.setAttribute("lName", (Object)layer.getName());
    }
}

