/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.util;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.wms.capabilities.Roles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LDAPUtil {
    protected static Log log = LogFactory.getLog(LDAPUtil.class);

    public boolean userInLdap(String host, int port, String user, String password, String suffix) {
        String userDN = user + suffix;
        try {
            LDAPConnection conn = new LDAPConnection(host, port, userDN, password);
            return true;
        }
        catch (LDAPException ex) {
            log.debug((Object)"Fout tijdens bind ldap: ", (Throwable)ex);
            return false;
        }
    }

    public Date getDefaultTimeOut(int months) {
        GregorianCalendar gc = new GregorianCalendar();
        ((Calendar)gc).setTimeZone(TimeZone.getTimeZone("GMT"));
        ((Calendar)gc).add(2, months);
        return gc.getTime();
    }

    public Organization getLDAPOrg(EntityManager em, String orgName) {
        Organization org = null;
        try {
            org = (Organization)em.createQuery("from Organization o where lower(o.name) = lower(:orgName) ").setParameter("orgName", (Object)orgName).getSingleResult();
        }
        catch (Exception ex) {
            log.debug((Object)"Fout tijdens ophalen ldap org: ", (Throwable)ex);
        }
        return org;
    }

    public User getUserByName(EntityManager em, String username) {
        User user = null;
        try {
            user = (User)em.createQuery("from User u where lower(u.username) = lower(:username) ").setParameter("username", (Object)username).getSingleResult();
        }
        catch (Exception ex) {
            log.debug((Object)"Fout tijdens ophalen ldap user uit db: ", (Throwable)ex);
        }
        return user;
    }

    public List<Roles> getGebruikerRol(EntityManager em) {
        return em.createQuery("from Roles where id in (:ids)").setParameter("ids", (Object)2).getResultList();
    }
}

