/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.server.persistence;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import nl.b3p.kaartenbalie.core.server.accounting.AccountManager;
import nl.b3p.kaartenbalie.core.server.monitoring.DataMonitoring;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.ogc.utils.KBConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class MyEMFDatabase
extends HttpServlet {
    public static final String MAPFILE_DIR = "global.mapfile.dir";
    public static final String UPLOAD_DIR = "global.upload.dir";
    public static final String DEFAULT_ORGANIZATION = "default.organization";
    public static final String LDAP_USELDAP = "ldap.useldap";
    public static final String LDAP_DEFAULTGROUP = "ldap.default.group";
    public static final String LDAP_HOST = "ldap.host";
    public static final String LDAP_PORT = "ldap.port";
    public static final String LDAP_USERSUFFIX = "ldap.usersuffix";
    public static final String USER_UPDATELASTLOGINSTATUS = "user.updateLastLoginStatus";
    private static String mapfiles = null;
    private static String upload = null;
    private static String defaultOrganization = null;
    private static Boolean ldapUseLdap = false;
    private static String ldapDefaultGroup = null;
    private static String ldapHost = null;
    private static Integer ldapPort = null;
    private static String ldapUserSuffix = null;
    private static final Log log = LogFactory.getLog(MyEMFDatabase.class);
    public static final String MAIN_EM = "mainEM";
    public static final String INIT_EM = "initEM";
    public static final String REALM_EM = "realmEM";
    public static final String DWR_EM = "dwrEM";
    public static final String SLD_EM = "sldEM";
    private static EntityManagerFactory emf = null;
    private static ThreadLocal tlMap = new ThreadLocal();
    private static String defaultKaartenbaliePU = "defaultKaartenbaliePU";
    private static String cachePath = null;
    private static Random rg = null;
    private static String[] allowedUploadFiles = null;
    private static final Owner trueOwner = new Owner(true);
    private static final Owner fakeOwner = new Owner(false);

    public static void openEntityManagerFactory(String persistenceUnit) throws Exception {
        log.debug((Object)("ManagedPersistence.openEntityManagerFactory(" + persistenceUnit + ")"));
        if (emf != null) {
            log.warn((Object)("EntityManagerFactory already initialized: " + emf.toString()));
            return;
        }
        if (persistenceUnit == null || persistenceUnit.trim().length() == 0) {
            throw new Exception("PersistenceUnit cannot be left empty.");
        }
        try {
            emf = Persistence.createEntityManagerFactory((String)persistenceUnit);
        }
        catch (Throwable t) {
            log.fatal((Object)"Error initializing EntityManagerFactory: ", t);
        }
        if (emf == null) {
            log.fatal((Object)"Cannot initialize EntityManagerFactory");
            throw new Exception("Cannot initialize EntityManagerFactory");
        }
        log.debug((Object)("EntityManagerFactory initialized: " + emf.toString()));
    }

    public static EntityManagerFactory getEntityManagerFactory() throws Exception {
        if (emf == null) {
            MyEMFDatabase.openEntityManagerFactory((String)defaultKaartenbaliePU);
        }
        return emf;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        DataMonitoring.setEnableMonitoring((boolean)MyEMFDatabase.getConfigValue((ServletConfig)config, (String)"reporting", (String)"disabled").equalsIgnoreCase("enabled"));
        AccountManager.setEnableAccounting((boolean)MyEMFDatabase.getConfigValue((ServletConfig)config, (String)"accounting", (String)"disabled").equalsIgnoreCase("enabled"));
        Object identity = null;
        try {
            MyEMFDatabase.openEntityManagerFactory((String)defaultKaartenbaliePU);
            identity = MyEMFDatabase.createEntityManager((String)"initEM");
            log.debug((Object)"Getting entity manager ......");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"initEM");
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            tx.commit();
        }
        catch (Throwable e) {
            log.warn((Object)"Error creating EntityManager: ", e);
            throw new ServletException(e);
        }
        finally {
            log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"initEM");
        }
        cachePath = MyEMFDatabase.getConfigValue((ServletConfig)config, (String)"cache", (String)"/");
        if (cachePath != null) {
            cachePath = this.getServletContext().getRealPath(cachePath);
            log.debug((Object)("cache pad: " + cachePath));
        }
        rg = new Random();
        String allowedUpload = config.getInitParameter("allowed_upload_files");
        if (allowedUpload != null && allowedUpload.length() > 0) {
            allowedUploadFiles = allowedUpload.split(",");
        }
        this.initGlobalContextParams(config);
        KBConfiguration.configure();
    }

    public void initGlobalContextParams(ServletConfig config) {
        ServletContext context = config.getServletContext();
        String value = context.getInitParameter("global.mapfile.dir");
        if (value != null && value.length() > 0) {
            mapfiles = value;
        }
        if ((value = context.getInitParameter("global.upload.dir")) != null && value.length() > 0) {
            upload = value;
        }
        if ((value = context.getInitParameter("default.organization")) != null && value.length() > 0) {
            defaultOrganization = value;
        }
        if ((value = context.getInitParameter("ldap.useldap")) != null && value.length() > 0) {
            ldapUseLdap = new Boolean(value);
        }
        if ((value = context.getInitParameter("ldap.default.group")) != null && value.length() > 0) {
            ldapDefaultGroup = value;
        }
        if ((value = context.getInitParameter("ldap.host")) != null && value.length() > 0) {
            ldapHost = value;
        }
        if ((value = context.getInitParameter("ldap.port")) != null && value.length() > 0) {
            ldapPort = new Integer(value);
        }
        if ((value = context.getInitParameter("ldap.usersuffix")) != null && value.length() > 0) {
            ldapUserSuffix = value;
        }
    }

    private static String getConfigValue(ServletConfig config, String parameter, String defaultValue) {
        String tmpval = config.getInitParameter(parameter);
        if (tmpval == null || tmpval.trim().length() == 0) {
            tmpval = defaultValue;
        }
        log.debug((Object)("ManagedPersistence.getConfigValue(config, " + parameter + ", " + tmpval + ")"));
        return tmpval.trim();
    }

    public static Object createEntityManager(String emKey) throws Exception {
        EntityManager localEm = (EntityManager)MyEMFDatabase.getThreadLocal((String)emKey);
        if (localEm == null) {
            log.debug((Object)("No EntityManager Found - Create and give the identity for key: " + emKey));
            localEm = MyEMFDatabase.getEntityManagerFactory().createEntityManager();
            if (localEm == null) {
                throw new Exception("EntityManager could not be initialized for key: " + emKey);
            }
            MyEMFDatabase.setThreadLocal((String)emKey, (Object)localEm);
            return trueOwner;
        }
        log.debug((Object)("EntityManager Found - Give a Fake identity for key: " + emKey));
        return fakeOwner;
    }

    public static EntityManager getEntityManager(String emKey) throws Exception {
        EntityManager localEm = (EntityManager)MyEMFDatabase.getThreadLocal((String)emKey);
        if (localEm == null) {
            throw new Exception("EntityManager could not be initialized for key: " + emKey);
        }
        return localEm;
    }

    public static void closeEntityManager(Object ownership, String emKey) {
        if (ownership != null && ((Owner)ownership).identity) {
            log.debug((Object)("Identity is accepted. Now closing the session for key: " + emKey));
            EntityManager localEm = (EntityManager)MyEMFDatabase.getThreadLocal((String)emKey);
            if (localEm == null) {
                log.warn((Object)("EntityManager is missing. Either it's already closed or never initialized for key: " + emKey));
                return;
            }
            MyEMFDatabase.clearThreadLocal((String)emKey);
            localEm.close();
        } else {
            log.debug((Object)("Identity is rejected. Ignoring the request for key: " + emKey));
        }
    }

    private static void initThreadLocal() {
        tlMap.set(new HashMap());
    }

    private static void clearThreadLocal(String key) {
        Map threadLocalMap = (Map)tlMap.get();
        threadLocalMap.remove(key);
    }

    private static void setThreadLocal(String key, Object object) {
        if (tlMap.get() == null) {
            MyEMFDatabase.initThreadLocal();
        }
        Map threadLocalMap = (Map)tlMap.get();
        threadLocalMap.put(key, object);
    }

    private static Object getThreadLocal(String key) {
        if (tlMap.get() == null) {
            MyEMFDatabase.initThreadLocal();
            return null;
        }
        Map threadLocalMap = (Map)tlMap.get();
        return threadLocalMap.get(key);
    }

    public static String localPath() {
        return MyEMFDatabase.localPath(null);
    }

    public static String localPath(String fileName) {
        if (fileName == null) {
            fileName = "";
        }
        if (!fileName.startsWith(File.separator)) {
            fileName = File.separator + fileName;
        }
        return cachePath + fileName;
    }

    public static String uniqueName(String prefix, String extension) {
        return MyEMFDatabase.uniqueName((String)prefix, (String)extension, (boolean)false);
    }

    public static String uniqueName(String prefix, String extension, boolean includePath) {
        long now = new Date().getTime();
        String val1 = Long.toString(now, 36).toUpperCase();
        if (rg == null) {
            rg = new Random();
        }
        long rnum = rg.nextInt(1000);
        String val2 = Long.toString(rnum, 36).toUpperCase();
        String thePath = "";
        if (includePath) {
            thePath = cachePath;
        }
        if (prefix == null) {
            prefix = "";
        }
        if (extension == null) {
            extension = "";
        }
        return thePath + prefix + val1 + val2 + extension;
    }

    public static String[] getAllowedUploadFiles() {
        return allowedUploadFiles;
    }

    public static String getMapfiles() {
        return mapfiles;
    }

    public static String getUpload() {
        return upload;
    }

    public static String getDefaultOrganization() {
        return defaultOrganization;
    }

    public static Boolean getLdapUseLdap() {
        return ldapUseLdap;
    }

    public static String getLdapDefaultGroup() {
        return ldapDefaultGroup;
    }

    public static String getLdapHost() {
        return ldapHost;
    }

    public static Integer getLdapPort() {
        return ldapPort;
    }

    public static String getLdapUserSuffix() {
        return ldapUserSuffix;
    }
}

