/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.core.webdav;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.persistence.EntityManager;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.core.webdav.MetadataFileResource;
import nl.b3p.kaartenbalie.core.webdav.MetadataResource;
import nl.b3p.kaartenbalie.core.webdav.MetadataResourceFactory;
import nl.b3p.wms.capabilities.Layer;

public class MetadataFolderResource
extends MetadataResource
implements CollectionResource {
    protected Map<String, Resource> childs = null;

    public Resource child(String childName) {
        if (this.childs == null) {
            this.createChildmap();
            if (this.childs == null) {
                return null;
            }
        }
        return (Resource)this.childs.get(childName);
    }

    public List<Resource> getChildren() {
        if (this.childs == null) {
            this.createChildmap();
            if (this.childs == null) {
                return null;
            }
        }
        ArrayList<Resource> l = new ArrayList<Resource>();
        l.addAll(this.childs.values());
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createChildmap() {
        this.childs = new TreeMap();
        Object identity = null;
        try {
            identity = MyEMFDatabase.createEntityManager((String)"initEM");
            this.log.debug((Object)"Getting entity manager ......");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"initEM");
            User lUser = (User)em.find(User.class, (Object)this.user.getId());
            Set orgs = lUser.getAllOrganizations();
            for (Organization org : orgs) {
                Set ll = org.getLayers();
                for (Layer l : ll) {
                    if (l.getMetadata() == null) continue;
                    this.childs.put(MetadataResourceFactory.createName((Layer)l), new MetadataFileResource(l));
                }
            }
        }
        catch (Throwable e) {
            this.log.warn((Object)"Error creating EntityManager: ", e);
        }
        finally {
            this.log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"initEM");
        }
    }
}

