/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.reporting;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.logger.Log4JLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.Driver;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.messaging.MessageHandler;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

/*
 * Exception performing whole class analysis ignored.
 */
public class CastorXmlTransformer {
    protected static Log log = LogFactory.getLog(CastorXmlTransformer.class);
    protected static org.apache.log4j.Logger fopLogger = org.apache.log4j.Logger.getLogger((String)"fop");
    private static final String ENCODING = "ISO-8859-1";
    public static final String HTML = "html";
    public static final String XSL = "xsl";
    public static final String PDF = "pdf";
    public static final String XML = "xml";
    private static Map contentTypes = new HashMap();
    private String xslField = null;
    private String xsdField = null;
    private String xslHttpPath = null;
    private String xslFilePath = null;

    public static Map getContentTypes() {
        return contentTypes;
    }

    public CastorXmlTransformer() {
        this(null, null);
    }

    public CastorXmlTransformer(String xslField, String xslFilePath) {
        this(xslField, null, null, xslFilePath);
    }

    public CastorXmlTransformer(String xslField, String xsdField, String xslHttpPath, String xslFilePath) {
        this.xslField = xslField;
        this.xsdField = xsdField;
        this.xslHttpPath = xslHttpPath;
        this.xslFilePath = xslFilePath;
    }

    public String createXml(Object rapport) throws Exception {
        StringWriter xmlString = new StringWriter();
        try {
            Marshaller marshal = new Marshaller((Writer)xmlString);
            marshal.setEncoding("ISO-8859-1");
            marshal.marshal(rapport);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        return xmlString.toString();
    }

    public String createHtml(Object rapport) throws Exception {
        String xslFullPath = this.findXslFilePath();
        if (xslFullPath == null) {
            return null;
        }
        StringWriter xmlString = new StringWriter();
        SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        log.debug((Object)("transformer used: " + tFactory.getClass().getName()));
        try {
            TransformerHandler tHandler = tFactory.newTransformerHandler(new StreamSource(xslFullPath));
            tHandler.setResult(new StreamResult(xmlString));
            Marshaller marshal = new Marshaller((ContentHandler)tHandler);
            marshal.marshal(rapport);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        return xmlString.toString();
    }

    public String createXsl(Object rapport) throws Exception {
        String xslFullPath = this.findXslHttpPath();
        StringWriter xmlString = new StringWriter();
        Marshaller marshal = new Marshaller((Writer)xmlString);
        if (xslFullPath != null) {
            String xslURL = xslFullPath + this.xslField;
            marshal.addProcessingInstruction("xml-stylesheet", "type='text/xsl' href='" + xslURL + "'");
            log.debug((Object)(" Adding xsl url to xml for local transformation: " + xslURL));
        }
        if (this.xsdField != null && this.xsdField.length() > 0) {
            String xsdURL = this.xslHttpPath + this.xsdField;
            marshal.setNoNamespaceSchemaLocation(xsdURL);
        }
        marshal.setEncoding("ISO-8859-1");
        marshal.marshal(rapport);
        return xmlString.toString();
    }

    public ByteArrayOutputStream createPdf(Object rapport) throws Exception {
        String xslFullPath = this.findXslFilePath();
        if (xslFullPath == null) {
            return null;
        }
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        File xslFile = new File(xslFullPath);
        File xmlPath = new File(xslFile.getParent());
        SAXSource xslSource = new SAXSource(new InputSource(new FileInputStream(xslFile)));
        xslSource.setSystemId(xmlPath.toURI().toString());
        Configuration.put((String)"baseDir", (Object)xmlPath.getCanonicalPath());
        CastorXmlTransformer.objectToPDF((Object)rapport, (Source)xslSource, (OutputStream)byteArray, (boolean)true);
        return byteArray;
    }

    public static void objectToPDF(Object marshallable, Source xslFopSource, OutputStream out, boolean validateMarshal) throws TransformerConfigurationException, IOException, MarshalException, ValidationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (!transformerFactory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            throw new UnsupportedOperationException("SAXTransformerFactory required");
        }
        SAXTransformerFactory saxTransformerFactory = (SAXTransformerFactory)transformerFactory;
        TransformerHandler transformer = saxTransformerFactory.newTransformerHandler(xslFopSource);
        Driver driver = new Driver();
        Log4JLogger logger = new Log4JLogger(fopLogger);
        driver.setLogger((Logger)logger);
        MessageHandler.setScreenLogger((Logger)logger);
        driver.setRenderer(1);
        driver.setOutputStream(out);
        SAXResult res = new SAXResult(driver.getContentHandler());
        transformer.setResult(res);
        Marshaller marshaller = new Marshaller((ContentHandler)transformer);
        marshaller.setValidation(validateMarshal);
        marshaller.marshal(marshallable);
    }

    protected String findXslFilePath() throws Exception {
        boolean xslFileAvailable = false;
        try {
            File file = new File(this.xslFilePath + this.xslField);
            if (file.exists()) {
                xslFileAvailable = true;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!xslFileAvailable) {
            throw new Exception("xsl file is ongeldig: " + this.xslFilePath + this.xslField);
        }
        return this.xslFilePath + this.xslField;
    }

    protected String findXslHttpPath() throws Exception {
        boolean xslHttpAvailable = false;
        File file = new File(this.xslHttpPath + this.xslField);
        if (file.exists()) {
            xslHttpAvailable = true;
        }
        if (!xslHttpAvailable) {
            throw new Exception("xsl file is ongeldig: " + this.xslHttpPath + this.xslField);
        }
        return this.xslHttpPath + this.xslField;
    }

    static {
        CastorXmlTransformer.getContentTypes().put("html", "text/html");
        CastorXmlTransformer.getContentTypes().put("xsl", "text/xml");
        CastorXmlTransformer.getContentTypes().put("pdf", "application/pdf");
        CastorXmlTransformer.getContentTypes().put("xml", "text/xml");
    }
}

