/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.commons.xml.IgnoreEntityResolver;
import nl.b3p.kaartenbalie.core.server.b3pLayering.ConfigLayer;
import nl.b3p.kaartenbalie.core.server.b3pLayering.ExceptionLayer;
import nl.b3p.kaartenbalie.core.server.monitoring.ServiceProviderRequest;
import nl.b3p.kaartenbalie.service.ImageCollector;
import nl.b3p.kaartenbalie.service.KBImageTool;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.wms.capabilities.ElementHandler;
import nl.b3p.wms.capabilities.Switcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ImageCollector
extends Thread {
    private static final Log log = LogFactory.getLog(ImageCollector.class);
    private static final int maxResponseTime = new Integer(KBConfiguration.WMS_RESPONSE_TIME_LIMIT);
    public static final int NEW = 0;
    public static final int ACTIVE = 1;
    public static final int COMPLETED = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    private int status = 0;
    private String message = null;
    private BufferedImage bufferedImage;
    private static Stack stack = new Stack();
    private ServiceProviderRequest wmsRequest;
    private DataWrapper dw;
    private int index;
    private B3PCredentials credentials;

    public ImageCollector(ServiceProviderRequest wmsRequest, DataWrapper dw, int index) {
        this.wmsRequest = wmsRequest;
        this.dw = dw;
        this.index = index;
        this.setMessage("Request started ...");
        this.credentials = this.wmsRequest.getCredentials();
    }

    public void processNew() throws InterruptedException {
        this.status = 1;
        this.start();
    }

    public void processWaiting() throws InterruptedException {
        this.join((long)(maxResponseTime * 5));
        if (this.status == 1) {
            this.handleRequestException(new Exception("Provider did not respond in due time!"));
            this.getWmsRequest().setRequestResponseTime(new Long(maxResponseTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Date operationStart = new Date();
        Date operationEnd = null;
        String url = this.getWmsRequest().getProviderRequestURI();
        log.debug((Object)("Outgoing URL: " + url));
        if (url.startsWith(KBConfiguration.SERVICEPROVIDER_BASE_HTTP)) {
            try {
                this.setBufferedImage(ConfigLayer.handleRequest((String)url, (Map)this.dw.getLayeringParameterMap()));
                this.setStatus(2);
            }
            catch (Exception ex) {
                this.handleRequestException(ex);
            }
        } else {
            try {
                HttpClientConfigured hcc = new HttpClientConfigured(this.credentials);
                HttpGet httpget = new HttpGet(url);
                HttpResponse response = hcc.execute((HttpUriRequest)httpget);
                try {
                    HttpEntity entity = response.getEntity();
                    int statusCode = response.getStatusLine().getStatusCode();
                    this.getWmsRequest().setBytesSent(new Long(url.getBytes().length));
                    this.getWmsRequest().setResponseStatus(Integer.valueOf(statusCode));
                    if (statusCode != 200 || entity == null) {
                        throw new Exception("Error connecting to server. HTTP status code: " + statusCode);
                    }
                    String mime = entity.getContentType().getValue();
                    if (mime.equalsIgnoreCase("application/vnd.ogc.se_xml")) {
                        InputStream is = entity.getContent();
                        throw new Exception(ImageCollector.getServiceException((InputStream)is));
                    }
                    InputStream instream = entity.getContent();
                    this.setBufferedImage(KBImageTool.readImage((InputStream)instream, (String)mime, (ServiceProviderRequest)this.getWmsRequest()));
                }
                finally {
                    hcc.close(response);
                    hcc.close();
                }
                this.setMessage("");
                this.setStatus(2);
            }
            catch (Exception ex) {
                this.handleRequestException(ex);
            }
        }
        operationEnd = new Date();
        this.getWmsRequest().setRequestResponseTime(new Long(operationEnd.getTime() - operationStart.getTime()));
    }

    private void handleRequestException(Exception ex) {
        log.error((Object)"error callimage collector: ", (Throwable)ex);
        OGCRequest ogcr = this.dw.getOgcrequest();
        if (ogcr.containsParameter("EXCEPTIONS") && "application/vnd.ogc.se_xml".equalsIgnoreCase(ogcr.getParameter("EXCEPTIONS"))) {
            this.setMessage(ex.getMessage());
            this.setStatus(4);
        } else {
            try {
                ExceptionLayer el = new ExceptionLayer();
                HashMap<String, Object> parameterMap = new HashMap<String, Object>();
                parameterMap.put("type", ex.getClass());
                parameterMap.put("message", ex.getMessage());
                parameterMap.put("stacktrace", ex.getStackTrace());
                parameterMap.put("transparant", Boolean.TRUE);
                parameterMap.put("index", new Integer(this.index));
                this.setBufferedImage(el.drawImage(ogcr, parameterMap));
                this.setMessage(ex.getMessage());
                this.setStatus(3);
            }
            catch (Exception e) {
                log.error((Object)"error during callimage collector error handling: ", (Throwable)e);
                this.setMessage(e.getMessage());
                this.setStatus(4);
            }
        }
    }

    public BufferedImage getBufferedImage() {
        return this.bufferedImage;
    }

    public void setBufferedImage(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getUrl() {
        return this.getWmsRequest().getProviderRequestURI();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private static String getServiceException(InputStream byteStream) throws IOException, SAXException {
        Switcher s = new Switcher();
        s.setElementHandler("ServiceException", (ElementHandler)new ServiceExceptionHandler(null));
        XMLReader reader = XMLReaderFactory.createXMLReader();
        IgnoreEntityResolver r = new IgnoreEntityResolver();
        reader.setEntityResolver((EntityResolver)r);
        reader.setContentHandler((ContentHandler)s);
        InputSource is = new InputSource(byteStream);
        is.setEncoding("UTF-8");
        reader.parse(is);
        return (String)stack.pop();
    }

    public ServiceProviderRequest getWmsRequest() {
        return this.wmsRequest;
    }

    static /* synthetic */ Stack access$100() {
        return stack;
    }
}

