/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.Query;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.MapParser;
import nl.b3p.kaartenbalie.struts.WmsServerAction;
import nl.b3p.wms.capabilities.ServiceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;

public class MapFileListener
implements FileListener {
    public Map<String, Integer> namesMap = new HashMap();
    private Log log = LogFactory.getLog(this.getClass());
    private String organization;

    public MapFileListener(String organization) {
        this.organization = organization;
    }

    public void fileCreated(FileChangeEvent event) throws Exception {
        File mapPath = new File(event.getFile().getURL().getFile());
        if (mapPath.getName().indexOf(".map") != -1) {
            MapParser mapParser = new MapParser(mapPath);
            mapParser.parse();
            Map metadata = mapParser.getWebMetadata();
            String url = (String)metadata.get("wms_onlineresource");
            String mapfilename = mapPath.getName().substring(0, mapPath.getName().indexOf("."));
            mapfilename = mapfilename.replaceAll(" ", "_");
            this.saveServiceProvider(url, mapfilename);
        }
        event.getFile().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveServiceProvider(String wmsUrl, String name) {
        Object identity = null;
        try {
            identity = MyEMFDatabase.createEntityManager((String)"mainEM");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
            EntityTransaction tx = em.getTransaction();
            tx.begin();
            try {
                String getCap = "&service=WMS&request=GetCapabilities&version=1.1.1";
                Long number = this.getUniqueAbbr(name, em);
                String abbr = name + number;
                ServiceProvider saveServiceProvider = WmsServerAction.saveServiceProvider((String)(wmsUrl + getCap), null, (String)name, (String)abbr, (EntityManager)em);
                Organization org = (Organization)em.createQuery("FROM Organization WHERE name = :name").setParameter("name", (Object)this.organization).getSingleResult();
                WmsServerAction.addAllLayersToGroup((Organization)org, (ServiceProvider)saveServiceProvider, (EntityManager)em);
                tx.commit();
            }
            catch (Exception ex) {
                tx.rollback();
                this.log.error((Object)"Kan nieuwe server niet posten", (Throwable)ex);
            }
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception occured while getting EntityManager: ", e);
        }
        finally {
            this.log.debug((Object)"Closing entity manager .....");
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"mainEM");
        }
    }

    private Long getUniqueAbbr(String name, EntityManager em) {
        Query q = em.createQuery("SELECT COUNT(*) FROM ServiceProvider WHERE givenName like :name").setParameter("name", (Object)('%' + name + '%'));
        Long number = (Long)q.getSingleResult();
        number = number + 1L;
        return number;
    }

    public void fileDeleted(FileChangeEvent event) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void fileChanged(FileChangeEvent event) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

