/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.wms.capabilities.ContactInformation;
import nl.b3p.wms.capabilities.ServiceDomainResource;
import nl.b3p.wms.capabilities.ServiceProvider;

public class ServiceProviderValidator {
    private Set serviceProviders;

    public ServiceProviderValidator(Set serviceProviders) {
        this.setServiceProviders(serviceProviders);
    }

    public ServiceProvider getValidServiceProvider() {
        ServiceProvider newSP = new ServiceProvider();
        this.fillServiceProviderConstants(newSP);
        Set<ServiceDomainResource> resources = new HashSet();
        if (this.serviceProviders != null && !this.serviceProviders.isEmpty()) {
            String[] domains = this.validateDomains();
            for (int i = 0; i < domains.length; ++i) {
                String domain = domains[i];
                if (domain == null || "null".equalsIgnoreCase(domain)) continue;
                String[] f = this.validateFormats(domain);
                ServiceDomainResource sdr = new ServiceDomainResource();
                sdr.setDomain(domain);
                HashSet<String> formats = new HashSet<String>();
                for (int j = 0; j < f.length; ++j) {
                    if (f[j] == null || "null".equalsIgnoreCase(f[j])) continue;
                    formats.add(f[j]);
                }
                sdr.setFormats(formats);
                sdr.setServiceProvider(newSP);
                sdr.setGetUrl(KBConfiguration.CONTACT_WEBSITE);
                sdr.setPostUrl(KBConfiguration.CONTACT_WEBSITE);
                resources.add(sdr);
            }
        }
        if (resources.isEmpty()) {
            resources = this.getDefaultResources();
        }
        newSP.setDomainResource(resources);
        newSP.setAbbr(KBConfiguration.SERVICEPROVIDER_BASE_ABBR);
        Set<String> exception = new HashSet();
        if (this.serviceProviders != null && !this.serviceProviders.isEmpty()) {
            String[] exceptions = this.validateExceptions();
            for (int j = 0; j < exceptions.length; ++j) {
                if (exceptions[j] == null || "null".equalsIgnoreCase(exceptions[j])) continue;
                exception.add(exceptions[j]);
            }
        }
        if (exception.isEmpty()) {
            exception = this.getDefaultException();
        }
        newSP.setExceptions(exception);
        return newSP;
    }

    private Set getDefaultException() {
        HashSet<String> exception = new HashSet<String>();
        exception.add("application/vnd.ogc.se_xml");
        exception.add("application/vnd.ogc.se_inimage");
        exception.add("application/vnd.ogc.se_blank");
        return exception;
    }

    private Set getDefaultResources() {
        HashSet<ServiceDomainResource> resources = new HashSet<ServiceDomainResource>();
        ServiceDomainResource sdr = new ServiceDomainResource();
        sdr.setDomain("GetCapabilities");
        HashSet<String> formats = new HashSet<String>();
        formats.add("application/vnd.ogc.wms_xml");
        sdr.setFormats(formats);
        resources.add(sdr);
        sdr = new ServiceDomainResource();
        sdr.setDomain("GetMap");
        formats = new HashSet();
        formats.add("image/png");
        formats.add("image/jpeg");
        formats.add("image/tiff");
        sdr.setFormats(formats);
        resources.add(sdr);
        sdr = new ServiceDomainResource();
        sdr.setDomain("GetFeatureInfo");
        formats = new HashSet();
        formats.add("text/plain");
        formats.add("application/vnd.ogc.gml");
        sdr.setFormats(formats);
        resources.add(sdr);
        return resources;
    }

    private void fillServiceProviderConstants(ServiceProvider serviceProvider) {
        serviceProvider.setName(KBConfiguration.SERVICE_NAME);
        serviceProvider.setTitle(KBConfiguration.SERVICE_TITLE);
        serviceProvider.setAbstracts(KBConfiguration.SERVICE_ABSTRACT);
        serviceProvider.setAccessConstraints(KBConfiguration.SERVICE_CONSTRAINTS);
        serviceProvider.setFees(KBConfiguration.SERVICE_FEES);
        ContactInformation ci = new ContactInformation();
        ci.setContactPerson(KBConfiguration.CONTACT_PERSON);
        ci.setContactPosition(KBConfiguration.CONTACT_POSITION);
        ci.setContactOrganization(KBConfiguration.CONTACT_ORGANIZATION);
        ci.setAddress(KBConfiguration.CONTACT_ADDRESS);
        ci.setAddressType(KBConfiguration.CONTACT_ADDRESS_TYPE);
        ci.setPostcode(KBConfiguration.CONTACT_POSTCODE);
        ci.setCity(KBConfiguration.CONTACT_CITY);
        ci.setStateOrProvince(KBConfiguration.CONTACT_STATE_OR_PROVINCE);
        ci.setCountry(KBConfiguration.CONTACT_COUNTRY);
        ci.setVoiceTelephone(KBConfiguration.CONTACT_VOICETELEPHONE);
        ci.setFascimileTelephone(KBConfiguration.CONTACT_FASCIMILEPHONE);
        ci.setEmailAddress(KBConfiguration.CONTACT_EMAIL);
        serviceProvider.setContactInformation(ci);
    }

    public boolean validate() {
        return this.validateFormats("GetMap").length > 0 && this.validateFormats("GetCapabilities").length > 0 && this.validateFormats("GetFeatureInfo").length > 0 && this.validateFormats("DescribeLayer").length > 0 && this.validateFormats("GetLegendGraphic").length > 0;
    }

    public boolean validateGetMapFormat() {
        return this.validateFormats("GetMap").length > 0;
    }

    public boolean validateGetCapabilitiesFormat() {
        return this.validateFormats("GetCapabilities").length > 0;
    }

    public boolean validateGetFeatureInfoFormat() {
        return this.validateFormats("GetFeatureInfo").length > 0;
    }

    public boolean validateDescribeLayerFormat() {
        return this.validateFormats("DescribeLayer").length > 0;
    }

    public boolean validateGetLegendGraphicFormat() {
        return this.validateFormats("GetLegendGraphic").length > 0;
    }

    private String[] validateExceptions() {
        HashMap hm = new HashMap();
        for (ServiceProvider sp : this.serviceProviders) {
            for (String exception : sp.getExceptions()) {
                this.hashmapFilter(hm, exception);
            }
        }
        return this.formats(hm);
    }

    private String[] validateDomains() {
        HashMap hm = new HashMap();
        for (ServiceProvider sp : this.serviceProviders) {
            for (ServiceDomainResource sdr : sp.getDomainResource()) {
                String domain = sdr.getDomain();
                this.hashmapFilter(hm, domain);
            }
        }
        return this.formats(hm);
    }

    private String[] validateFormats(String domain) {
        HashMap hm = new HashMap();
        for (ServiceProvider sp : this.serviceProviders) {
            for (ServiceDomainResource sdr : sp.getDomainResource()) {
                if (!sdr.getDomain().equalsIgnoreCase(domain)) continue;
                Set formats = sdr.getFormats();
                for (String format : formats) {
                    this.hashmapFilter(hm, format);
                }
            }
        }
        return this.formats(hm);
    }

    private String[] formats(HashMap hashMap) {
        ArrayList<String> supportedFormats = new ArrayList<String>();
        for (Map.Entry entry : hashMap.entrySet()) {
            int i = (Integer)entry.getValue();
            if (i < this.serviceProviders.size()) continue;
            supportedFormats.add((String)entry.getKey());
        }
        String[] formats = new String[supportedFormats.size() + 1];
        return supportedFormats.toArray(formats);
    }

    private void hashmapFilter(HashMap results, String filterValue) {
        if (results.containsKey(filterValue)) {
            int i = (Integer)results.get(filterValue) + 1;
            results.put(filterValue, new Integer(i));
        } else {
            results.put(filterValue, new Integer("1"));
        }
    }

    public Set getServiceProviders() {
        return this.serviceProviders;
    }

    public void setServiceProviders(Set serviceProviders) {
        this.serviceProviders = serviceProviders;
    }
}

