/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.requesthandler;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.WFSRequestHandler;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.OGCResponse;
import nl.b3p.ogc.utils.SpLayerSummary;
import nl.b3p.ogc.utils.WFSDescribeFeatureTypeResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WFSDescribeFeatureTypeRequestHandler
extends WFSRequestHandler {
    private static final Log log = LogFactory.getLog(WFSDescribeFeatureTypeRequestHandler.class);

    public String prepareRequest4Sp(OGCRequest ogcrequest, SpLayerSummary sp) {
        List lsl = sp.getLayers();
        String layerParam = "";
        for (LayerSummary ls : lsl) {
            if (!layerParam.isEmpty()) {
                layerParam = layerParam + ",";
            }
            layerParam = layerParam + OGCCommunication.buildLayerNameWithoutSp((LayerSummary)ls);
        }
        ogcrequest.addOrReplaceParameter("TYPENAME", layerParam);
        return null;
    }

    public List<LayerSummary> prepareRequestLayers(OGCRequest ogcrequest) throws Exception {
        List<String> allLayers = null;
        if (ogcrequest.getHttpMethod().equals("POST")) {
            Set layers = ogcrequest.getGetFeatureFilterMap().keySet();
            allLayers.addAll(layers);
        } else {
            String typeName = ogcrequest.getParameter("TYPENAME");
            allLayers = Arrays.asList(typeName.split(","));
        }
        String spInUrl = ogcrequest.getServiceProviderName();
        List lsl = LayerSummary.createLayerSummaryList(allLayers, (String)ogcrequest.getServiceProviderName(), (spInUrl == null ? 1 : 0) != 0);
        if (!this.checkNumberOfSps(lsl, 1)) {
            log.error((Object)"More then 1 service provider addressed. Not supported (yet)");
            throw new UnsupportedOperationException("More then 1 service provider addressed. Not supported (yet)");
        }
        return lsl;
    }

    public OGCResponse getNewOGCResponse() {
        return new WFSDescribeFeatureTypeResponse();
    }

    public void getRequest(DataWrapper data, User user) throws IOException, Exception {
        this.writeResponse(data, user);
    }
}

