/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.ValidationException;
import javax.xml.parsers.ParserConfigurationException;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.monitoring.DataMonitoring;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.AccessDeniedException;
import nl.b3p.kaartenbalie.service.GroupParser;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.scriptinghandler.AddAllowedHandler;
import nl.b3p.kaartenbalie.service.scriptinghandler.AddHandler;
import nl.b3p.kaartenbalie.service.scriptinghandler.DeleteAllowedHandler;
import nl.b3p.kaartenbalie.service.scriptinghandler.UpdateHandler;
import nl.b3p.kaartenbalie.service.servlet.GeneralServlet;
import nl.b3p.ogc.utils.KBCrypter;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.OGCScriptingRequest;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

/*
 * Exception performing whole class analysis ignored.
 */
public class CallScriptingServlet
extends GeneralServlet {
    private HttpServletRequest httpRequest;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        log = LogFactory.getLog(this.getClass());
        log.debug((Object)"Initializing Call Scripting Servlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        DataWrapper data = new DataWrapper(request, response);
        Object identity = null;
        EntityTransaction tx = null;
        try {
            this.checkRemoteIP(request);
            identity = MyEMFDatabase.createEntityManager((String)"mainEM");
            log.debug((Object)"Getting entity manager ......");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
            tx = em.getTransaction();
            tx.begin();
            DataMonitoring rr = new DataMonitoring();
            data.setRequestReporting(rr);
            String serviceName = "WMS";
            try {
                OGCScriptingRequest ogcrequest = this.calcOGCScriptingRequest(request);
                if (!ogcrequest.containsParameter("command")) {
                    throw new Exception("Bad request");
                }
                data.setOgcrequest((OGCRequest)ogcrequest);
                String serviceParam = ogcrequest.getParameter("SERVICE");
                if (serviceParam != null || !"".equals(serviceParam)) {
                    serviceName = serviceParam;
                }
                String iUrl = ogcrequest.getUrl();
                String pcode = ogcrequest.getPersonalCode();
                rr.startClientRequest(iUrl, iUrl.getBytes().length, startTime, request.getRemoteAddr(), request.getMethod());
                User user = this.checkLogin(request, em, pcode);
                if (ogcrequest != null) {
                    ogcrequest.checkRequestURL();
                }
                rr.setUserAndOrganization(user, user.getMainOrganization());
                data.setHeader("X-Kaartenbalie-User", user.getUsername());
                this.httpRequest = request;
                if (ogcrequest.getParameter("command").equalsIgnoreCase("get_group_xml")) {
                    GroupParser groupParser = new GroupParser();
                    groupParser.getGroupsAsXML(response, data.getOutputStream());
                } else {
                    this.parseRequestAndData(data, user);
                }
            }
            catch (AccessDeniedException adex) {
                log.error((Object)("Access denied: " + adex.getLocalizedMessage()));
                rr.setClientRequestException((Exception)((Object)adex));
                response.addHeader("WWW-Authenticate", "Basic realm=\"Kaartenbalie login\"");
                response.sendError(401, "Access denied to Kaartenbalie");
            }
            catch (Exception ex) {
                log.error((Object)"Error while handling request: ", (Throwable)ex);
                rr.setClientRequestException(ex);
                response.sendError(400, "Bad Request. See API documentation");
            }
            finally {
                rr.endClientRequest(serviceName, data.getOperation(), data.getContentLength(), System.currentTimeMillis() - startTime);
            }
            tx.commit();
        }
        catch (Exception ex) {
            try {
                log.error((Object)"Error creating EntityManager: ", (Throwable)ex);
                try {
                    tx.rollback();
                }
                catch (Exception ex2) {
                    log.error((Object)"Error trying to rollback: ", (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                MyEMFDatabase.closeEntityManager(identity, (String)"mainEM");
                throw throwable;
            }
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"mainEM");
        }
        MyEMFDatabase.closeEntityManager((Object)identity, (String)"mainEM");
    }

    public void parseRequestAndData(DataWrapper data, User user) throws UnsupportedOperationException, IOException, Exception {
        OGCScriptingRequest ogcrequest = (OGCScriptingRequest)data.getOgcrequest();
        String request = ogcrequest.getParameter("REQUEST");
        String command = ogcrequest.getParameter("command");
        UpdateHandler requestHandler = null;
        if (command.equalsIgnoreCase("update_services") && ogcrequest.containsParameter("service_type") && ogcrequest.containsParameter("SERVICE")) {
            UpdateHandler handler = new UpdateHandler();
            if (ogcrequest.getParameter("service_type").equalsIgnoreCase("WMS")) {
                handler.setWMS();
            } else if (ogcrequest.getParameter("service_type").equalsIgnoreCase("WFS")) {
                handler.setWFS();
            }
            requestHandler = handler;
        } else if (command.equalsIgnoreCase("add_service") && ogcrequest.containsParameter("service_type") && ogcrequest.containsParameter("name") && ogcrequest.containsParameter("abbr") && ogcrequest.containsParameter("url")) {
            AddHandler handler = new AddHandler();
            if (ogcrequest.getParameter("service_type").equalsIgnoreCase("WMS")) {
                handler.setWMS();
            } else if (ogcrequest.getParameter("service_type").equalsIgnoreCase("WFS")) {
                handler.setWFS();
            }
            requestHandler = handler;
        } else if (command.equalsIgnoreCase("add_allowed_services") && ogcrequest.containsParameter("service_type") && ogcrequest.containsParameter("abbr")) {
            AddAllowedHandler handler = new AddAllowedHandler();
            if (ogcrequest.getParameter("service_type").equalsIgnoreCase("WMS")) {
                handler.setWMS();
            } else if (ogcrequest.getParameter("service_type").equalsIgnoreCase("WFS")) {
                handler.setWFS();
            }
            requestHandler = handler;
        } else if (command.equalsIgnoreCase("delete_allowed_services") && ogcrequest.containsParameter("service_type") && ogcrequest.containsParameter("abbr")) {
            DeleteAllowedHandler handler = new DeleteAllowedHandler();
            handler.setType("single");
            if (ogcrequest.getParameter("service_type").equalsIgnoreCase("WMS")) {
                handler.setWMS();
            } else if (ogcrequest.getParameter("service_type").equalsIgnoreCase("WFS")) {
                handler.setWFS();
            }
            requestHandler = handler;
        } else if (command.equalsIgnoreCase("delete_all_allowed_services")) {
            DeleteAllowedHandler handler = new DeleteAllowedHandler();
            handler.setType("all");
            if (ogcrequest.getParameter("service_type").equalsIgnoreCase("WMS")) {
                handler.setWMS();
            } else if (ogcrequest.getParameter("service_type").equalsIgnoreCase("WFS")) {
                handler.setWFS();
            }
            requestHandler = handler;
        }
        if (requestHandler == null) {
            throw new UnsupportedOperationException("Request " + request + " is not suported!");
        }
        data.setOperation(request);
        data.setService(command);
        requestHandler.getRequest(this.httpRequest, data, user);
    }

    protected OGCScriptingRequest calcOGCScriptingRequest(HttpServletRequest request) throws UnsupportedEncodingException, ParserConfigurationException, SAXException, IOException, ValidationException, Exception {
        OGCScriptingRequest ogcrequest = null;
        StringBuffer baseUrl = CallScriptingServlet.createBaseUrl((HttpServletRequest)request);
        String iUrl = this.completeUrl(baseUrl, request).toString();
        if (request.getMethod().equalsIgnoreCase("GET")) {
            ogcrequest = new OGCScriptingRequest(iUrl);
            log.debug((Object)("Incoming Get URL: " + iUrl));
        }
        ogcrequest.setHttpMethod(request.getMethod());
        return ogcrequest;
    }

    protected User checkLogin(HttpServletRequest request, EntityManager em, String pcode) throws AccessDeniedException {
        User user = (User)request.getUserPrincipal();
        if (user != null) {
            log.info((Object)("Cookie accepted for login, username: " + user.getName()));
            return user;
        }
        String authorizationHeader = request.getHeader("Authorization");
        if (authorizationHeader != null) {
            String decoded = CallScriptingServlet.decodeBasicAuthorizationString((String)authorizationHeader);
            String username = CallScriptingServlet.parseUsername((String)decoded);
            String password = CallScriptingServlet.parsePassword((String)decoded);
            String encpw = null;
            try {
                encpw = KBCrypter.encryptText((String)password);
            }
            catch (Exception ex) {
                log.error((Object)"error encrypting password: ", (Throwable)ex);
            }
            try {
                user = (User)em.createQuery("from User where lower(username) = lower(:username) and password = :password ").setParameter("username", (Object)username).setParameter("password", (Object)encpw).getSingleResult();
                em.flush();
            }
            catch (NonUniqueResultException nue) {
                log.error((Object)"More than one person found for these credentials (to be fixed in database), trying next method.");
                user = null;
            }
            catch (NoResultException nre) {
                user = null;
                log.debug((Object)"No results using encrypted password, trying next method");
            }
            if (user == null) {
                try {
                    user = (User)em.createQuery("from User where lower(username) = lower(:username) and password = :password ").setParameter("username", (Object)username).setParameter("password", (Object)encpw).getSingleResult();
                    user.setPassword(encpw);
                    em.merge((Object)user);
                    em.flush();
                    if (!user.checkRole("beheerder")) {
                        throw new NoResultException("Not a admin");
                    }
                    log.debug((Object)"Cleartext password now encrypted!");
                }
                catch (NonUniqueResultException nue) {
                    log.error((Object)"More than one person found for these (cleartext) credentials (to be fixed in database), trying next method.");
                    user = null;
                }
                catch (NoResultException nre) {
                    log.debug((Object)"No results using cleartext password, trying next method.");
                }
            }
        }
        if (user != null && user.checkRole("beheerder")) {
            log.info((Object)("Basic authentication accepted for login, username: " + user.getName()));
            return user;
        }
        throw new AccessDeniedException("Authorisation required for this service! No credentials found in Personal url, Authentication header or Cookie, Giving up! ");
    }

    public String getServletInfo() {
        return "CallScriptingServlet info";
    }

    private void checkRemoteIP(HttpServletRequest request) throws AccessDeniedException, UnknownHostException {
        InetAddress addr = InetAddress.getByName(request.getRemoteAddr());
        if (!addr.isLoopbackAddress()) {
            throw new AccessDeniedException("Only connections from localhost are allowed");
        }
    }
}

