/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.service.servlet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.b3pLayering.ExceptionLayer;
import nl.b3p.kaartenbalie.core.server.monitoring.DataMonitoring;
import nl.b3p.kaartenbalie.core.server.persistence.MyEMFDatabase;
import nl.b3p.kaartenbalie.service.AccessDeniedException;
import nl.b3p.kaartenbalie.service.ProviderException;
import nl.b3p.kaartenbalie.service.requesthandler.DOMValidator;
import nl.b3p.kaartenbalie.service.requesthandler.DataWrapper;
import nl.b3p.kaartenbalie.service.requesthandler.DescribeLayerRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.GetCapabilitiesRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.GetFeatureInfoRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.GetLegendGraphicRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.GetMapRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.MetadataRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.ProxyRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.TextToImage;
import nl.b3p.kaartenbalie.service.requesthandler.WFSDescribeFeatureTypeRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.WFSGetCapabilitiesRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.WFSGetFeatureRequestHandler;
import nl.b3p.kaartenbalie.service.requesthandler.WFSTransactionRequestHandler;
import nl.b3p.kaartenbalie.service.servlet.GeneralServlet;
import nl.b3p.ogc.utils.OGCRequest;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

/*
 * Exception performing whole class analysis ignored.
 */
public class CallWMSServlet
extends GeneralServlet {
    public static final long serialVersionUID = 24362462L;
    public static String CAPABILITIES_DTD = null;
    public static String EXCEPTION_DTD = null;
    public static String DESCRIBELAYER_DTD = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        log = LogFactory.getLog(this.getClass());
        log.debug((Object)"Initializing Call WMS Servlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long startTime = System.currentTimeMillis();
        StringBuffer baseUrl = CallWMSServlet.createBaseUrl((HttpServletRequest)request, (boolean)true);
        if (CAPABILITIES_DTD == null) {
            CAPABILITIES_DTD = baseUrl.toString() + "/dtd/capabilities_1_1_1.dtd";
        }
        if (EXCEPTION_DTD == null) {
            EXCEPTION_DTD = baseUrl.toString() + "/dtd/exception_1_1_1.dtd";
        }
        if (DESCRIBELAYER_DTD == null) {
            DESCRIBELAYER_DTD = baseUrl.toString() + "/dtd/WMS_DescribeLayerResponse.dtd";
        }
        DataWrapper data = new DataWrapper(request, response);
        Object identity = null;
        EntityTransaction tx = null;
        try {
            identity = MyEMFDatabase.createEntityManager((String)"mainEM");
            EntityManager em = MyEMFDatabase.getEntityManager((String)"mainEM");
            tx = em.getTransaction();
            tx.begin();
            DataMonitoring rr = new DataMonitoring();
            data.setRequestReporting(rr);
            String serviceName = "WMS";
            try {
                OGCRequest ogcrequest = this.calcOGCRequest(request);
                String personalCode = null;
                if (ogcrequest != null) {
                    personalCode = ogcrequest.getPersonalCode();
                }
                data.setOgcrequest(ogcrequest);
                String serviceParam = ogcrequest.getParameter("SERVICE");
                if (serviceParam != null || !"".equals(serviceParam)) {
                    serviceName = serviceParam;
                }
                String iUrl = ogcrequest.getUrl();
                rr.startClientRequest(iUrl, iUrl.getBytes().length, startTime, request.getRemoteAddr(), request.getMethod());
                User user = CallWMSServlet.checkLogin((HttpServletRequest)request, (String)personalCode, (EntityManager)em);
                ogcrequest.checkRequestURL();
                Organization mainOrg = null;
                String userName = null;
                if (user != null) {
                    mainOrg = user.getMainOrganization();
                    userName = user.getUsername();
                }
                rr.setUserAndOrganization(user, mainOrg);
                data.setHeader("X-Kaartenbalie-User", userName);
                this.parseRequestAndData(data, user);
            }
            catch (AccessDeniedException adex) {
                rr.setClientRequestException((Exception)((Object)adex));
                response.addHeader("WWW-Authenticate", "Basic realm=\"Kaartenbalie login\"");
                response.sendError(401, "Access denied to Kaartenbalie");
            }
            catch (ProviderException pex) {
                log.error((Object)("Error while communicating with provider: " + pex.getLocalizedMessage()));
                rr.setClientRequestException((Exception)((Object)pex));
                this.handleRequestException((Exception)((Object)pex), data);
            }
            catch (Exception e) {
                log.error((Object)String.format("Error while handling request for URI %s, query string %s: %s: %s", request.getRequestURI(), request.getQueryString(), e.getClass().getName(), e.getMessage()), (Throwable)e);
                rr.setClientRequestException(e);
                this.handleRequestException(e, data);
            }
            finally {
                rr.endClientRequest(serviceName, data.getOperation(), data.getContentLength(), System.currentTimeMillis() - startTime);
            }
            if (!tx.getRollbackOnly()) {
                tx.commit();
            }
        }
        catch (Exception ex) {
            log.error((Object)"Error creating EntityManager", (Throwable)ex);
            this.handleRequestException(ex, data);
        }
        finally {
            if (tx != null && tx.isActive()) {
                tx.rollback();
            }
            MyEMFDatabase.closeEntityManager((Object)identity, (String)"mainEM");
        }
    }

    protected void handleRequestException(Exception ex, DataWrapper data) throws IOException {
        OGCRequest ogcrequest = data.getOgcrequest();
        if (ogcrequest == null) {
            data.setContentType("application/vnd.ogc.se_xml");
            this.handleRequestExceptionAsXML(ex, data);
        } else if (ogcrequest.getParameter("SERVICE") != null && ogcrequest.getParameter("SERVICE").equals("WFS")) {
            data.setContentType("application/vnd.ogc.se_xml");
            this.handleRequestExceptionAsXML(ex, data);
        } else {
            String exType = "";
            if (ogcrequest.containsParameter("EXCEPTIONS")) {
                exType = ogcrequest.getParameter("EXCEPTIONS");
            }
            String requestparam = "";
            if (ogcrequest.containsParameter("REQUEST")) {
                requestparam = ogcrequest.getParameter("REQUEST");
            }
            if ((requestparam.equalsIgnoreCase("GetMap") || requestparam.equalsIgnoreCase("GetLegendGraphic")) && (exType.equalsIgnoreCase("application/vnd.ogc.se_inimage") || exType.equalsIgnoreCase("inimage")) && ogcrequest.containsParameter("FORMAT") && ogcrequest.containsParameter("WIDTH") && ogcrequest.containsParameter("HEIGHT")) {
                data.setContentType(ogcrequest.getParameter("FORMAT"));
                this.handleRequestExceptionAsImage(ex, data);
            } else {
                data.setContentType("application/vnd.ogc.se_xml");
                this.handleRequestExceptionAsXML(ex, data);
            }
        }
    }

    private void handleRequestExceptionAsImage(Exception ex, DataWrapper data) throws IOException {
        String message = ex.getMessage();
        try {
            ExceptionLayer el = new ExceptionLayer();
            HashMap<String, Object> parameterMap = new HashMap<String, Object>();
            parameterMap.put("type", ex.getClass());
            parameterMap.put("transparant", Boolean.TRUE);
            parameterMap.put("message", message);
            parameterMap.put("stacktrace", ex.getStackTrace());
            el.sendImage(data, el.drawImage(data.getOgcrequest(), parameterMap));
        }
        catch (Exception e) {
            log.error((Object)"error handling exception: ", (Throwable)e);
            TextToImage tti = new TextToImage();
            try {
                tti.createImage(message, data);
            }
            catch (Exception lex) {
                log.error((Object)"error creating error-image: ", (Throwable)lex);
            }
        }
    }

    private void handleRequestExceptionAsXML(Exception ex, DataWrapper data) throws IOException {
        ByteArrayOutputStream output = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            log.error((Object)"error: ", (Throwable)e);
            throw new IOException("Exception occured during creation of error message: " + e);
        }
        DOMImplementation di = db.getDOMImplementation();
        DocumentType dt = di.createDocumentType("ServiceExceptionReport", null, EXCEPTION_DTD);
        Document dom = di.createDocument(null, "ServiceExceptionReport", dt);
        Element rootElement = dom.getDocumentElement();
        rootElement.setAttribute("version", "1.1.1");
        Element serviceExceptionElement = dom.createElement("ServiceException");
        String exceptionName = ex.getClass().getName();
        String message = ex.getMessage();
        Throwable cause = ex.getCause();
        serviceExceptionElement.setAttribute("code", exceptionName);
        CDATASection cdata = null;
        cdata = cause != null ? dom.createCDATASection(message + " - " + cause) : dom.createCDATASection(message);
        serviceExceptionElement.appendChild(cdata);
        rootElement.appendChild(serviceExceptionElement);
        OutputFormat format = new OutputFormat(dom);
        format.setIndenting(true);
        output = new ByteArrayOutputStream();
        XMLSerializer serializer = new XMLSerializer((OutputStream)output, format);
        serializer.serialize(dom);
        DOMValidator dv = new DOMValidator();
        try {
            dv.parseAndValidate(new ByteArrayInputStream(output.toString().getBytes("UTF-8")));
        }
        catch (Exception e) {
            log.error((Object)"error: ", (Throwable)e);
            throw new IOException("Exception occured during validation of error message: " + e);
        }
        data.setHeader("Content-Disposition", "inline; filename=\"ServiceException.xml\";");
        data.write(output);
    }

    private Map getUpperCaseParameterMap(Map parameters) {
        HashMap<String, String> newParameterMap = new HashMap<String, String>();
        Set paramKeySet = parameters.keySet();
        for (String key : paramKeySet) {
            String value = ((String[])parameters.get(key))[0];
            String caseInsensitiveKey = key.toUpperCase();
            String caseInsensitiveValue = value.toUpperCase();
            newParameterMap.put(caseInsensitiveKey, caseInsensitiveValue);
        }
        return newParameterMap;
    }

    public void parseRequestAndData(DataWrapper data, User user) throws IllegalArgumentException, UnsupportedOperationException, IOException, Exception {
        String request = data.getOgcrequest().getParameter("REQUEST");
        String service = data.getOgcrequest().getParameter("SERVICE");
        GetMapRequestHandler requestHandler = null;
        if (service != null && service.length() > 0) {
            if (service.equalsIgnoreCase("PROXY")) {
                requestHandler = new ProxyRequestHandler();
            } else if (service.equalsIgnoreCase("METADATA")) {
                requestHandler = new MetadataRequestHandler();
            } else if (service.equalsIgnoreCase("WMS")) {
                if (request.equalsIgnoreCase("GetCapabilities")) {
                    requestHandler = new GetCapabilitiesRequestHandler();
                }
            } else if (service.equalsIgnoreCase("WFS") && request.equalsIgnoreCase("GetCapabilities")) {
                requestHandler = new WFSGetCapabilitiesRequestHandler();
            }
        }
        if (requestHandler == null) {
            if (request.equalsIgnoreCase("GetMap")) {
                requestHandler = new GetMapRequestHandler();
                service = "WMS";
            } else if (request.equalsIgnoreCase("GetFeatureInfo")) {
                requestHandler = new GetFeatureInfoRequestHandler();
                service = "WMS";
            } else if (request.equalsIgnoreCase("GetLegendGraphic")) {
                requestHandler = new GetLegendGraphicRequestHandler();
                service = "WMS";
            } else if (request.equalsIgnoreCase("DescribeLayer")) {
                requestHandler = new DescribeLayerRequestHandler();
                service = "WMS";
            } else if (request.equalsIgnoreCase("DescribeFeatureType")) {
                requestHandler = new WFSDescribeFeatureTypeRequestHandler();
                service = "WFS";
            } else if (request.equalsIgnoreCase("GetFeature")) {
                requestHandler = new WFSGetFeatureRequestHandler();
                service = "WFS";
            } else if (request.equalsIgnoreCase("Transaction")) {
                requestHandler = new WFSTransactionRequestHandler();
                service = "WFS";
            }
        }
        if (requestHandler == null) {
            throw new UnsupportedOperationException("Request " + request + " is not suported!");
        }
        data.setOperation(request);
        data.setService(service);
        requestHandler.getRequest(data, user);
    }

    public String getServletInfo() {
        return "CallWMSServlet info";
    }
}

