/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.struts;

import java.math.BigDecimal;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.kaartenbalie.core.server.Organization;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.core.server.accounting.AccountManager;
import nl.b3p.kaartenbalie.core.server.accounting.entity.Transaction;
import nl.b3p.kaartenbalie.struts.KaartenbalieCrudAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.action.ActionRedirect;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.validator.DynaValidatorForm;

/*
 * Exception performing whole class analysis ignored.
 */
public class DepositAction
extends KaartenbalieCrudAction {
    private static final Log log = LogFactory.getLog(DepositAction.class);
    protected static final String BACK = "back";

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareMethod(dynaForm, request, "list", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward cancelled(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("failure");
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Organization organization;
        AccountManager am;
        Transaction tpd;
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            super.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        Integer amount = (Integer)dynaForm.get("amount");
        Integer fraction = (Integer)dynaForm.get("fraction");
        String description = dynaForm.getString("description");
        String paymentMethod = dynaForm.getString("paymentMethod");
        BigDecimal billing = DepositAction.integersToBD((Integer)amount, (Integer)fraction);
        Integer exchangeRate = Transaction.getExchangeRate();
        if (billing.doubleValue() <= 0.0) {
            log.error((Object)"Amount cannot be less then or equal to zero!");
            throw new Exception("Amount cannot be less then or equal to zero!");
        }
        StringBuffer tdesc = new StringBuffer();
        if (description != null) {
            tdesc.append(description);
        }
        if (paymentMethod != null) {
            tdesc.append("/");
            tdesc.append(paymentMethod);
        }
        if (exchangeRate != null) {
            tdesc.append("/1:");
            tdesc.append(exchangeRate);
        }
        if (tdesc.length() > 32) {
            tdesc = new StringBuffer(tdesc.substring(0, 32));
        }
        if ((tpd = (am = AccountManager.getAccountManager((Integer)(organization = this.getOrganization(dynaForm, request)).getId())).prepareTransaction(Transaction.DEPOSIT, tdesc.toString())) != null) {
            tpd.setBillingAmount(billing);
            BigDecimal creditAlt = billing.multiply(new BigDecimal(exchangeRate));
            tpd.setCreditAlteration(creditAlt);
            tpd.setTxExchangeRate(exchangeRate);
            am.commitTransaction(tpd, (User)request.getUserPrincipal());
        }
        ActionRedirect redirect = new ActionRedirect((ForwardConfig)mapping.findForward("back"));
        redirect.addParameter("selectedOrganization", (Object)organization.getId().toString());
        return redirect;
    }

    public void createLists(DynaValidatorForm form, HttpServletRequest request) throws Exception {
        super.createLists(form, request);
        request.setAttribute("exchangeRate", (Object)Transaction.getExchangeRate());
        Organization organization = this.getOrganization(form, request);
        form.set("orgName", (Object)organization.getName());
    }

    private Organization getOrganization(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        log.debug((Object)"Getting entity manager ......");
        EntityManager em = DepositAction.getEntityManager();
        Organization organization = null;
        Integer id = this.getID(dynaForm);
        if (id == null) {
            User principalUser = (User)request.getUserPrincipal();
            if (principalUser == null) {
                return null;
            }
            User user = (User)em.find(User.class, (Object)principalUser.getId());
            if (user == null) {
                return null;
            }
            organization = user.getMainOrganization();
        } else {
            organization = (Organization)em.find(Organization.class, (Object)id);
        }
        return organization;
    }

    private Integer getID(DynaValidatorForm dynaForm) {
        return FormUtils.StringToInteger((String)dynaForm.getString("orgId"));
    }

    private static BigDecimal integersToBD(Integer amount, Integer fraction) throws Exception {
        if (amount == null && fraction == null) {
            log.error((Object)"Amount and fraction cannot both be null");
            throw new Exception("Amount and fraction cannot both be null");
        }
        if (amount == null) {
            amount = new Integer(0);
        }
        if (fraction == null) {
            fraction = new Integer(0);
        }
        String strVal = amount.toString() + "." + fraction.toString();
        return new BigDecimal(strVal);
    }
}

