/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.kaartenbalie.struts;

import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.kaartenbalie.core.server.User;
import nl.b3p.kaartenbalie.struts.KaartenbalieCrudAction;
import nl.b3p.wms.capabilities.Roles;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.HibernateException;
import org.json.JSONException;

/*
 * Exception performing whole class analysis ignored.
 */
public class RoleAction
extends KaartenbalieCrudAction {
    private static final Log logger = LogFactory.getLog(RoleAction.class);
    protected static final String ROLE_JOINED_MESSAGE_KEY = "beheer.role.user.joined";
    protected static final String ROLE_PROTECTED_MESSAGE_KEY = "beheer.role.protected";
    protected static final String ROLE_NOTFOUND_ERROR_KEY = "error.rolenotfound";

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.prepareMethod(dynaForm, request, "list", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return mapping.findForward("success");
    }

    public ActionForward edit(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Roles role = this.getRole(dynaForm, request, false);
        if (role == null) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.rolenotfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateRoleForm(role, dynaForm, request);
        this.prepareMethod(dynaForm, request, "edit", "list");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws HibernateException, Exception {
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = RoleAction.getEntityManager();
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        ActionErrors errors = dynaForm.validate(mapping, request);
        if (!errors.isEmpty()) {
            this.addMessages(request, (ActionMessages)errors);
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.validation");
            return this.getAlternateForward(mapping, request);
        }
        Roles role = this.getRole(dynaForm, request, true);
        if (null == role) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        this.populateRoleObject(dynaForm, role);
        MessageResources messages = this.getResources(request);
        Locale locale = this.getLocale(request);
        String roleProtectedMessage = messages.getMessage(locale, "beheer.role.protected");
        if (role.isProtectedRole()) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, null, roleProtectedMessage);
            return this.getAlternateForward(mapping, request);
        }
        if (role.getId() == null) {
            em.persist((Object)role);
        } else {
            em.merge((Object)role);
        }
        em.flush();
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward deleteConfirm(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Roles role = this.getRole(dynaForm, request, false);
        if (null == role) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        MessageResources messages = this.getResources(request);
        Locale locale = this.getLocale(request);
        String roleJoinedMessage = messages.getMessage(locale, "beheer.role.user.joined");
        String roleProtectedMessage = messages.getMessage(locale, "beheer.role.protected");
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = RoleAction.getEntityManager();
        List userList = em.createQuery("from User u join u.roles r where r.id = :roleid").setParameter("roleid", (Object)role.getId()).getResultList();
        StringBuilder strMessage = new StringBuilder();
        if (userList != null && !userList.isEmpty()) {
            String userName = "";
            boolean notFirstUser = false;
            strMessage.append(roleJoinedMessage.toString());
            for (Object[] user_roles : userList) {
                User u = null;
                if (user_roles != null) {
                    u = (User)user_roles[0];
                }
                if (u != null) {
                    userName = u.getUsername();
                }
                if (notFirstUser) {
                    strMessage.append(", ");
                } else {
                    strMessage.append(": ");
                    notFirstUser = true;
                }
                strMessage.append(userName);
            }
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, null, strMessage.toString());
            return this.getDefaultForward(mapping, request);
        }
        if (role.isProtectedRole()) {
            this.addAlternateMessage(mapping, request, null, roleProtectedMessage);
        }
        this.prepareMethod(dynaForm, request, "delete", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward delete(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws HibernateException, Exception {
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = RoleAction.getEntityManager();
        if (!this.isTokenValid(request)) {
            this.prepareMethod(dynaForm, request, "edit", "list");
            this.addAlternateMessage(mapping, request, "error.token");
            return this.getAlternateForward(mapping, request);
        }
        Roles role = this.getRole(dynaForm, request, false);
        if (null == role) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, "error.notfound");
            return this.getAlternateForward(mapping, request);
        }
        MessageResources messages = this.getResources(request);
        Locale locale = this.getLocale(request);
        String roleProtectedMessage = messages.getMessage(locale, "beheer.role.protected");
        String roleJoinedMessage = messages.getMessage(locale, "beheer.role.user.joined");
        if (role.isProtectedRole()) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, null, roleProtectedMessage);
            return this.getAlternateForward(mapping, request);
        }
        List userList = em.createQuery("from User u join u.roles r where r.id = :roleid").setParameter("roleid", (Object)role.getId()).getResultList();
        if (userList != null && !userList.isEmpty()) {
            this.prepareMethod(dynaForm, request, "list", "edit");
            this.addAlternateMessage(mapping, request, null, roleJoinedMessage);
            return this.getAlternateForward(mapping, request);
        }
        em.remove((Object)role);
        em.flush();
        dynaForm.initialize(mapping);
        this.prepareMethod(dynaForm, request, "list", "edit");
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    protected void populateRoleForm(Roles role, DynaValidatorForm dynaForm, HttpServletRequest request) throws JSONException {
        dynaForm.set("id", (Object)role.getId().toString());
        dynaForm.set("name", (Object)role.getRole());
    }

    private void populateRoleObject(DynaValidatorForm dynaForm, Roles role) throws Exception {
        role.setRole(FormUtils.nullIfEmpty((String)dynaForm.getString("name")));
    }

    protected void createLists(DynaValidatorForm form, HttpServletRequest request) throws HibernateException, JSONException, Exception {
        super.createLists(form, request);
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = RoleAction.getEntityManager();
        List roleslist = em.createQuery("from Roles").getResultList();
        request.setAttribute("roleslist", (Object)roleslist);
    }

    protected Roles getRole(DynaValidatorForm dynaForm, HttpServletRequest request, boolean createNew) throws Exception {
        logger.debug((Object)"Getting entity manager ......");
        EntityManager em = RoleAction.getEntityManager();
        Roles role = null;
        Integer id = this.getID(dynaForm);
        if (null == id && createNew) {
            role = new Roles();
        } else if (null != id) {
            role = (Roles)em.find(Roles.class, (Object)id);
        }
        return role;
    }

    private Integer getID(DynaValidatorForm dynaForm) {
        return FormUtils.StringToInteger((String)dynaForm.getString("id"));
    }
}

