/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gds2;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.ws.BindingProvider;
import nl.b3p.gds2.GDS2Util;
import nl.b3p.soap.logging.LogMessageHandler;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstopvragen.v20170401.BestandenlijstOpvragenType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstresultaat.afgifte.v20170401.AfgifteType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstselectie.v20170401.AfgifteSelectieCriteriaType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstselectie.v20170401.BestandKenmerkenType;
import nl.kadaster.schemas.gds2.afgifte_proces.v20170401.FilterDatumTijdType;
import nl.kadaster.schemas.gds2.afgifte_proces.v20170401.KlantAfgiftenummerReeksType;
import nl.kadaster.schemas.gds2.imgds.baseurl.v20170401.BaseURLType;
import nl.kadaster.schemas.gds2.service.afgifte.v20170401.Gds2AfgifteServiceV20170401;
import nl.kadaster.schemas.gds2.service.afgifte.v20170401.Gds2AfgifteServiceV20170401Service;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstopvragen.v20170401.BestandenlijstOpvragenRequest;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstopvragen.v20170401.BestandenlijstOpvragenResponse;
import nl.logius.digikoppeling.gb._2010._10.DataReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Main2 {
    private static final Log LOG = LogFactory.getLog(Main2.class);
    private static final String MOCK_ENDPOINT = "http://localhost:8088/AfgifteService";

    public static void main(String[] args) throws Exception {
        Gds2AfgifteServiceV20170401 gds2 = new Gds2AfgifteServiceV20170401Service().getAGds2AfgifteServiceV20170401();
        BindingProvider bp = (BindingProvider)gds2;
        Map ctxt = bp.getRequestContext();
        List handlerChain = bp.getBinding().getHandlerChain();
        handlerChain.add(new LogMessageHandler());
        bp.getBinding().setHandlerChain(handlerChain);
        String endpoint = (String)ctxt.get("javax.xml.ws.service.endpoint.address");
        LOG.info((Object)("Origineel endpoint: " + endpoint));
        char[] thePassword = "changeit".toCharArray();
        LOG.debug((Object)"Loading keystore");
        KeyStore ks = KeyStore.getInstance("jks");
        ks.load(Main2.class.getResourceAsStream("/pkioverheid.jks"), thePassword);
        LOG.debug((Object)"Initializing TrustManagerFactory");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
        tmf.init(ks);
        LOG.debug((Object)"Initializing KeyManagerFactory");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        ks = KeyStore.getInstance("jks");
        if (args.length > 0) {
            String keystore = "/gds2_key.jks";
            ks.load(Main2.class.getResourceAsStream(keystore), thePassword);
            kmf.init(ks, thePassword);
        } else {
            ks.load(null);
            PrivateKey privateKey = GDS2Util.getPrivateKeyFromPEM(new String(Files.readAllBytes(Paths.get("private.key", new String[0]))).trim());
            Certificate certificate = GDS2Util.getCertificateFromPEM(new String(Files.readAllBytes(Paths.get("public.key", new String[0]))).trim());
            ks.setKeyEntry("thekey", privateKey, thePassword, new Certificate[]{certificate});
            kmf.init(ks, thePassword);
        }
        LOG.debug((Object)"Initializing SSLContext");
        SSLContext context = SSLContext.getInstance("TLS", "SunJSSE");
        context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        SSLContext.setDefault(context);
        ctxt.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", context.getSocketFactory());
        BestandenlijstOpvragenRequest request = new BestandenlijstOpvragenRequest();
        BestandenlijstOpvragenType verzoek = new BestandenlijstOpvragenType();
        request.setVerzoek(verzoek);
        AfgifteSelectieCriteriaType criteria = new AfgifteSelectieCriteriaType();
        verzoek.setAfgifteSelectieCriteria(criteria);
        criteria.setBestandKenmerken(new BestandKenmerkenType());
        Boolean alGerapporteerd = Boolean.TRUE;
        criteria.setNogNietGerapporteerd(alGerapporteerd);
        GregorianCalendar vanaf = GDS2Util.getDatumTijd("01-05-2019");
        GregorianCalendar tot = GDS2Util.getDatumTijd("15-09-2019");
        criteria.setPeriode(new FilterDatumTijdType());
        criteria.getPeriode().setDatumTijdVanaf(GDS2Util.getXMLDatumTijd(vanaf));
        criteria.getPeriode().setDatumTijdTotmet(GDS2Util.getXMLDatumTijd(tot));
        KlantAfgiftenummerReeksType afgiftenummers = new KlantAfgiftenummerReeksType();
        afgiftenummers.setKlantAfgiftenummerVanaf(BigInteger.ONE);
        afgiftenummers.setKlantAfgiftenummerTotmet(BigInteger.valueOf(10000L));
        criteria.getBestandKenmerken().setContractnummer("9700005117");
        LOG.info((Object)("Contract nummer: " + criteria.getBestandKenmerken().getContractnummer()));
        LOG.info((Object)("Artikel nummer: " + criteria.getBestandKenmerken().getArtikelnummer()));
        LOG.info((Object)("DatumTijdVanaf criterium: " + vanaf));
        LOG.info((Object)("DatumTijdTot criterium: " + tot));
        LOG.info((Object)("alGerapporteerd criterium: " + alGerapporteerd));
        BestandenlijstOpvragenRequest bestandenlijstOpvragenRequest = new BestandenlijstOpvragenRequest();
        BestandenlijstOpvragenType bestandenlijstOpvragenVerzoek = new BestandenlijstOpvragenType();
        bestandenlijstOpvragenRequest.setVerzoek(bestandenlijstOpvragenVerzoek);
        bestandenlijstOpvragenVerzoek.setAfgifteSelectieCriteria(criteria);
        GregorianCalendar currentMoment = null;
        boolean parseblePeriod = false;
        int loopType = 5;
        int loopMax = 180;
        int loopNum = 0;
        boolean reducePeriod = false;
        boolean increasePeriod = false;
        if (vanaf.before(tot)) {
            parseblePeriod = true;
            currentMoment = vanaf;
        }
        ArrayList<AfgifteType> afgiftes = new ArrayList<AfgifteType>();
        BestandenlijstOpvragenResponse response = null;
        int hoogsteKlantAfgifteNummer = -1;
        boolean morePeriods2Process = false;
        do {
            System.out.println("\n*** start periode ***");
            if (parseblePeriod) {
                if (reducePeriod) {
                    switch (loopType) {
                        case 5: {
                            currentMoment.add(loopType, -1);
                            loopType = 11;
                            System.out.println("* Verklein loop periode naar uur");
                            break;
                        }
                        case 11: {
                            currentMoment.add(loopType, -1);
                            loopType = 12;
                            System.out.println("* Verklein loop periode naar minuut");
                            break;
                        }
                        default: {
                            System.out.println("Niet alle gevraagde berichten zijn opgehaald");
                        }
                    }
                    reducePeriod = false;
                }
                if (increasePeriod) {
                    switch (loopType) {
                        case 11: {
                            loopType = 5;
                            System.out.println("* Vergroot loop periode naar dag");
                            break;
                        }
                        case 12: {
                            loopType = 11;
                            System.out.println("* Vergroot loop periode naar uur");
                            break;
                        }
                    }
                    increasePeriod = false;
                }
                FilterDatumTijdType d = new FilterDatumTijdType();
                d.setDatumTijdVanaf(GDS2Util.getXMLDatumTijd(currentMoment));
                System.out.println(String.format("Datum vanaf: %tc", currentMoment.getTime()));
                currentMoment.add(loopType, 1);
                d.setDatumTijdTotmet(GDS2Util.getXMLDatumTijd(currentMoment));
                System.out.println(String.format("Datum tot: %tc", currentMoment.getTime()));
                criteria.setPeriode(d);
                switch (loopType) {
                    case 11: {
                        if (currentMoment.get(loopType) != 0) break;
                        increasePeriod = true;
                        break;
                    }
                    case 12: {
                        if (currentMoment.get(loopType) != 0) break;
                        increasePeriod = true;
                        break;
                    }
                    default: {
                        ++loopNum;
                    }
                }
                morePeriods2Process = currentMoment.before(tot) && loopNum < loopMax;
            }
            verzoek.setAfgifteSelectieCriteria(criteria);
            response = GDS2Util.retryBestandenLijstOpvragen(gds2, request, 1, 10000L);
            hoogsteKlantAfgifteNummer = response.getAntwoord().getKlantAfgiftenummerMax();
            int aantalInAntwoord = response.getAntwoord().getAfgifteAantalInLijst();
            System.out.println("Aantal in antwoord: " + aantalInAntwoord);
            boolean hasMore = response.getAntwoord().isMeerAfgiftesbeschikbaar();
            System.out.println("Meer afgiftes beschikbaar: " + hasMore);
            if (hasMore && "true".equals(alGerapporteerd)) {
                reducePeriod = true;
                morePeriods2Process = true;
                increasePeriod = false;
                if (parseblePeriod) continue;
                morePeriods2Process = false;
            }
            if (aantalInAntwoord > 0) {
                afgiftes.addAll(response.getAntwoord().getBestandenLijst().getAfgifte());
            }
            int moreCount = 0;
            while (hasMore) {
                System.out.println("Uitvoeren SOAP request naar Kadaster voor meer afgiftes..." + moreCount++);
                criteria.setNogNietGerapporteerd(true);
                response = GDS2Util.retryBestandenLijstOpvragen(gds2, request, 1, 10000L);
                hoogsteKlantAfgifteNummer = response.getAntwoord().getKlantAfgiftenummerMax();
                List<AfgifteType> afgifteLijst = response.getAntwoord().getBestandenLijst().getAfgifte();
                for (AfgifteType t : afgiftes) {
                    Iterator<DataReference> iterator;
                    if (t.getDigikoppelingExternalDatareferences() == null || t.getDigikoppelingExternalDatareferences().getDataReference() == null || !(iterator = t.getDigikoppelingExternalDatareferences().getDataReference().iterator()).hasNext()) continue;
                    DataReference dr = iterator.next();
                    LOG.info((Object)("GDS2url te downloaden: " + dr.getTransport().getLocation().getSenderUrl().getValue()));
                }
                afgiftes.addAll(afgifteLijst);
                aantalInAntwoord = response.getAntwoord().getAfgifteAantalInLijst();
                System.out.println("Aantal in antwoord: " + aantalInAntwoord);
                hasMore = response.getAntwoord().isMeerAfgiftesbeschikbaar();
                System.out.println("Nog meer afgiftes beschikbaar: " + hasMore);
            }
        } while (morePeriods2Process);
        System.out.println("Totaal aantal op te halen berichten: " + afgiftes.size());
        System.out.println("Hoogste klant afgifte nummer: " + hoogsteKlantAfgifteNummer);
        if (criteria.getBestandKenmerken().getContractnummer() == null) {
            Main2.printAfgiftes(afgiftes, GDS2Util.getAnoniemBaseURL(response.getAntwoord()));
        } else {
            Main2.printAfgiftes(afgiftes, GDS2Util.getCertificaatBaseURL(response.getAntwoord()));
        }
    }

    private static void printAfgiftes(List<AfgifteType> afgiftes, BaseURLType baseUrl) {
        LOG.info((Object)"Schrijf afgiftegegevens, bestandskenmerken en Digikoppeling datareference gegevens van de afgiftes in CSV.");
        try (PrintWriter out = new PrintWriter("afgiftelijst.csv");){
            out.println("ID\treferentie\tdownloadUrl\tbestandsnaam\tbestandref\tbeschikbaarTot\tcontractafgiftenr\tklantafgiftenr\tcontractnr\tartikelnr\tartikelomschrijving\tcontextId\tcreationTime\texpirationTime\tfilename\tchecksum\ttype\tsize\tsenderUrl\treceiverUrl");
            for (AfgifteType a : afgiftes) {
                String kenmerken = "-\t-\t-";
                if (a.getBestandKenmerken() != null) {
                    kenmerken = String.format("%s\t%s\t%s", a.getBestandKenmerken().getContractnummer(), a.getBestandKenmerken().getArtikelnummer(), a.getBestandKenmerken().getArtikelomschrijving());
                }
                LOG.debug((Object)("Afgifte id: " + a.getAfgifteID()));
                out.printf("%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\t", a.getAfgifteID(), a.getAfgiftereferentie(), GDS2Util.getAfgifteURL(a, baseUrl), a.getBestand().getBestandsnaam(), a.getBestand().getBestandsreferentie(), a.getBeschikbaarTot(), a.getContractAfgiftenummer(), a.getKlantAfgiftenummer(), kenmerken);
                if (a.getDigikoppelingExternalDatareferences() == null || a.getDigikoppelingExternalDatareferences().getDataReference() == null) continue;
                for (DataReference dr : a.getDigikoppelingExternalDatareferences().getDataReference()) {
                    out.printf("%s\t%s\t%s\t%s\t%s\t%s\t%d\t%s\t%s\n", dr.getContextId() == null ? "-" : dr.getContextId(), dr.getLifetime().getCreationTime().getValue(), dr.getLifetime().getExpirationTime().getValue(), dr.getContent().getFilename(), dr.getContent().getChecksum().getValue(), dr.getContent().getContentType(), dr.getContent().getSize(), dr.getTransport().getLocation().getSenderUrl() == null ? "-" : dr.getTransport().getLocation().getSenderUrl().getValue(), dr.getTransport().getLocation().getReceiverUrl() == null ? "-" : dr.getTransport().getLocation().getReceiverUrl().getValue());
                }
            }
        }
        catch (FileNotFoundException e) {
            LOG.error((Object)"CSV maken is mislukt", (Throwable)e);
        }
    }
}

