/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gds2;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.BindingProvider;
import nl.b3p.gds2.GDS2Util;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstgbopvragen.v20130701.BestandenlijstGbOpvragenType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstgbresultaat.afgifte.v20130701.AfgifteGBType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstopvragen.v20130701.BestandenlijstOpvragenType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstresultaat.afgifte.v20130701.AfgifteType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstselectie.v20130701.AfgifteSelectieCriteriaType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstselectie.v20130701.BestandKenmerkenType;
import nl.kadaster.schemas.gds2.afgifte_proces.v20130701.FilterDatumTijdType;
import nl.kadaster.schemas.gds2.service.afgifte.v20130701.Gds2AfgifteServiceV20130701;
import nl.kadaster.schemas.gds2.service.afgifte.v20130701.Gds2AfgifteServiceV20130701Service;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstgbopvragen.v20130701.BestandenlijstGBOpvragenRequest;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstgbopvragen.v20130701.BestandenlijstGBOpvragenResponse;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstopvragen.v20130701.BestandenlijstOpvragenRequest;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstopvragen.v20130701.BestandenlijstOpvragenResponse;
import nl.logius.digikoppeling.gb._2010._10.DataReference;

public class Main {
    private static final int BESTANDENLIJST_ATTEMPTS = 5;
    private static final int BESTANDENLIJST_RETRY_WAIT = 10000;

    public static void main(String[] args) throws Exception {
        Gds2AfgifteServiceV20130701 gds2 = new Gds2AfgifteServiceV20130701Service().getAGds2AfgifteServiceV20130701();
        BindingProvider bp = (BindingProvider)gds2;
        Map ctxt = bp.getRequestContext();
        String endpoint = (String)ctxt.get("javax.xml.ws.service.endpoint.address");
        System.out.println("Origineel endpoint: " + endpoint);
        char[] thePassword = "changeit".toCharArray();
        System.out.println("Loading keystore");
        KeyStore ks = KeyStore.getInstance("jks");
        ks.load(Main.class.getResourceAsStream("/pkioverheid.jks"), thePassword);
        System.out.println("Initializing TrustManagerFactory");
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
        tmf.init(ks);
        System.out.println("Initializing KeyManagerFactory");
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        ks = KeyStore.getInstance("jks");
        if (args.length > 0) {
            String keystore = "/gds2_key.jks";
            ks.load(Main.class.getResourceAsStream(keystore), thePassword);
            kmf.init(ks, thePassword);
        } else {
            ks.load(null);
            PrivateKey privateKey = GDS2Util.getPrivateKeyFromPEM(new String(Files.readAllBytes(Paths.get("private.key", new String[0]))).trim());
            Certificate certificate = GDS2Util.getCertificateFromPEM(new String(Files.readAllBytes(Paths.get("public.key", new String[0]))).trim());
            ks.setKeyEntry("thekey", privateKey, thePassword, new Certificate[]{certificate});
            kmf.init(ks, thePassword);
        }
        System.out.println("Initializing SSLContext");
        SSLContext context = SSLContext.getInstance("TLS", "SunJSSE");
        context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        SSLContext.setDefault(context);
        ctxt.put("com.sun.xml.ws.transport.https.client.SSLSocketFactory", context.getSocketFactory());
        BestandenlijstOpvragenRequest request = new BestandenlijstOpvragenRequest();
        BestandenlijstOpvragenType verzoek = new BestandenlijstOpvragenType();
        request.setVerzoek(verzoek);
        AfgifteSelectieCriteriaType criteria = new AfgifteSelectieCriteriaType();
        verzoek.setAfgifteSelectieCriteria(criteria);
        criteria.setBestandKenmerken(new BestandKenmerkenType());
        boolean alGerapporteerd = false;
        criteria.setNogNietGerapporteerd(alGerapporteerd);
        criteria.getBestandKenmerken().setContractnummer("9700004549");
        GregorianCalendar vanaf = new GregorianCalendar(2018, 0, 1);
        GregorianCalendar tot = new GregorianCalendar();
        tot.setTime(new Date());
        tot = new GregorianCalendar(2018, 1, 1);
        System.out.println("Contract nummer: " + criteria.getBestandKenmerken().getContractnummer());
        System.out.println("Artikel nummer: " + criteria.getBestandKenmerken().getArtikelnummer());
        System.out.println("DatumTijdVanaf criterium: " + vanaf.getTime());
        System.out.println("DatumTijdTot criterium: " + tot.getTime());
        System.out.println("alGerapporteerd criterium: " + alGerapporteerd);
        criteria.setPeriode(new FilterDatumTijdType());
        XMLGregorianCalendar date = DatatypeFactory.newInstance().newXMLGregorianCalendar(vanaf);
        criteria.getPeriode().setDatumTijdVanaf(date);
        BestandenlijstGBOpvragenRequest requestGb = new BestandenlijstGBOpvragenRequest();
        BestandenlijstGbOpvragenType verzoekGb = new BestandenlijstGbOpvragenType();
        requestGb.setVerzoek(verzoekGb);
        verzoekGb.setAfgifteSelectieCriteria(criteria);
        GregorianCalendar currentMoment = null;
        boolean parseblePeriod = false;
        int loopType = 5;
        int loopMax = 180;
        int loopNum = 0;
        boolean reducePeriod = false;
        boolean increasePeriod = false;
        if (vanaf != null && tot != null && vanaf.before(tot)) {
            parseblePeriod = true;
            currentMoment = vanaf;
        }
        ArrayList<AfgifteGBType> afgiftesGb = new ArrayList<AfgifteGBType>();
        try {
            boolean morePeriods2Process = false;
            do {
                System.out.println("\n*** start periode ***");
                if (parseblePeriod) {
                    if (reducePeriod) {
                        switch (loopType) {
                            case 5: {
                                currentMoment.add(loopType, -1);
                                loopType = 11;
                                System.out.println("* Verklein loop periode naar uur");
                                break;
                            }
                            case 11: {
                                currentMoment.add(loopType, -1);
                                loopType = 12;
                                System.out.println("* Verklein loop periode naar minuut");
                                break;
                            }
                            default: {
                                System.out.println("Niet alle gevraagde berichten zijn opgehaald");
                            }
                        }
                        reducePeriod = false;
                    }
                    if (increasePeriod) {
                        switch (loopType) {
                            case 11: {
                                loopType = 5;
                                System.out.println("* Vergroot loop periode naar dag");
                                break;
                            }
                            case 12: {
                                loopType = 11;
                                System.out.println("* Vergroot loop periode naar uur");
                                break;
                            }
                        }
                        increasePeriod = false;
                    }
                    FilterDatumTijdType d = new FilterDatumTijdType();
                    d.setDatumTijdVanaf(DatatypeFactory.newInstance().newXMLGregorianCalendar(currentMoment));
                    System.out.println(String.format("Datum vanaf: %tc", currentMoment.getTime()));
                    currentMoment.add(loopType, 1);
                    d.setDatumTijdTot(DatatypeFactory.newInstance().newXMLGregorianCalendar(currentMoment));
                    System.out.println(String.format("Datum tot: %tc", currentMoment.getTime()));
                    criteria.setPeriode(d);
                    switch (loopType) {
                        case 11: {
                            if (currentMoment.get(loopType) != 0) break;
                            increasePeriod = true;
                            break;
                        }
                        case 12: {
                            if (currentMoment.get(loopType) != 0) break;
                            increasePeriod = true;
                            break;
                        }
                        default: {
                            ++loopNum;
                        }
                    }
                    morePeriods2Process = currentMoment.before(tot) && loopNum < loopMax;
                }
                verzoekGb.setAfgifteSelectieCriteria(criteria);
                BestandenlijstGBOpvragenResponse responseGb = Main.retryBestandenLijstGBOpvragen(gds2, requestGb);
                int aantalInAntwoord = responseGb.getAntwoord().getBestandenLijstGB().getAfgifteGB().size();
                System.out.println("Aantal in antwoord: " + aantalInAntwoord);
                boolean hasMore = responseGb.getAntwoord().getMeerAfgiftesbeschikbaar().equalsIgnoreCase("true");
                System.out.println("Meer afgiftes beschikbaar: " + hasMore);
                if (hasMore && alGerapporteerd) {
                    reducePeriod = true;
                    morePeriods2Process = true;
                    increasePeriod = false;
                    if (parseblePeriod) continue;
                    morePeriods2Process = false;
                }
                afgiftesGb.addAll(responseGb.getAntwoord().getBestandenLijstGB().getAfgifteGB());
                boolean dontGetMoreConfig = false;
                while (hasMore && !dontGetMoreConfig) {
                    criteria.setNogNietGerapporteerd(true);
                    responseGb = Main.retryBestandenLijstGBOpvragen(gds2, requestGb);
                    List<AfgifteGBType> afgiftes = responseGb.getAntwoord().getBestandenLijstGB().getAfgifteGB();
                    afgiftesGb.addAll(afgiftes);
                    aantalInAntwoord = afgiftes.size();
                    System.out.println("Aantal in antwoord: " + aantalInAntwoord);
                    hasMore = responseGb.getAntwoord().getMeerAfgiftesbeschikbaar().equalsIgnoreCase("true");
                    System.out.println("Nog meer afgiftes beschikbaar: " + hasMore);
                }
            } while (morePeriods2Process);
            System.out.println("Totaal aantal op te halen berichten: " + afgiftesGb.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Main.verwerkAfgiftesGb(afgiftesGb);
        System.out.println("\n\n**** resultaat ****\n");
        System.out.println("Aantal afgiftes grote bestanden: " + (afgiftesGb == null ? "<fout>" : Integer.valueOf(afgiftesGb.size())));
        List<AfgifteType> afgiftes = null;
        try {
            BestandenlijstOpvragenResponse response = gds2.bestandenlijstOpvragen(request);
            afgiftes = response.getAntwoord().getBestandenLijst().getAfgifte();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Aantal afgiftes: " + (afgiftes == null ? "<fout>" : Integer.valueOf(afgiftes.size())));
    }

    private static void verwerkAfgiftesGb(List<AfgifteGBType> afgiftesGb) {
        System.out.println("Afgiftegegevens, bestandskenmerken en Digikoppeling datareference gegevens van de bestandenlijst.");
        System.out.println("ID\treferentie\tbestandsnaam\tbestandref\tbeschikbaarTot\tcontractnr\tartikelnr\tartikelomschrijving\tcontextId\tcreationTime\texpirationTime\tfilename\tchecksum\ttype\tsize\tsenderUrl\treceiverUrl");
        for (AfgifteGBType a : afgiftesGb) {
            String kenmerken = "-\t-\t-";
            if (a.getBestandKenmerken() != null) {
                kenmerken = String.format("%s\t%s\t%s", a.getBestandKenmerken().getContractnummer(), a.getBestandKenmerken().getArtikelnummer(), a.getBestandKenmerken().getArtikelomschrijving());
            }
            System.out.printf("%s\t%s\t%s\t%s\t%s\t%s", a.getAfgifteID(), a.getAfgiftereferentie(), a.getBestand().getBestandsnaam(), a.getBestand().getBestandsreferentie(), a.getBeschikbaarTot(), kenmerken);
            if (a.getDigikoppelingExternalDatareferences() == null || a.getDigikoppelingExternalDatareferences().getDataReference() == null) continue;
            for (DataReference dr : a.getDigikoppelingExternalDatareferences().getDataReference()) {
                System.out.printf("\t%s\t%s\t%s\t%s\t%s\t%d\t%s\t%s\t%s\n", dr.getContextId(), dr.getLifetime().getCreationTime().getValue(), dr.getLifetime().getExpirationTime().getValue(), dr.getContent().getFilename(), dr.getContent().getChecksum().getValue(), dr.getContent().getSize(), dr.getContent().getContentType(), dr.getTransport().getLocation().getSenderUrl() == null ? "-" : dr.getTransport().getLocation().getSenderUrl().getValue(), dr.getTransport().getLocation().getReceiverUrl() == null ? "-" : dr.getTransport().getLocation().getReceiverUrl().getValue());
            }
        }
    }

    private static BestandenlijstGBOpvragenResponse retryBestandenLijstGBOpvragen(Gds2AfgifteServiceV20130701 gds2, BestandenlijstGBOpvragenRequest requestGb) throws Exception {
        int attempt = 0;
        while (true) {
            try {
                return gds2.bestandenlijstGBOpvragen(requestGb);
            }
            catch (Exception e) {
                if (++attempt == 5) {
                    System.out.println("Fout bij laatste poging ophalen bestandenlijst: " + e.getClass().getName() + ": " + e.getMessage());
                    throw e;
                }
                System.out.println("Fout bij poging " + attempt + " om bestandenlijst op te halen: " + e.getClass().getName() + ": " + e.getMessage());
                Thread.sleep(10000L);
                System.out.println("Uitvoeren poging " + (attempt + 1) + " om bestandenlijst op te halen...");
                continue;
            }
            break;
        }
    }
}

