/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gds2;

import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstopvragenresultaat.v20170401.BestandenlijstOpvragenResultaatType;
import nl.kadaster.schemas.gds2.afgifte_bestandenlijstresultaat.afgifte.v20170401.AfgifteType;
import nl.kadaster.schemas.gds2.imgds.baseurl.v20170401.BaseURLType;
import nl.kadaster.schemas.gds2.service.afgifte.v20170401.Gds2AfgifteServiceV20170401;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstopvragen.v20170401.BestandenlijstOpvragenRequest;
import nl.kadaster.schemas.gds2.service.afgifte_bestandenlijstopvragen.v20170401.BestandenlijstOpvragenResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GDS2Util {
    private static final Log LOG = LogFactory.getLog(GDS2Util.class);
    private static final String PEM_KEY_START = "-----BEGIN PRIVATE KEY-----";
    private static final String PEM_KEY_END = "-----END PRIVATE KEY-----";
    private static final String PEM_CERT_START = "-----BEGIN CERTIFICATE-----";
    private static final String PEM_CERT_END = "-----END CERTIFICATE-----";

    public static Certificate getCertificateFromPEM(String pem) throws CertificateException, UnsupportedEncodingException {
        if (!pem.startsWith(PEM_CERT_START)) {
            throw new IllegalArgumentException("Certificaat moet beginnen met -----BEGIN CERTIFICATE-----");
        }
        if (!pem.endsWith(PEM_CERT_END)) {
            throw new IllegalArgumentException("Certificaat moet eindigen met -----END CERTIFICATE-----");
        }
        return CertificateFactory.getInstance("X509").generateCertificate(new ByteArrayInputStream(pem.getBytes("US-ASCII")));
    }

    public static PrivateKey getPrivateKeyFromPEM(String pem) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (!pem.startsWith(PEM_KEY_START)) {
            throw new IllegalArgumentException("Private key moet beginnen met -----BEGIN PRIVATE KEY-----");
        }
        while (pem.endsWith("\n")) {
            pem = pem.substring(0, pem.length() - 1);
        }
        if (!pem.endsWith(PEM_KEY_END)) {
            throw new IllegalArgumentException("Private key moet eindigen met -----END PRIVATE KEY-----");
        }
        pem = pem.replace(PEM_KEY_START, "").replace(PEM_KEY_END, "");
        byte[] decoded = Base64.getMimeDecoder().decode(pem);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(decoded);
        return kf.generatePrivate(spec);
    }

    public static BestandenlijstOpvragenResponse retryBestandenLijstOpvragen(Gds2AfgifteServiceV20170401 gds2, BestandenlijstOpvragenRequest request) throws Exception {
        return GDS2Util.retryBestandenLijstOpvragen(gds2, request, 2, 10000L);
    }

    public static BestandenlijstOpvragenResponse retryBestandenLijstOpvragen(Gds2AfgifteServiceV20170401 gds2, BestandenlijstOpvragenRequest request, int retries, long retryWait) throws Exception {
        int attempt = 0;
        while (true) {
            try {
                return gds2.bestandenlijstOpvragen(request);
            }
            catch (Exception e) {
                if (++attempt == retries) {
                    LOG.error((Object)("Fout bij laatste poging ophalen bestandenlijst: " + e.getClass().getName() + ": " + e.getMessage()));
                    throw e;
                }
                LOG.warn((Object)("Fout bij poging " + attempt + " om bestandenlijst op te halen: " + e.getClass().getName() + ": " + e.getMessage()));
                Thread.sleep(retryWait * (long)attempt);
                LOG.info((Object)("Uitvoeren poging " + (attempt + 1) + " om bestandenlijst op te halen..."));
                continue;
            }
            break;
        }
    }

    public static BaseURLType getCertificaatBaseURL(BestandenlijstOpvragenResultaatType antwoord) {
        for (BaseURLType type : antwoord.getBaseURLSet().getBaseURL()) {
            if (!type.getType().equalsIgnoreCase("certificaat")) continue;
            return type;
        }
        return null;
    }

    public static BaseURLType getAnoniemBaseURL(BestandenlijstOpvragenResultaatType antwoord) {
        for (BaseURLType type : antwoord.getBaseURLSet().getBaseURL()) {
            if (!type.getType().equalsIgnoreCase("anoniem")) continue;
            return type;
        }
        return null;
    }

    public static String getAfgifteURL(AfgifteType afgifte, BaseURLType type) {
        return type.getValue() + "/" + afgifte.getAfgifteID();
    }

    public static GregorianCalendar getDatumTijd(String dateStr) {
        Date date;
        if (dateStr == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyyy");
        if (dateStr.equalsIgnoreCase("nu")) {
            date = new Date();
        } else {
            try {
                date = format.parse(dateStr);
            }
            catch (ParseException ex) {
                LOG.error((Object)ex);
                return null;
            }
        }
        GregorianCalendar gregory = new GregorianCalendar();
        gregory.setTime(date);
        return gregory;
    }

    public static GregorianCalendar getDatumTijd(String refDate, int before) {
        GregorianCalendar ref = GDS2Util.getDatumTijd(refDate);
        ref.add(6, before);
        return ref;
    }

    public static XMLGregorianCalendar getXMLDatumTijd(int year, int month, int day) {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar(year, month - 1, day));
        }
        catch (DatatypeConfigurationException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static XMLGregorianCalendar getXMLDatumTijd(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(cal);
        }
        catch (DatatypeConfigurationException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static XMLGregorianCalendar getXMLDatumTijd(GregorianCalendar date) {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(date);
        }
        catch (DatatypeConfigurationException e) {
            LOG.error((Object)e);
            return null;
        }
    }

    private GDS2Util() {
    }
}

