/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.applet.local;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import nl.b3p.applet.local.IOUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Files {
    private static final int MAX_FILE_SIZE = 131072;

    public static String selectDirectory(Component component, String title) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(title);
        chooser.setFileSelectionMode(1);
        if (chooser.showOpenDialog(component) == 0) {
            return chooser.getSelectedFile().toString();
        }
        return null;
    }

    public static JSONArray listDirectory(String dir) throws JSONException {
        JSONArray ja = new JSONArray();
        for (File f : new File(dir).listFiles()) {
            JSONObject jo = new JSONObject();
            boolean isDir = f.isDirectory();
            jo.put("d", isDir ? 1 : 0);
            jo.put("n", f.getName());
            if (!isDir) {
                jo.put("s", f.length());
            }
            ja.put(jo);
        }
        return ja;
    }

    public static String readFileUTF8(String file) throws IOException {
        File f = new File(file);
        if (!f.exists() || !f.canRead()) {
            return null;
        }
        if (f.length() > 131072L) {
            throw new IOException("Bestand is te groot");
        }
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        IOUtils.copyLarge(in, out, buffer);
        return out.toString("UTF-8");
    }

    public static void writeFileUTF8(String file, String content) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(content.getBytes("UTF-8"));
        fos.flush();
        fos.close();
    }
}

