/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.applet.local;

import java.applet.Applet;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import netscape.javascript.JSObject;
import nl.b3p.applet.local.Files;
import nl.b3p.applet.local.NetCDF;
import nl.b3p.applet.local.Shapefiles;

public class LocalAccessApplet
extends Applet {
    private static final String TOOLTIP_DEFAULT = "Java applet voor het openen van lokale mappen";
    private final JLabel status = new JLabel("");
    private Icon java;
    private Icon spinner;
    private ExecutorService executorService;

    public void init() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(null);
        try {
            this.spinner = new ImageIcon(LocalAccessApplet.class.getResource("spinner.gif"));
            this.java = new ImageIcon(LocalAccessApplet.class.getResource("java.gif"));
            this.status.setIcon(this.java);
            this.add(this.status);
            this.status.setToolTipText(TOOLTIP_DEFAULT);
            this.status.setBounds(this.getWidth() - 16 - 1, 0, 16, 16);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.executorService = Executors.newSingleThreadExecutor();
        JSObject.getWindow((Applet)this).call("localAccessAppletLoaded", new Object[0]);
    }

    private void progress(boolean busy) {
        this.progress(busy, null);
    }

    private void progress(boolean busy, String tooltip) {
        if (busy) {
            this.status.setIcon(this.spinner);
            this.status.setToolTipText(tooltip == null ? TOOLTIP_DEFAULT : tooltip);
        } else {
            this.status.setIcon(this.java);
            this.status.setToolTipText(TOOLTIP_DEFAULT);
        }
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    private static String exceptionMessage(Exception e) {
        Throwable t = e;
        while (t instanceof InvocationTargetException && t.getCause() != null) {
            t = t.getCause();
        }
        String s = t.toString();
        StackTraceElement[] bt = t.getStackTrace();
        if (bt.length > 0) {
            s = s + " in " + bt[0].getFileName() + ":" + bt[0].getLineNumber() + " in " + bt[0].getMethodName();
        }
        return s;
    }

    private void doCallback(String callback, Object[] params) {
        Object[] params2 = new Object[params.length + 1];
        params2[0] = callback;
        System.arraycopy(params, 0, params2, 1, params.length);
        JSObject.getWindow((Applet)this).call("localAccessAppletCallback", params2);
    }

    private void doPrivileged(final String status, final Method method, final Object[] params, final String callback, final String errorCallback) {
        this.executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    LocalAccessApplet.this.progress(true, status);
                    Object ret = AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            try {
                                return method.invoke(null, params);
                            }
                            catch (Exception ex) {
                                return ex;
                            }
                        }
                    });
                    if (ret instanceof Exception) {
                        LocalAccessApplet.this.doCallback(errorCallback, new Object[]{LocalAccessApplet.exceptionMessage((Exception)ret)});
                    } else {
                        LocalAccessApplet.this.doCallback(callback, new Object[]{ret});
                    }
                }
                catch (Exception e) {
                    LocalAccessApplet.this.doCallback(errorCallback, new Object[]{LocalAccessApplet.exceptionMessage(e)});
                }
                finally {
                    LocalAccessApplet.this.progress(false);
                }
            }
        });
    }

    public void selectDirectory(String title, String callback, String errorCallback) throws NoSuchMethodException {
        this.doPrivileged("Dialoog om map te selecteren wordt getoond", Files.class.getMethod("selectDirectory", Component.class, String.class), new Object[]{this, title}, callback, errorCallback);
    }

    public void listDirectory(String dir, String callback, String errorCallback) throws NoSuchMethodException {
        this.doPrivileged("Ophalen lijst met bestanden in directory \"" + dir + "\"", Files.class.getMethod("listDirectory", String.class), new Object[]{dir}, callback, errorCallback);
    }

    public void readFileUTF8(String file, String callback, String errorCallback) throws NoSuchMethodException {
        this.doPrivileged("Lezen bestand \"" + file + "\"...", Files.class.getMethod("readFileUTF8", String.class), new Object[]{file}, callback, errorCallback);
    }

    public void writeFileUTF8(String file, String content, String callback, String errorCallback) throws NoSuchMethodException {
        this.doPrivileged("Schrijven bestand \"" + file + "\"...", Files.class.getMethod("writeFileUTF8", String.class, String.class), new Object[]{file, content}, callback, errorCallback);
    }

    public void getShapefileMetadata(String file, String callback, String errorCallback) throws NoSuchMethodException {
        this.doPrivileged("Lezen shapefile \"" + file + "\"...", Shapefiles.class.getMethod("getMetadata", String.class), new Object[]{file}, callback, errorCallback);
    }

    public void getNCDump(String file, String callback, String errorCallback) throws NoSuchMethodException {
        this.doPrivileged("Lezen NetCDF informatie \"" + file + "\"...", NetCDF.class.getMethod("getNCDump", String.class), new Object[]{file}, callback, errorCallback);
    }

    public void getNCML(String file, String callback, String errorCallback) throws NoSuchMethodException {
        this.doPrivileged("Lezen NetCDF informatie \"" + file + "\"...", NetCDF.class.getMethod("getNCML", String.class), new Object[]{file}, callback, errorCallback);
    }

    public void setNCTitle(String file, String title, String callback, String errorCallback) throws NoSuchMethodException {
        this.doPrivileged("Schrijven NetCDF informatie naar \"" + file + "\"...", NetCDF.class.getMethod("setTitle", String.class, String.class), new Object[]{file, title}, callback, errorCallback);
    }
}

