/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.DateUtils;
import com.bradmcevoy.http.Request;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractRequest
implements Request {
    private Log log = LogFactory.getLog(AbstractRequest.class);
    public static final int INFINITY = 3;

    protected abstract String getRequestHeader(Request.Header var1);

    public Date getIfModifiedHeader() {
        String s = this.getRequestHeader(Request.Header.IF_MODIFIED);
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            return DateUtils.parseDate(s);
        }
        catch (DateUtils.DateParseException ex) {
            this.log.error((Object)("Unable to parse date: " + s), (Throwable)ex);
            return null;
        }
    }

    public String getAcceptHeader() {
        return this.getRequestHeader(Request.Header.ACCEPT);
    }

    public String getRefererHeader() {
        return this.getRequestHeader(Request.Header.REFERER);
    }

    public String getContentTypeHeader() {
        return this.getRequestHeader(Request.Header.CONTENT_TYPE);
    }

    public String getAcceptEncodingHeader() {
        return this.getRequestHeader(Request.Header.ACCEPT_ENCODING);
    }

    public int getDepthHeader() {
        String depthStr = this.getRequestHeader(Request.Header.DEPTH);
        if (depthStr == null) {
            return 3;
        }
        if (depthStr.equals("0")) {
            return 0;
        }
        if (depthStr.equals("1")) {
            return 1;
        }
        if (depthStr.equals("infinity")) {
            return 3;
        }
        this.log.warn((Object)("Unknown depth value: " + depthStr));
        return 3;
    }

    public String getHostHeader() {
        return this.getRequestHeader(Request.Header.HOST);
    }

    public String getDestinationHeader() {
        return this.getRequestHeader(Request.Header.DESTINATION);
    }

    public Long getContentLengthHeader() {
        String s = this.getRequestHeader(Request.Header.CONTENT_LENGTH);
        if (s == null || s.length() == 0) {
            return null;
        }
        try {
            long l = Long.parseLong(s);
            return l;
        }
        catch (NumberFormatException ex) {
            this.log.warn((Object)("Couldnt parse content length header: " + s));
            return null;
        }
    }

    public String getTimeoutHeader() {
        return this.getRequestHeader(Request.Header.TIMEOUT);
    }

    public String getIfHeader() {
        return this.getRequestHeader(Request.Header.IF);
    }

    public String getLockTokenHeader() {
        return this.getRequestHeader(Request.Header.LOCK_TOKEN);
    }

    public final String getAbsolutePath() {
        return AbstractRequest.stripToPath(this.getAbsoluteUrl());
    }

    public static String stripToPath(String url) {
        int i = url.indexOf("/", 8);
        return url.substring(i);
    }
}

