/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.CopyableResource;
import com.bradmcevoy.http.Dest;
import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CopyHandler
extends ExistingEntityHandler {
    private Log log = LogFactory.getLog(CopyHandler.class);

    public CopyHandler(HttpManager manager) {
        super(manager);
    }

    protected Request.Method method() {
        return Request.Method.COPY;
    }

    protected boolean isCompatible(Resource handler) {
        return handler instanceof CopyableResource;
    }

    protected void process(HttpManager milton, Request request, Response response, Resource resource) {
        CopyableResource r = (CopyableResource)resource;
        String sDest = request.getDestinationHeader();
        sDest = HttpManager.decodeUrl(sDest);
        Dest dest = new Dest(request.getHostHeader(), sDest);
        Resource rDest = this.manager.getResourceFactory().getResource(dest.host, dest.url);
        this.log.debug((Object)("process: copying from: " + r.getName() + " -> " + dest.url + "/" + dest.name));
        if (rDest == null) {
            this.log.debug((Object)("process: destination parent does not exist: " + sDest));
            response.setStatus(Response.Status.SC_CONFLICT);
            this.output(response, "Destination does not exist: " + sDest);
        } else if (!(rDest instanceof CollectionResource)) {
            this.log.debug((Object)"process: destination exists but is not a collection");
            response.setStatus(Response.Status.SC_CONFLICT);
            this.output(response, "Destination exists but is not a collection: " + sDest);
        } else {
            this.log.debug((Object)("process: moving resource to: " + rDest.getName()));
            r.copyTo((CollectionResource)rDest, dest.name);
            response.setStatus(Response.Status.SC_CREATED);
        }
        this.log.debug((Object)"process: finished");
    }
}

