/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.RequestParseException;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetHandler
extends ExistingEntityHandler {
    private Log log = LogFactory.getLog(GetHandler.class);

    public GetHandler(HttpManager manager) {
        super(manager);
    }

    @Override
    protected void process(HttpManager milton, Request request, Response response, Resource resource) {
        GetableResource r = (GetableResource)resource;
        if (this.checkConditional(r, request)) {
            this.respondNotModified(r, response, request);
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, FileItem> files = new HashMap<String, FileItem>();
        try {
            request.parseRequestParameters(params, files);
        }
        catch (RequestParseException ex) {
            this.log.warn((Object)"exception parsing request. probably interrupted upload", (Throwable)ex);
            return;
        }
        this.manager.onGet(request, response, resource, params);
        this.respondWithContent(request, response, r, params);
    }

    public Range getRange(Request requestInfo) {
        return null;
    }

    protected boolean checkConditional(GetableResource resource, Request request) {
        if (this.checkIfMatch(resource, request)) {
            return true;
        }
        if (this.checkIfModifiedSince(resource, request)) {
            return true;
        }
        return this.checkIfNoneMatch(resource, request);
    }

    protected void respondNotModified(GetableResource resource, Response response, Request request) {
        this.log.debug((Object)"not modified");
        response.setDateHeader(new Date());
        String acc = request.getAcceptHeader();
        response.setContentTypeHeader(resource.getContentType(acc));
        response.setStatus(Response.Status.SC_NOT_MODIFIED);
    }

    protected boolean checkIfMatch(GetableResource handler, Request requestInfo) {
        return false;
    }

    protected boolean checkIfModifiedSince(GetableResource handler, Request requestInfo) {
        Date dtRequest = requestInfo.getIfModifiedHeader();
        if (dtRequest == null) {
            return false;
        }
        Date dtCurrent = handler.getModifiedDate();
        if (dtCurrent == null) {
            return true;
        }
        return dtCurrent.compareTo(dtRequest) < 0;
    }

    protected boolean checkIfNoneMatch(GetableResource handler, Request requestInfo) {
        return false;
    }

    @Override
    protected Request.Method method() {
        return Request.Method.GET;
    }

    @Override
    protected boolean isCompatible(Resource handler) {
        return handler instanceof GetableResource;
    }

    protected void respondWithContent(Request request, Response response, GetableResource resource, Map<String, String> params) {
        this._respondWithContent(request, response, resource, params);
    }

    @Override
    public void setStatus(GetableResource resource, Response response, Request request) {
        Range range = this.getRange(request);
        if (range == null) {
            response.setStatus(Response.Status.SC_OK);
        } else {
            response.setStatus(Response.Status.SC_PARTIAL_CONTENT);
            response.setContentRangeHeader(range.start, range.finish, resource.getContentLength());
        }
    }

    @Override
    protected void sendContent(Request request, Response response, GetableResource resource, Map<String, String> params) {
        Range range = this.getRange(request);
        this.sendContent(request, response, resource, params, range);
    }

    @Override
    protected boolean doCheckRedirect(Request request, Response response, Resource resource) {
        String redirectUrl = resource.checkRedirect(request);
        if (redirectUrl != null) {
            this.respondRedirect(response, redirectUrl);
            return true;
        }
        return false;
    }
}

