/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Request;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockTimeout {
    private static Log log = LogFactory.getLog(LockTimeout.class);
    private static final String INFINITE = "Infinite";
    final Long seconds;
    final Long[] otherSeconds;

    public static LockTimeout parseTimeout(Request request) {
        String sTimeout = request.getTimeoutHeader();
        log.debug((Object)("..requested timeout: " + sTimeout));
        return LockTimeout.parseTimeout(sTimeout);
    }

    public static LockTimeout parseTimeout(String s) {
        if (s == null) {
            return new LockTimeout(null);
        }
        if ((s = s.trim()).length() == 0) {
            return new LockTimeout(null);
        }
        ArrayList<Long> list = new ArrayList<Long>();
        for (String part : s.split(",")) {
            if ((part = part.trim()).equalsIgnoreCase(INFINITE)) {
                list.add(Long.MAX_VALUE);
                continue;
            }
            Long seconds = LockTimeout.parseTimeoutPart(part);
            if (seconds == null) continue;
            list.add(seconds);
        }
        LockTimeout timeout = new LockTimeout(list);
        return timeout;
    }

    static String trim(String s) {
        if (s == null) {
            return "";
        }
        return s.trim();
    }

    static boolean isPresent(String s) {
        return s != null && s.length() > 0;
    }

    private static Long parseTimeoutPart(String part) {
        if (part == null || part.length() == 0) {
            return null;
        }
        int pos = part.indexOf("-");
        if (pos <= 0) {
            return null;
        }
        String s = part.substring(pos + 1, part.length());
        long l = 0L;
        try {
            l = Long.parseLong(s);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            log.error((Object)("Number format exception parsing timeout: " + s));
            return null;
        }
    }

    private LockTimeout(List<Long> timeouts) {
        if (timeouts == null || timeouts.size() == 0) {
            this.seconds = null;
            this.otherSeconds = null;
        } else {
            this.seconds = timeouts.get(0);
            timeouts.remove(0);
            this.otherSeconds = new Long[timeouts.size()];
            timeouts.toArray(this.otherSeconds);
        }
    }

    public Long getSeconds() {
        return this.seconds;
    }

    public Long[] getOtherSeconds() {
        return this.otherSeconds;
    }
}

