/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.AbstractMiltonEndPoint;
import com.bradmcevoy.http.ApplicationConfig;
import com.bradmcevoy.http.ServletRequest;
import com.bradmcevoy.http.ServletResponse;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MiltonServlet
extends AbstractMiltonEndPoint
implements Servlet {
    private Log log = LogFactory.getLog(MiltonServlet.class);
    private ServletConfig config;
    private static final ThreadLocal<HttpServletRequest> originalRequest = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> originalResponse = new ThreadLocal();

    public static HttpServletRequest request() {
        return originalRequest.get();
    }

    public static HttpServletResponse response() {
        return originalResponse.get();
    }

    public static void forward(String url) {
        try {
            MiltonServlet.request().getRequestDispatcher(url).forward((javax.servlet.ServletRequest)originalRequest.get(), (javax.servlet.ServletResponse)originalResponse.get());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (ServletException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        try {
            this.config = config;
            String resourceFactoryFactoryClassName = config.getInitParameter("resource.factory.factory.class");
            if (resourceFactoryFactoryClassName != null && resourceFactoryFactoryClassName.length() > 0) {
                this.initFromFactoryFactory(resourceFactoryFactoryClassName);
            } else {
                String resourceFactoryClassName = config.getInitParameter("resource.factory.class");
                this.init(resourceFactoryClassName);
            }
            this.httpManager.init(new ApplicationConfig(config), this.httpManager);
        }
        catch (ServletException ex) {
            this.log.error((Object)"Exception starting milton servlet", (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            this.log.error((Object)"Exception starting milton servlet", ex);
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(javax.servlet.ServletRequest servletRequest, javax.servlet.ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        HttpServletResponse resp = (HttpServletResponse)servletResponse;
        try {
            originalRequest.set(req);
            originalResponse.set(resp);
            ServletRequest request = new ServletRequest(req);
            ServletResponse response = new ServletResponse(resp);
            this.httpManager.process(request, response);
        }
        finally {
            originalRequest.remove();
            originalResponse.remove();
            servletResponse.flushBuffer();
        }
    }

    public String getServletInfo() {
        return "MiltonServlet";
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }
}

