/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.DateUtils;
import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.PropFindSaxHandler;
import com.bradmcevoy.http.PropFindableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.XmlWriter;
import com.bradmcevoy.io.StreamToStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropFindHandler
extends ExistingEntityHandler {
    private Log log = LogFactory.getLog(PropFindHandler.class);
    final Map<String, PropertyWriter> writersMap = new HashMap<String, PropertyWriter>();

    PropFindHandler(HttpManager manager) {
        super(manager);
        this.add(new ContentLengthPropertyWriter());
        this.add(new ContentTypePropertyWriter());
        this.add(new CreationDatePropertyWriter());
        this.add(new DisplayNamePropertyWriter());
        this.add(new LastModifiedDatePropertyWriter());
        this.add(new ResourceTypePropertyWriter());
        this.add(new EtagPropertyWriter());
        this.add(new MSHrefPropertyWriter());
        this.add(new MSIsCollectionPropertyWriter());
        this.add(new MSNamePropertyWriter());
    }

    private void add(PropertyWriter pw) {
        this.writersMap.put(pw.fieldName(), pw);
    }

    @Override
    public Request.Method method() {
        return Request.Method.PROPFIND;
    }

    @Override
    protected boolean isCompatible(Resource handler) {
        return handler instanceof PropFindableResource;
    }

    @Override
    protected void process(HttpManager milton, Request request, Response response, Resource resource) {
        Set<String> requestedFields;
        PropFindableResource pfr = (PropFindableResource)resource;
        int depth = request.getDepthHeader();
        response.setStatus(Response.Status.SC_MULTI_STATUS);
        response.setContentTypeHeader("text/xml; charset=UTF-8");
        try {
            requestedFields = this.getRequestedFields(request);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XmlWriter writer = new XmlWriter(out);
            writer.writeXMLHeader();
            writer.open("D:multistatus" + this.generateNamespaceDeclarations());
            writer.newLine();
            this.appendResponses(writer, pfr, depth, requestedFields, request.getAbsolutePath(), request.getHostHeader());
            writer.close("D:multistatus");
            writer.flush();
            response.getOutputStream().write(out.toByteArray());
        }
        catch (IOException ex) {
            this.log.warn((Object)"ioexception sending output", (Throwable)ex);
        }
    }

    void appendResponses(XmlWriter writer, PropFindableResource resource, int depth, Set<String> requestedFields, String requestUrl, String host) {
        String collectionHref = this.suffixSlash("http://" + host + requestUrl);
        this.log.debug((Object)("collectionHref: " + collectionHref));
        this.sendResponse(writer, resource, requestedFields, collectionHref);
        if (depth > 0 && resource instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)((Object)resource);
            ArrayList<? extends Resource> list = new ArrayList<Resource>(col.getChildren());
            this.log.debug((Object)("appendResponses: " + list.size()));
            for (Resource resource2 : list) {
                if (resource2 instanceof PropFindableResource) {
                    this.sendResponse(writer, (PropFindableResource)resource2, requestedFields, collectionHref + resource2.getName());
                    continue;
                }
                this.log.debug((Object)("not adding child: " + resource2));
            }
        }
    }

    void sendResponse(XmlWriter writer, PropFindableResource resource, Set<String> requestedFields, String href) {
        XmlWriter.Element el = writer.begin("D:response").open();
        HashSet<PropertyWriter> unknownProperties = new HashSet<PropertyWriter>();
        HashSet<PropertyWriter> knownProperties = new HashSet<PropertyWriter>();
        String href2 = this.urlEncode(href);
        writer.writeProperty(null, "D:href", href2);
        for (String field : requestedFields) {
            PropertyWriter pw = this.writersMap.get(field);
            if (pw != null) {
                knownProperties.add(pw);
                continue;
            }
            unknownProperties.add(new UnknownPropertyWriter(field));
        }
        this.sendResponseProperties(writer, resource, knownProperties, href, "HTTP/1.1 200 Ok");
        this.sendResponseProperties(writer, resource, unknownProperties, href, "HTTP/1.1 404 Not Found");
        el.close();
    }

    void sendResponseProperties(XmlWriter writer, PropFindableResource resource, Set<PropertyWriter> properties, String href, String status) {
        if (!properties.isEmpty()) {
            XmlWriter.Element elUnknownPropStat = writer.begin("D:propstat").open();
            XmlWriter.Element elUnknownProp = writer.begin("D:prop").open();
            for (PropertyWriter pw : properties) {
                this.appendField(pw, writer, resource, href);
            }
            elUnknownProp.close();
            writer.writeProperty(null, "D:status", status);
            elUnknownPropStat.close();
        }
    }

    private String suffixSlash(String s) {
        if (!s.endsWith("/")) {
            s = s + "/";
        }
        return s;
    }

    private String urlEncode(String href) {
        String s = href.replaceAll(" ", "%20");
        return s;
    }

    protected void sendStringProp(XmlWriter writer, String name, String value) {
        String s = value;
        if (s == null) {
            writer.writeProperty(null, name);
        } else {
            writer.writeProperty(null, name, s);
        }
    }

    void sendDateProp(XmlWriter writer, String name, Date date) {
        this.sendStringProp(writer, name, date == null ? null : DateUtils.formatDate(date));
    }

    protected boolean isFolder(PropFindableResource resource) {
        return resource instanceof CollectionResource;
    }

    private void appendField(PropertyWriter propertyWriter, XmlWriter writer, PropFindableResource resource, String collectionHref) {
        propertyWriter.append(writer, resource, collectionHref);
    }

    private Set<String> getRequestedFields(Request request) throws IOException, SAXException, FileNotFoundException {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        InputStream in = request.getInputStream();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        StreamToStream.readTo(in, bout, false, true);
        byte[] arr = bout.toByteArray();
        if (arr.length > 1) {
            ByteArrayInputStream bin = new ByteArrayInputStream(arr);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            PropFindSaxHandler handler = new PropFindSaxHandler();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(bin));
            set.addAll(handler.getAttributes().keySet());
        }
        if (set.size() == 0) {
            set.add("creationdate");
            set.add("getlastmodified");
            set.add("displayname");
            set.add("resourcetype");
            set.add("getcontenttype");
            set.add("getcontentlength");
            set.add("getetag");
        }
        return set;
    }

    class UnknownPropertyWriter
    implements PropertyWriter {
        final String name;

        public UnknownPropertyWriter(String name) {
            this.name = name;
        }

        public void append(XmlWriter writer, PropFindableResource res, String href) {
            PropFindHandler.this.sendStringProp(writer, "D:" + this.fieldName(), null);
        }

        public String fieldName() {
            return this.name;
        }
    }

    class MSIsCollectionPropertyWriter
    implements PropertyWriter {
        MSIsCollectionPropertyWriter() {
        }

        public void append(XmlWriter writer, PropFindableResource res, String href) {
            String s = PropFindHandler.this.isFolder(res) ? "true" : "false";
            PropFindHandler.this.sendStringProp(writer, "D:" + this.fieldName(), s);
        }

        public String fieldName() {
            return "iscollection";
        }
    }

    class MSHrefPropertyWriter
    implements PropertyWriter {
        MSHrefPropertyWriter() {
        }

        public void append(XmlWriter writer, PropFindableResource res, String href) {
            PropFindHandler.this.sendStringProp(writer, "D:" + this.fieldName(), href);
        }

        public String fieldName() {
            return "href";
        }
    }

    class MSNamePropertyWriter
    implements PropertyWriter {
        MSNamePropertyWriter() {
        }

        public void append(XmlWriter writer, PropFindableResource res, String href) {
            PropFindHandler.this.sendStringProp(writer, "D:" + this.fieldName(), res.getName());
        }

        public String fieldName() {
            return "name";
        }
    }

    class EtagPropertyWriter
    implements PropertyWriter {
        EtagPropertyWriter() {
        }

        public void append(XmlWriter writer, PropFindableResource resource, String href) {
            String etag = resource.getUniqueId();
            if (etag != null) {
                PropFindHandler.this.sendStringProp(writer, "D:getetag", etag);
            }
        }

        public String fieldName() {
            return "getetag";
        }
    }

    class ContentLengthPropertyWriter
    implements PropertyWriter {
        ContentLengthPropertyWriter() {
        }

        public void append(XmlWriter xmlWriter, PropFindableResource res, String href) {
            if (res instanceof GetableResource) {
                GetableResource getable = (GetableResource)((Object)res);
                Long l = getable.getContentLength();
                String s = l == null ? "0" : l.toString();
                PropFindHandler.this.sendStringProp(xmlWriter, "D:" + this.fieldName(), s);
            } else {
                PropFindHandler.this.sendStringProp(xmlWriter, "D:" + this.fieldName(), "");
            }
        }

        public String fieldName() {
            return "getcontentlength";
        }
    }

    class ContentTypePropertyWriter
    implements PropertyWriter {
        ContentTypePropertyWriter() {
        }

        public void append(XmlWriter xmlWriter, PropFindableResource res, String href) {
            if (res instanceof GetableResource) {
                GetableResource getable = (GetableResource)((Object)res);
                PropFindHandler.this.sendStringProp(xmlWriter, "D:" + this.fieldName(), getable.getContentType(null));
            } else {
                PropFindHandler.this.sendStringProp(xmlWriter, "D:" + this.fieldName(), "");
            }
        }

        public String fieldName() {
            return "getcontenttype";
        }
    }

    class ResourceTypePropertyWriter
    implements PropertyWriter {
        ResourceTypePropertyWriter() {
        }

        public void append(XmlWriter writer, PropFindableResource resource, String href) {
            String rt = PropFindHandler.this.isFolder(resource) ? "<D:collection/>" : "";
            PropFindHandler.this.sendStringProp(writer, "D:resourcetype", rt);
        }

        public String fieldName() {
            return "resourcetype";
        }
    }

    class CreationDatePropertyWriter
    implements PropertyWriter {
        CreationDatePropertyWriter() {
        }

        public void append(XmlWriter xmlWriter, PropFindableResource res, String href) {
            PropFindHandler.this.sendDateProp(xmlWriter, "D:" + this.fieldName(), res.getCreateDate());
        }

        public String fieldName() {
            return "creationdate";
        }
    }

    class LastModifiedDatePropertyWriter
    implements PropertyWriter {
        LastModifiedDatePropertyWriter() {
        }

        public void append(XmlWriter xmlWriter, PropFindableResource res, String href) {
            String f = DateUtils.formatForWebDavModifiedDate(res.getModifiedDate());
            PropFindHandler.this.sendStringProp(xmlWriter, "D:" + this.fieldName(), f);
        }

        public String fieldName() {
            return "getlastmodified";
        }
    }

    class DisplayNamePropertyWriter
    implements PropertyWriter {
        DisplayNamePropertyWriter() {
        }

        public void append(XmlWriter writer, PropFindableResource res, String href) {
            PropFindHandler.this.sendStringProp(writer, "D:" + this.fieldName(), res.getName());
        }

        public String fieldName() {
            return "displayname";
        }
    }

    static interface PropertyWriter {
        public String fieldName();

        public void append(XmlWriter var1, PropFindableResource var2, String var3);
    }
}

