/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.RequestParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Request {
    public String getFromAddress();

    public String getLockTokenHeader();

    public Method getMethod();

    public Auth getAuthorization();

    public String getRefererHeader();

    public String getTimeoutHeader();

    public String getIfHeader();

    public Date getIfModifiedHeader();

    public int getDepthHeader();

    public String getAbsoluteUrl();

    public String getAbsolutePath();

    public String getHostHeader();

    public String getDestinationHeader();

    public InputStream getInputStream() throws IOException;

    public void parseRequestParameters(Map<String, String> var1, Map<String, FileItem> var2) throws RequestParseException;

    public String getContentTypeHeader();

    public Long getContentLengthHeader();

    public String getAcceptHeader();

    public String getAcceptEncodingHeader();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        HEAD("HEAD", false),
        PROPFIND("PROPFIND", false),
        PROPPATCH("PROPPATCH", false),
        MKCOL("MKCOL", true),
        COPY("COPY", true),
        MOVE("MOVE", true),
        LOCK("LOCK", true),
        UNLOCK("UNLOCK", true),
        DELETE("DELETE", true),
        GET("GET", false),
        OPTIONS("OPTIONS", false),
        POST("POST", true),
        PUT("PUT", true),
        TRACE("TRACE", false);

        public String code;
        public boolean isWrite;

        private Method(String code, boolean isWrite) {
            this.code = code;
            this.isWrite = isWrite;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Header {
        CACHE_CONTROL("Cache-Control"),
        WWW_AUTHENTICATE("WWW-Authenticate"),
        IF("If"),
        IF_MODIFIED("If-Modified-Since"),
        IF_NOT_MODIFIED("If-Unmodified-Since"),
        CONTENT_LENGTH("Content-Length"),
        CONTENT_TYPE("Content-Type"),
        CONTENT_RANGE("Content-Range"),
        DEPTH("Depth"),
        HOST("Host"),
        DESTINATION("Destination"),
        REFERER("Referer"),
        ACCEPT("Accept"),
        ACCEPT_ENCODING("Accept-Encoding"),
        TIMEOUT("Timeout"),
        LOCK_TOKEN("Lock-Token"),
        AUTHORIZATION("Authorization");

        public String code;

        private Header(String code) {
            this.code = code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CacheControlRequest {
        NO_CACHE("no-cache"),
        NO_STORE("no-store"),
        MAX_AGE("max-age"),
        MAX_STALE("max-stale"),
        MIN_FRESH("min-fresh"),
        NO_TRANSFORM("no-transform"),
        ONLY_IF_CACHED("only-if-cached"),
        CACHE_EXT("cache-extension");

        public String code;

        private CacheControlRequest(String code) {
            this.code = code;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Depth {
        ZERO,
        ONE,
        INFINITY;

    }
}

