/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.AbstractResponse;
import com.bradmcevoy.http.GetHandler;
import com.bradmcevoy.http.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletResponse
extends AbstractResponse {
    private Log log = LogFactory.getLog(GetHandler.class);
    private static ThreadLocal<HttpServletResponse> tlResponse = new ThreadLocal();
    private final HttpServletResponse r;
    private Long contentLength;
    private Response.Status status;
    private Map<String, String> headers = new HashMap<String, String>();

    public static HttpServletResponse getResponse() {
        return tlResponse.get();
    }

    public ServletResponse(HttpServletResponse r) {
        this.r = r;
        tlResponse.set(r);
    }

    public String getNonStandardHeader(String code) {
        return this.headers.get(code);
    }

    public void setNonStandardHeader(String name, String value) {
        this.r.addHeader(name, value);
        this.headers.put(name, value);
    }

    public void setStatus(Response.Status status) {
        this.r.setStatus(status.code);
        this.status = status;
    }

    public Response.Status getStatus() {
        return this.status;
    }

    public void setContentLengthHeader(Long totalLength) {
        this.contentLength = totalLength;
        super.setContentLengthHeader(totalLength);
    }

    public OutputStream getOutputStream() {
        try {
            return this.r.getOutputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void close() {
        this.log.debug((Object)("closing: contentlength: " + this.contentLength));
        try {
            this.r.flushBuffer();
            this.r.getOutputStream().flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

