/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.io.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XmlWriter {
    private Log log = LogFactory.getLog(XmlWriter.class);
    protected final Writer writer;

    public XmlWriter(OutputStream out) {
        this.writer = new PrintWriter(out, true);
    }

    private void append(String value) {
        try {
            this.writer.write(value);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void append(char c) {
        try {
            this.writer.write(c);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void writeProperty(String namespace, String namespaceInfo, String name, String value) {
        this.writeElement(namespace, namespaceInfo, name, Type.OPENING);
        this.append(value);
        this.writeElement(namespace, namespaceInfo, name, Type.CLOSING);
    }

    public void writeProperty(String namespace, String name, String value) {
        this.writeElement(namespace, name, Type.OPENING);
        this.append(value);
        this.writeElement(namespace, name, Type.CLOSING);
    }

    public void writeProperty(String namespace, String name) {
        this.writeElement(namespace, name, Type.NO_CONTENT);
    }

    public void writeElement(String namespace, String name, Type type) {
        this.writeElement(namespace, null, name, type);
    }

    public void open(String namespace, String name) {
        this.writeElement(namespace, name, Type.OPENING);
    }

    public void close(String namespace, String name) {
        this.writeElement(namespace, name, Type.CLOSING);
    }

    public void open(String name) {
        this.writeElement(null, name, Type.OPENING);
    }

    public void close(String name) {
        this.writeElement(null, name, Type.CLOSING);
    }

    public Element begin(String name) {
        Element el = new Element(name);
        return el;
    }

    public void writeElement(String namespace, String namespaceInfo, String name, Type type) {
        if (namespace != null && namespace.length() > 0) {
            switch (type) {
                case OPENING: {
                    if (namespaceInfo != null) {
                        this.append("<" + namespace + ":" + name + " xmlns:" + namespace + "=\"" + namespaceInfo + "\">");
                        break;
                    }
                    this.append("<" + namespace + ":" + name + ">");
                    break;
                }
                case CLOSING: {
                    this.append("</" + namespace + ":" + name + ">\n");
                    break;
                }
                default: {
                    if (namespaceInfo != null) {
                        this.append("<" + namespace + ":" + name + " xmlns:" + namespace + "=\"" + namespaceInfo + "\"/>");
                        break;
                    }
                    this.append("<" + namespace + ":" + name + "/>");
                    break;
                }
            }
        } else {
            switch (type) {
                case OPENING: {
                    this.append("<" + name + ">");
                    break;
                }
                case CLOSING: {
                    this.append("</" + name + ">\n");
                    break;
                }
                default: {
                    this.append("<" + name + "/>");
                }
            }
        }
    }

    public void writeText(String text) {
        this.append(text);
    }

    public void writeData(String data) {
        this.append("<![CDATA[" + data + "]]>");
    }

    public void writeXMLHeader() {
        this.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
    }

    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(InputStream in) {
        this.log.debug((Object)"outputting sample");
        try {
            ByteArrayOutputStream out = FileUtils.readIn(in);
            this.writer.write(out.toString());
        }
        catch (FileNotFoundException ex) {
            this.log.error((Object)"", (Throwable)ex);
        }
        catch (IOException ex) {
            this.log.error((Object)"", (Throwable)ex);
        }
        finally {
            FileUtils.close(in);
        }
    }

    public void newLine() {
        this.append("\n");
    }

    public class Element {
        private final String name;

        Element(String name) {
            this.name = name;
            XmlWriter.this.append("<");
            XmlWriter.this.append(name);
        }

        public Element writeAtt(String name, String value) {
            XmlWriter.this.append(" ");
            XmlWriter.this.append(name);
            XmlWriter.this.append("=");
            XmlWriter.this.append('\"');
            XmlWriter.this.append(value);
            XmlWriter.this.append('\"');
            return this;
        }

        public Element writeText(String text) {
            XmlWriter.this.append(text);
            return this;
        }

        public Element open() {
            XmlWriter.this.append(">\n");
            return this;
        }

        public Element close() {
            XmlWriter.this.append("</" + this.name + ">\n");
            return this;
        }

        public Element noContent() {
            XmlWriter.this.append("/>\n");
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        OPENING,
        CLOSING,
        NO_CONTENT;

    }
}

