/*
 * Decompiled with CFR 0.152.
 */
package eu.medsea.util;

import eu.medsea.util.InvalidMagicMimeEntryException;
import eu.medsea.util.MagicMimeEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class MimeUtil {
    private static final String[] magicMimeFileLocations;
    public static final String UNKNOWN_MIME_TYPE = "application/x-unknown-mime-type";
    private static ByteOrder nativeByteOrder;
    private static Map mimeTypes;
    private static ArrayList mMagicMimeEntries;

    public static ByteOrder getNativeOrder() {
        return nativeByteOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMimeType(File file) {
        String mimeType = null;
        try {
            mimeType = MimeUtil.getMagicMimeType(file);
        }
        catch (Exception exception) {
        }
        finally {
            if (mimeType == null) {
                mimeType = UNKNOWN_MIME_TYPE;
            }
        }
        return mimeType;
    }

    public static String getMimeType(String fname) {
        String ext;
        String mimeType = null;
        if (fname == null || "".equals(fname.trim())) {
            fname = "";
        }
        if ((ext = MimeUtil.getFileExtension(fname)) == null || "".equals(ext.trim())) {
            mimeType = MimeUtil.getMimeType(new File(fname));
        } else {
            mimeType = (String)mimeTypes.get(ext);
            if ((mimeType == null || "".equals(mimeType.trim())) && ((mimeType = (String)mimeTypes.get(ext.toLowerCase())) == null || "".equals(mimeType.trim()))) {
                mimeType = MimeUtil.getMimeType(new File(fname));
            }
        }
        return mimeType;
    }

    public static String getPreferedMimeType(String wanted, String canProvide) {
        if (wanted == null || wanted.trim().length() == 0) {
            wanted = "";
        }
        String[] wantedArray = wanted.split(",");
        String[] canProvideArray = canProvide.split(",");
        if (canProvideArray.length == 1) {
            return canProvideArray[0].trim();
        }
        for (int i = 0; i < wantedArray.length; ++i) {
            if (wantedArray[i].trim().equals("*/*")) {
                return canProvideArray[0].trim();
            }
            for (int j = 0; j < canProvideArray.length; ++j) {
                if (wantedArray[i].trim().compareToIgnoreCase(canProvideArray[j].trim()) != 0) continue;
                return wantedArray[i].trim();
            }
        }
        return canProvideArray[0].trim();
    }

    public static void main(String[] args) throws IOException {
        System.out.println(mMagicMimeEntries);
        File dir = new File(".");
        File[] f = dir.listFiles();
        for (int i = 0; i < f.length; ++i) {
            System.out.println("file : " + f[i].getCanonicalPath() + " : mimeType : " + MimeUtil.getMimeType(f[i].getCanonicalPath()));
        }
        System.out.println(MimeUtil.getMajorComponent("application/abcd"));
        System.out.println(MimeUtil.getMajorComponent("application"));
        System.out.println(MimeUtil.getMajorComponent("/application/abcd"));
        System.out.println(MimeUtil.getMajorComponent(""));
        System.out.println(MimeUtil.getMajorComponent(null));
        System.out.println(MimeUtil.getMinorComponent("application/abcd"));
        System.out.println(MimeUtil.getMinorComponent("application"));
        System.out.println(MimeUtil.getMinorComponent("/application/abcd"));
        System.out.println(MimeUtil.getMinorComponent(""));
        System.out.println(MimeUtil.getMinorComponent(null));
    }

    private static void parse(Reader r) throws IOException {
        BufferedReader br = new BufferedReader(r);
        ArrayList<String> sequence = new ArrayList<String>();
        String line = br.readLine();
        block0: while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = br.readLine();
                continue;
            }
            sequence.add(line);
            while (true) {
                if ((line = br.readLine()) == null) {
                    MimeUtil.addEntry(sequence);
                    sequence.clear();
                    continue block0;
                }
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                if (line.charAt(0) != '>') {
                    MimeUtil.addEntry(sequence);
                    sequence.clear();
                    continue block0;
                }
                sequence.add(line);
            }
        }
        if (!sequence.isEmpty()) {
            MimeUtil.addEntry(sequence);
        }
    }

    private static void addEntry(ArrayList aStringArray) {
        try {
            MagicMimeEntry magicEntry = new MagicMimeEntry(aStringArray);
            mMagicMimeEntries.add(magicEntry);
        }
        catch (InvalidMagicMimeEntryException e) {
            e.printStackTrace();
        }
    }

    private static String getMagicMimeType(File f) throws IOException {
        if (f.isDirectory()) {
            return "application/directory";
        }
        int len = mMagicMimeEntries.size();
        RandomAccessFile raf = new RandomAccessFile(f, "r");
        for (int i = 0; i < len; ++i) {
            MagicMimeEntry me = (MagicMimeEntry)mMagicMimeEntries.get(i);
            String mtype = me.getMatch(raf);
            if (mtype == null) continue;
            return mtype;
        }
        return null;
    }

    public static String getMajorComponent(String mimeType) {
        if (mimeType == null) {
            return "";
        }
        int offset = mimeType.indexOf("/");
        if (offset == -1) {
            return mimeType;
        }
        return mimeType.substring(0, offset);
    }

    public static String getMinorComponent(String mimeType) {
        if (mimeType == null) {
            return "";
        }
        int offset = mimeType.indexOf("/");
        if (offset == -1) {
            return mimeType;
        }
        return mimeType.substring(offset + 1);
    }

    public static String getFileExtension(File file) {
        try {
            return MimeUtil.getFileExtension(file.getCanonicalPath());
        }
        catch (IOException e) {
            return "";
        }
    }

    public static String getFileExtension(String fileName) {
        if (fileName == null || fileName.lastIndexOf(".") < 0) {
            return "";
        }
        String extension = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (extension.contains(File.separator)) {
            extension = "";
        }
        return extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is;
        block35: {
            magicMimeFileLocations = new String[]{"/etc/magic.mime", "/usr/share/file/magic.mime"};
            nativeByteOrder = ByteOrder.nativeOrder();
            mMagicMimeEntries = new ArrayList();
            mimeTypes = new Properties();
            try {
                ((Properties)mimeTypes).load(MimeUtil.class.getClassLoader().getResourceAsStream("eu/medsea/util/mime-types.properties"));
                is = MimeUtil.class.getClassLoader().getResourceAsStream("mime-types.properties");
                if (is != null) {
                    try {
                        Properties props = new Properties();
                        props.load(is);
                        if (props.size() > 0) {
                            System.out.println("Customisations of Mime Types are available");
                            mimeTypes.putAll(props);
                        }
                        break block35;
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                }
                System.out.println("No Customisation or Mime Types available.");
            }
            catch (IOException is2) {
                // empty catch block
            }
        }
        is = null;
        is = MimeUtil.class.getClassLoader().getResourceAsStream("magic.mime");
        if (is != null) {
            try {
                MimeUtil.parse(new InputStreamReader(is));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
                is = null;
            }
        }
        try {
            boolean found = false;
            for (int i = 0; i < magicMimeFileLocations.length; ++i) {
                File f = new File(magicMimeFileLocations[i]);
                if (!f.exists()) continue;
                is = new FileInputStream(f);
                found = true;
                break;
            }
            if (!found) {
                is = MimeUtil.class.getClassLoader().getResourceAsStream("eu/medsea/util/magic.mime");
            }
            MimeUtil.parse(new InputStreamReader(is));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

