/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.ResourceFactory;
import com.bradmcevoy.http.ResourceFactoryFactory;
import com.bradmcevoy.http.ServletHttpManager;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractMiltonEndPoint {
    private Log log = LogFactory.getLog(AbstractMiltonEndPoint.class);
    protected ServletHttpManager httpManager;

    protected void init(String resourceFactoryClassName) throws ServletException {
        this.log.debug((Object)("resourceFactoryClassName: " + resourceFactoryClassName));
        ResourceFactory rf = (ResourceFactory)this.instantiate(resourceFactoryClassName);
        this.init(rf);
    }

    protected void initFromFactoryFactory(String resourceFactoryFactoryClassName) throws ServletException {
        this.log.debug((Object)("resourceFactoryFactoryClassName: " + resourceFactoryFactoryClassName));
        ResourceFactoryFactory rff = (ResourceFactoryFactory)this.instantiate(resourceFactoryFactoryClassName);
        rff.init();
        ResourceFactory rf = rff.createResourceFactory();
        this.init(rf);
    }

    protected void init(ResourceFactory rf) {
        this.httpManager = new ServletHttpManager(rf);
    }

    protected <T> T instantiate(String className) throws ServletException {
        try {
            Class<?> c = Class.forName(className);
            Object rf = c.newInstance();
            return (T)rf;
        }
        catch (Throwable ex) {
            throw new ServletException("Failed to instantiate: " + className, ex);
        }
    }

    public void destroy() {
        this.log.debug((Object)"destroy");
        if (this.httpManager == null) {
            return;
        }
        this.httpManager.destroy(this.httpManager);
    }
}

