/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Response;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResponse
implements Response {
    protected DateFormat hdf = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss z");

    public AbstractResponse() {
        this.hdf.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    public void setResponseHeader(Response.Header header, String value) {
        this.setNonStandardHeader(header.code, value);
    }

    public String getResponseHeader(Response.Header header) {
        return this.getNonStandardHeader(header.code);
    }

    @Override
    public void setContentEncodingHeader(Response.ContentEncoding encoding) {
        this.setResponseHeader(Response.Header.CONTENT_ENCODING, encoding.code);
    }

    @Override
    public void setDateHeader(Date date) {
        if (date == null) {
            return;
        }
        String fmt = this.hdf.format(date);
        this.setResponseHeader(Response.Header.DATE, fmt);
    }

    @Override
    public void setAuthenticateHeader(String realm) {
        this.setResponseHeader(Response.Header.WWW_AUTHENTICATE, "Basic realm=\"" + realm + "\"");
    }

    @Override
    public void setContentRangeHeader(long start, long finish, Long totalLength) {
        String l = totalLength == null ? "*" : totalLength.toString();
        String s = "bytes " + start + "-" + finish + "/" + l;
        this.setResponseHeader(Response.Header.CONTENT_RANGE, s);
    }

    @Override
    public void setContentLengthHeader(Long totalLength) {
        String s = totalLength == null ? "*" : totalLength.toString();
        this.setResponseHeader(Response.Header.CONTENT_LENGTH, s);
    }

    @Override
    public void setContentTypeHeader(String type) {
        this.setResponseHeader(Response.Header.CONTENT_TYPE, type);
    }

    @Override
    public String getContentTypeHeader() {
        return this.getResponseHeader(Response.Header.CONTENT_TYPE);
    }

    @Override
    public void setCacheControlMaxAgeHeader(Long delta) {
        this.setResponseHeader(Response.Header.CACHE_CONTROL, Response.CacheControlResponse.MAX_AGE.code + "=" + delta);
    }

    @Override
    public void setExpiresHeader(Date expiresAt) {
        if (expiresAt == null) {
            this.setResponseHeader(Response.Header.EXPIRES, null);
        } else {
            String fmt = this.hdf.format(expiresAt);
            this.setResponseHeader(Response.Header.EXPIRES, fmt);
        }
    }

    @Override
    public void setEtag(String uniqueId) {
        this.setResponseHeader(Response.Header.ETAG, uniqueId);
    }

    @Override
    public void setLastModifiedHeader(Date date) {
        if (date == null) {
            return;
        }
        String fmt = this.hdf.format(date);
        this.setResponseHeader(Response.Header.LAST_MODIFIED, fmt);
    }

    @Override
    public void setCacheControlNoCacheHeader() {
        this.setResponseHeader(Response.Header.CACHE_CONTROL, Response.CacheControlResponse.NO_CACHE.code);
    }

    @Override
    public void setLocationHeader(String redirectUrl) {
        this.setResponseHeader(Response.Header.LOCATION, redirectUrl);
    }

    @Override
    public void setAllowHeader(List<Request.Method> methodsAllowed) {
        if (methodsAllowed == null || methodsAllowed.size() == 0) {
            return;
        }
        StringBuffer sb = null;
        for (Request.Method m : methodsAllowed) {
            if (sb == null) {
                sb = new StringBuffer();
            } else {
                sb.append(",");
            }
            sb.append(m.code);
        }
        this.setResponseHeader(Response.Header.ALLOW, sb.toString());
    }

    @Override
    public void setLockTokenHeader(String s) {
        this.setResponseHeader(Response.Header.LOCK_TOKEN, s);
    }

    @Override
    public void setDavHeader(String supportedLevels) {
        this.setResponseHeader(Response.Header.DAV, supportedLevels);
    }

    @Override
    public void close() {
    }
}

