/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ExistingEntityHandler
extends Handler {
    private Log log = LogFactory.getLog(ExistingEntityHandler.class);
    public static final String NOT_FOUND_HTML = "<html><body><h1>Not Found (404)</h1></body></html>";

    public ExistingEntityHandler(HttpManager manager) {
        super(manager);
    }

    protected abstract void process(HttpManager var1, Request var2, Response var3, Resource var4);

    public void process(HttpManager manager, Request request, Response response) {
        String host = request.getHostHeader();
        String url = HttpManager.decodeUrl(request.getAbsolutePath());
        Resource r = manager.getResourceFactory().getResource(host, url);
        if (r != null) {
            this.processResource(manager, request, response, r);
        } else {
            this.respondNotFound(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResource(HttpManager manager, Request request, Response response, Resource resource) {
        long t = System.currentTimeMillis();
        try {
            manager.onProcessResourceStart(request, response, resource);
            if (!this.checkAuthorisation(resource, request)) {
                this.respondUnauthorised(resource, response);
                return;
            }
            if (!this.isCompatible(resource)) {
                this.respondMethodNotAllowed(resource, response);
                return;
            }
            if (this.doCheckRedirect(request, response, resource)) {
                return;
            }
            this.process(manager, request, response, resource);
        }
        finally {
            t = System.currentTimeMillis() - t;
            manager.onProcessResourceFinish(request, response, resource, t);
        }
    }

    protected boolean doCheckRedirect(Request request, Response response, Resource resource) {
        return false;
    }

    protected void respondNotFound(Request request, Response response) {
        try {
            response.setStatus(Response.Status.SC_NOT_FOUND);
            response.getOutputStream().write(NOT_FOUND_HTML.getBytes());
        }
        catch (IOException ex) {
            this.log.warn((Object)"exception writing content");
        }
    }
}

