/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Handler {
    private Log log = LogFactory.getLog(Handler.class);
    public static final String METHOD_NOT_ALLOWED_HTML = "<html><body><h1>Method Not Allowed</h1></body></html>";
    protected final HttpManager manager;

    public abstract void process(HttpManager var1, Request var2, Response var3);

    protected abstract boolean isCompatible(Resource var1);

    abstract Request.Method method();

    public Handler(HttpManager manager) {
        this.manager = manager;
    }

    protected boolean checkAuthorisation(Resource handler, Request request) {
        Auth auth = request.getAuthorization();
        if (auth != null) {
            Object authTag = handler.authenticate(auth.user, auth.password);
            if (authTag == null) {
                this.log.warn((Object)"failed to authenticate");
                auth = null;
            } else {
                auth.setTag(authTag);
            }
        } else {
            auth = this.manager.getSessionAuthentication(request);
        }
        boolean authorised = handler.authorise(request, request.getMethod(), auth);
        if (!authorised) {
            this.log.warn((Object)"Not authorised, requesting basic authentication");
            return false;
        }
        return true;
    }

    protected void respondUnauthorised(Resource resource, Response response) {
        this.log.debug((Object)"requesting authorisation");
        response.setStatus(Response.Status.SC_UNAUTHORIZED);
        response.setAuthenticateHeader(resource.getRealm());
    }

    protected void respondMethodNotAllowed(Resource res, Response response) {
        this.log.debug((Object)("method not allowed. handler: " + this.getClass().getName() + " resource: " + res.getClass().getName()));
        try {
            response.setStatus(Response.Status.SC_METHOD_NOT_ALLOWED);
            OutputStream out = response.getOutputStream();
            out.write(METHOD_NOT_ALLOWED_HTML.getBytes());
        }
        catch (IOException ex) {
            this.log.warn((Object)"exception writing content");
        }
    }

    protected void respondConflict(Resource resource, Response response) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected void respondRedirect(Response response, String redirectUrl) {
        if (redirectUrl == null) {
            throw new NullPointerException("redirectUrl cannot be null");
        }
        response.setStatus(Response.Status.SC_MOVED_TEMPORARILY);
        response.setLocationHeader(redirectUrl);
    }

    protected String generateNamespaceDeclarations() {
        return " xmlns:D=\"DAV:\"";
    }

    protected void output(Response response, String s) {
        PrintWriter pw = new PrintWriter(response.getOutputStream(), true);
        pw.print(s);
        pw.flush();
    }

    protected void _respondWithContent(Request request, Response response, GetableResource resource, Map<String, String> params) {
        Long contentLength;
        this.setStatus(resource, response, request);
        response.setDateHeader(new Date());
        String etag = resource.getUniqueId();
        if (etag != null) {
            response.setEtag(etag);
        }
        if ((contentLength = resource.getContentLength()) != null) {
            response.setContentLengthHeader(contentLength);
        }
        String acc = request.getAcceptHeader();
        response.setContentTypeHeader(resource.getContentType(acc));
        this.setCacheControl(resource, response);
        response.setLastModifiedHeader(resource.getModifiedDate());
        this.sendContent(request, response, resource, params);
    }

    protected void sendContent(Request request, Response response, GetableResource resource, Map<String, String> params) {
        this.sendContent(request, response, resource, params, null);
    }

    protected void sendContent(Request request, Response response, GetableResource resource, Map<String, String> params, Range range) {
        OutputStream out = this.outputStreamForResponse(request, response, resource);
        try {
            resource.sendContent(out, null, params);
            if (out != response.getOutputStream()) {
                out.flush();
                out.close();
            } else {
                out.flush();
            }
        }
        catch (IOException ex) {
            this.log.warn((Object)"IOException sending content");
        }
    }

    protected OutputStream outputStreamForResponse(Request request, Response response, GetableResource resource) {
        OutputStream outToUse = response.getOutputStream();
        String acc = request.getAcceptHeader();
        String contentType = resource.getContentType(acc);
        if (contentType != null) {
            boolean contentIsCompressable;
            boolean bl = contentIsCompressable = (contentType = contentType.toLowerCase()).contains("text") || contentType.contains("css") || contentType.contains("js") || contentType.contains("javascript");
            if (contentIsCompressable) {
                boolean supportsGzip;
                String accepts = request.getAcceptEncodingHeader();
                boolean bl2 = supportsGzip = accepts != null && accepts.toLowerCase().indexOf("gzip") > -1;
                if (supportsGzip) {
                    try {
                        response.setContentEncodingHeader(Response.ContentEncoding.GZIP);
                        outToUse = new GZIPOutputStream(outToUse);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Exception wrapping outputstream with GZIP output stream", ex);
                    }
                }
            }
        }
        return outToUse;
    }

    protected void setStatus(GetableResource resource, Response response, Request request) {
        response.setStatus(Response.Status.SC_OK);
    }

    protected void setCacheControl(GetableResource resource, Response response) {
        Long delta = resource.getMaxAgeSeconds();
        if (delta != null) {
            response.setCacheControlMaxAgeHeader(resource.getMaxAgeSeconds());
            Date expiresAt = this.calcExpiresAt(resource.getModifiedDate(), delta);
            response.setExpiresHeader(expiresAt);
        } else {
            response.setExpiresHeader(null);
            response.setCacheControlNoCacheHeader();
        }
    }

    protected Date calcExpiresAt(Date modifiedDate, long deltaSeconds) {
        long deltaMs = deltaSeconds * 1000L;
        long expiresAt = System.currentTimeMillis() + deltaMs;
        return new Date(expiresAt);
    }

    protected class Namespace {
        String abbrev;
        String url;

        protected Namespace() {
        }
    }
}

