/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.NewEntityHandler;
import com.bradmcevoy.http.PutableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PutHandler
extends NewEntityHandler {
    private Log log = LogFactory.getLog(PutHandler.class);

    public PutHandler(HttpManager manager) {
        super(manager);
    }

    public Request.Method method() {
        return Request.Method.PUT;
    }

    protected boolean isCompatible(Resource handler) {
        return handler instanceof PutableResource;
    }

    protected void process(HttpManager milton, Request request, Response response, CollectionResource resource, String newName) {
        PutableResource r = (PutableResource)resource;
        this.log.debug((Object)("process: putting to: " + r.getName()));
        try {
            Long l = request.getContentLengthHeader();
            String ct = request.getContentTypeHeader();
            this.log.debug((Object)("PutHandler: creating resource of type: " + ct));
            r.createNew(newName, request.getInputStream(), l, ct);
            this.log.debug((Object)"PutHandler: DONE creating resource");
        }
        catch (IOException ex) {
            this.log.warn((Object)("IOException reading input stream. Probably interrupted upload: " + ex.getMessage()));
            return;
        }
        response.setStatus(Response.Status.SC_CREATED);
        this.log.debug((Object)"process: finished");
    }
}

