/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Filter;
import com.bradmcevoy.http.FilterChain;
import com.bradmcevoy.http.Handler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Response;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardFilter
implements Filter {
    private Log log = LogFactory.getLog(StandardFilter.class);
    public static final String INTERNAL_SERVER_ERROR_HTML = "<html><body><h1>Internal Server Error (500)</h1></body></html>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(FilterChain chain, Request request, Response response) {
        try {
            Request.Method method = request.getMethod();
            HttpManager manager = chain.getHttpManager();
            Handler handler = manager.methodFactoryMap.get((Object)method);
            if (handler == null) {
                throw new RuntimeException("No handler for method: " + method.code);
            }
            handler.process(manager, request, response);
        }
        catch (Throwable e) {
            this.log.error((Object)"process", e);
            try {
                response.setStatus(Response.Status.SC_INTERNAL_SERVER_ERROR);
                this.log.info((Object)"setting error content");
                response.getOutputStream().write(INTERNAL_SERVER_ERROR_HTML.getBytes());
            }
            catch (IOException ex) {
                this.log.warn((Object)"exception writing content");
            }
        }
        finally {
            response.close();
        }
    }
}

