/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.ApplicationConfig;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Initable;
import com.bradmcevoy.http.MiltonUtils;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import com.bradmcevoy.http.StaticResource;
import java.io.File;

public class StaticResourceFactory
implements ResourceFactory,
Initable {
    private ApplicationConfig config;

    public void init(ApplicationConfig config, HttpManager manager) {
        this.config = config;
    }

    public Resource getResource(String host, String url) {
        if (this.config == null) {
            throw new RuntimeException("ResourceFactory was not configured. ApplicationConfig is null");
        }
        if (this.config.servletContext == null) {
            throw new NullPointerException("config.servletContext is null");
        }
        String path = "WEB-INF/static" + url;
        File file = new File(path = this.config.servletContext.getRealPath(path));
        if (file.exists() && !file.isDirectory()) {
            String contentType = MiltonUtils.getContentType(this.config.servletContext, file.getName());
            return new StaticResource(file, url, contentType);
        }
        return null;
    }

    public void destroy(HttpManager manager) {
    }

    public String getSupportedLevels() {
        return "1,2";
    }
}

