/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.CollectionResource;
import com.bradmcevoy.http.DeletableResource;
import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.XmlWriter;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteHandler
extends ExistingEntityHandler {
    private Log log = LogFactory.getLog(DeleteHandler.class);

    public DeleteHandler(HttpManager manager) {
        super(manager);
    }

    protected Request.Method method() {
        return Request.Method.DELETE;
    }

    protected boolean isCompatible(Resource handler) {
        return handler instanceof DeletableResource;
    }

    protected void process(HttpManager milton, Request request, Response response, Resource resource) {
        this.log.debug((Object)("DELETE: " + request.getAbsoluteUrl()));
        DeletableResource r = (DeletableResource)resource;
        try {
            this.delete(r);
            response.setStatus(Response.Status.SC_NO_CONTENT);
            this.log.debug((Object)"deleted ok");
        }
        catch (CantDeleteException e) {
            this.log.error((Object)("failed to delete: " + request.getAbsoluteUrl()), (Throwable)e);
            response.setStatus(Response.Status.SC_MULTI_STATUS);
            response.setStatus(Response.Status.SC_MULTI_STATUS);
            response.setContentTypeHeader(Response.ContentType.XML.toString());
            String href = request.getAbsoluteUrl();
            XmlWriter writer = new XmlWriter(response.getOutputStream());
            writer.writeXMLHeader();
            writer.open("multistatus" + this.generateNamespaceDeclarations());
            writer.newLine();
            XmlWriter.Element elResponse = writer.begin("response").open();
            writer.writeProperty("", "href", href);
            writer.writeProperty("", "status", e.status.code + "");
            elResponse.close();
            writer.close("multistatus");
            writer.flush();
        }
    }

    private void delete(DeletableResource r) throws CantDeleteException {
        if (r instanceof CollectionResource) {
            CollectionResource col = (CollectionResource)((Object)r);
            ArrayList<? extends Resource> list = new ArrayList<Resource>();
            list.addAll(col.getChildren());
            for (Resource resource : list) {
                if (resource instanceof DeletableResource) {
                    DeletableResource rChildDel = (DeletableResource)resource;
                    this.delete(rChildDel);
                    continue;
                }
                throw new CantDeleteException(resource, Response.Status.SC_LOCKED);
            }
        }
        r.delete();
    }

    public static class CantDeleteException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final Resource resource;
        public final Response.Status status;

        CantDeleteException(Resource r, Response.Status status) {
            this.resource = r;
            this.status = status;
        }
    }
}

