/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.PostableResource;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.RequestParseException;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostHandler
extends ExistingEntityHandler {
    private Log log = LogFactory.getLog(PostHandler.class);

    public PostHandler(HttpManager manager) {
        super(manager);
    }

    @Override
    public Request.Method method() {
        return Request.Method.POST;
    }

    @Override
    protected boolean isCompatible(Resource handler) {
        return handler instanceof PostableResource;
    }

    @Override
    protected void process(HttpManager milton, Request request, Response response, Resource resource) {
        PostableResource r = (PostableResource)resource;
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, FileItem> files = new HashMap<String, FileItem>();
        try {
            request.parseRequestParameters(params, files);
        }
        catch (RequestParseException ex) {
            this.log.warn((Object)"exception parsing request. probably interrupted upload", (Throwable)ex);
            return;
        }
        this.manager.onPost(request, response, resource, params, files);
        String url = this.processForm(r, params, files);
        if (url != null) {
            this.respondRedirect(response, url);
        } else {
            this.respondWithContent(request, response, r, params);
        }
    }

    protected String processForm(PostableResource r, Map<String, String> parameters, Map<String, FileItem> files) {
        return r.processForm(parameters, files);
    }

    protected void respondWithContent(Request request, Response response, PostableResource resource, Map<String, String> parameters) {
        this._respondWithContent(request, response, resource, parameters);
    }

    @Override
    protected boolean doCheckRedirect(Request request, Response response, Resource resource) {
        String redirectUrl = resource.checkRedirect(request);
        if (redirectUrl != null) {
            this.respondRedirect(response, redirectUrl);
            return true;
        }
        return false;
    }
}

