/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.ApplicationConfig;
import com.bradmcevoy.http.Filter;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Initable;
import com.bradmcevoy.http.ResourceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServletHttpManager
extends HttpManager
implements Initable {
    private Log log = LogFactory.getLog(ServletHttpManager.class);

    public ServletHttpManager(ResourceFactory resourceFactory) {
        super(resourceFactory);
    }

    public void init(ApplicationConfig config, HttpManager manager) {
        this.log.debug((Object)"init");
        if (this.resourceFactory != null) {
            if (this.resourceFactory instanceof Initable) {
                Initable i = (Initable)((Object)this.resourceFactory);
                i.init(config, manager);
            }
            for (String paramName : config.getInitParameterNames()) {
                if (!paramName.startsWith("filter_")) continue;
                String filterClass = config.getInitParameter(paramName);
                this.log.debug((Object)("init filter: " + filterClass));
                String[] arr = paramName.split("_");
                String ordinal = arr[arr.length - 1];
                int pos = Integer.parseInt(ordinal);
                this.initFilter(config, filterClass, pos);
            }
        }
    }

    private void initFilter(ApplicationConfig config, String filterClass, int pos) {
        try {
            Class<?> c = Class.forName(filterClass);
            Filter filter = (Filter)c.newInstance();
            if (filter instanceof Initable) {
                ((Initable)((Object)filter)).init(config, this);
            }
            this.addFilter(pos, filter);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(filterClass, ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(filterClass, ex);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(filterClass, ex);
        }
    }

    public void destroy(HttpManager manager) {
        this.log.debug((Object)"destroy");
        if (this.resourceFactory != null && this.resourceFactory instanceof Initable) {
            Initable i = (Initable)((Object)this.resourceFactory);
            i.destroy(manager);
        }
    }
}

