/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.AbstractRequest;
import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.FileItem;
import com.bradmcevoy.http.FileItemWrapper;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.RequestParseException;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.upload.MonitoredDiskFileItemFactory;
import com.bradmcevoy.http.upload.UploadListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletRequest
extends AbstractRequest {
    private final HttpServletRequest request;
    private final Request.Method method;
    private final String url;
    private Auth auth;
    private static HashMap<Response.ContentType, String> contentTypes = new HashMap();
    private static HashMap<String, Response.ContentType> typeContents = new HashMap();
    private static ThreadLocal<HttpServletRequest> tlRequest;

    public static HttpServletRequest getRequest() {
        return tlRequest.get();
    }

    public ServletRequest(HttpServletRequest r) {
        this.request = r;
        String sMethod = r.getMethod();
        this.method = Request.Method.valueOf(sMethod);
        this.url = r.getRequestURL().toString();
        tlRequest.set(r);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    @Override
    public String getFromAddress() {
        return this.request.getRemoteHost();
    }

    @Override
    protected String getRequestHeader(Request.Header header) {
        return this.request.getHeader(header.code);
    }

    @Override
    public Request.Method getMethod() {
        return this.method;
    }

    @Override
    public String getAbsoluteUrl() {
        return this.url;
    }

    @Override
    public Auth getAuthorization() {
        if (this.auth != null) {
            return this.auth;
        }
        String enc = this.getRequestHeader(Request.Header.AUTHORIZATION);
        if (enc == null) {
            return null;
        }
        if (enc.length() == 0) {
            return null;
        }
        this.auth = new Auth(enc);
        return this.auth;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    @Override
    public void parseRequestParameters(Map<String, String> params, Map<String, FileItem> files) throws RequestParseException {
        try {
            if (this.isMultiPart()) {
                UploadListener listener = new UploadListener();
                MonitoredDiskFileItemFactory factory = new MonitoredDiskFileItemFactory(listener);
                ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                List items = upload.parseRequest(this.request);
                this.parseQueryString(params);
                for (Object o : items) {
                    org.apache.commons.fileupload.FileItem item = (org.apache.commons.fileupload.FileItem)o;
                    if (item.isFormField()) {
                        params.put(item.getFieldName(), item.getString());
                        continue;
                    }
                    files.put(item.getFieldName(), new FileItemWrapper(item));
                }
            } else {
                Enumeration en = this.request.getParameterNames();
                while (en.hasMoreElements()) {
                    String nm = (String)en.nextElement();
                    String val = this.request.getParameter(nm);
                    params.put(nm, val);
                }
            }
        }
        catch (FileUploadException ex) {
            throw new RequestParseException("FileUploadException", ex);
        }
        catch (Throwable ex) {
            throw new RequestParseException(ex.getMessage(), ex);
        }
    }

    private void parseQueryString(Map<String, String> map) {
        String qs = this.request.getQueryString();
        ServletRequest.parseQueryString(map, qs);
    }

    public static void parseQueryString(Map<String, String> map, String qs) {
        String[] nvs;
        if (qs == null) {
            return;
        }
        for (String nv : nvs = qs.split("&")) {
            String[] parts = nv.split("=");
            String key = parts[0];
            String val = null;
            if (parts.length > 1) {
                val = parts[1];
            }
            if (val != null) {
                try {
                    val = URLDecoder.decode(val, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new RuntimeException(ex);
                }
            }
            map.put(key, val);
        }
    }

    protected Response.ContentType getRequestContentType() {
        String s = this.request.getContentType();
        if (s == null) {
            return null;
        }
        if (s.contains("multipart/form-data")) {
            return Response.ContentType.MULTIPART;
        }
        return typeContents.get(s);
    }

    protected boolean isMultiPart() {
        return Response.ContentType.MULTIPART.equals((Object)this.getRequestContentType());
    }

    static {
        contentTypes.put(Response.ContentType.HTTP, "text/html");
        contentTypes.put(Response.ContentType.MULTIPART, "multipart/form-data");
        contentTypes.put(Response.ContentType.XML, "text/xml; charset=UTF-8");
        for (Response.ContentType key : contentTypes.keySet()) {
            typeContents.put(contentTypes.get((Object)key), key);
        }
        tlRequest = new ThreadLocal();
    }
}

