/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import eu.medsea.util.MimeUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticResource
implements GetableResource {
    private final File file;
    private String contentType;

    public StaticResource(File file, String url, String contentType) {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("Static resource must be a file, this is a directory: " + file.getAbsolutePath());
        }
        this.file = file;
        this.contentType = contentType;
    }

    @Override
    public String getUniqueId() {
        return this.file.hashCode() + "";
    }

    @Override
    public int compareTo(Resource res) {
        return this.getName().compareTo(res.getName());
    }

    @Override
    public void sendContent(OutputStream out, Range range, Map<String, String> params) throws IOException {
        FileInputStream fis = new FileInputStream(this.file);
        BufferedInputStream bin = new BufferedInputStream(fis);
        byte[] buffer = new byte[1024];
        int n = 0;
        while (-1 != (n = bin.read(buffer))) {
            out.write(buffer, 0, n);
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public Object authenticate(String user, String password) {
        return "ok";
    }

    @Override
    public boolean authorise(Request request, Request.Method method, Auth auth) {
        return true;
    }

    @Override
    public String getRealm() {
        return "ettrema";
    }

    @Override
    public Date getModifiedDate() {
        Date dt = new Date(this.file.lastModified());
        return dt;
    }

    @Override
    public Long getContentLength() {
        return this.file.length();
    }

    @Override
    public String getContentType(String accepts) {
        String s = MimeUtil.getMimeType(this.file.getAbsolutePath());
        s = MimeUtil.getPreferedMimeType(accepts, s);
        return s;
    }

    @Override
    public String checkRedirect(Request request) {
        return null;
    }

    @Override
    public Long getMaxAgeSeconds() {
        return 86400L;
    }
}

