/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.nhr.loader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.ws.BindingProvider;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.nhr.loader.NHRException;
import nl.kvk.schemas.schemas.hrip.dataservice._2015._02.Dataservice;
import nl.kvk.schemas.schemas.hrip.dataservice._2015._02.InschrijvingRequestType;
import nl.kvk.schemas.schemas.hrip.dataservice._2015._02.InschrijvingResponseType;
import nl.kvk.schemas.schemas.hrip.dataservice._2015._02.MeldingType;
import nl.kvk.schemas.schemas.hrip.dataservice._2015._02.ObjectFactory;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;

public class NHRLoader {
    private static JAXBContext jaxbContext;
    private static ObjectFactory factory;

    public static void sendSingleRequest(Dataservice dataservice, BrmoFramework brmoFramework, String kvkNummer, String rsin) throws Exception {
        String description;
        if (jaxbContext == null) {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{InschrijvingResponseType.class});
        }
        InschrijvingRequestType request = new InschrijvingRequestType();
        if (kvkNummer != null) {
            description = String.format("KVK nummer %s", kvkNummer);
            request.setKvkNummer(kvkNummer);
        } else if (rsin != null) {
            description = String.format("KVK RSIN %s", rsin);
            request.setRsin(rsin);
        } else {
            throw new IllegalArgumentException("KVK nummer en RSIN zijn beiden null");
        }
        BindingProvider bindingProvider = (BindingProvider)dataservice;
        AddressingProperties properties = (AddressingProperties)bindingProvider.getRequestContext().get("javax.xml.ws.addressing.context");
        AttributedURIType msgid = new AttributedURIType();
        msgid.setValue("uuid:" + UUID.randomUUID().toString());
        properties.setMessageID(msgid);
        InschrijvingResponseType response = dataservice.ophalenInschrijving(request);
        List<MeldingType> errors = response.getMeldingen().getFout();
        if (!errors.isEmpty()) {
            HashMap<String, String> errorMap = new HashMap<String, String>();
            for (MeldingType melding : errors) {
                errorMap.put(melding.getCode(), melding.getOmschrijving());
            }
            throw new NHRException(errorMap);
        }
        JAXBElement<InschrijvingResponseType> wrappedResponse = factory.createOphalenInschrijvingResponse(response);
        Marshaller marshaller = jaxbContext.createMarshaller();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        marshaller.marshal(wrappedResponse, (OutputStream)outputStream);
        brmoFramework.loadFromStream("nhr", (InputStream)new ByteArrayInputStream(outputStream.toByteArray()), String.format("NHR %s %s", LocalDateTime.now(), description), (Long)null);
    }

    static {
        factory = new ObjectFactory();
    }
}

