/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.nhr.loader.cli;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import nl.b3p.brmo.loader.BrmoFramework;
import nl.b3p.brmo.nhr.loader.NHRCertificateOptions;
import nl.b3p.brmo.nhr.loader.NHRDatabaseOptions;
import nl.b3p.brmo.nhr.loader.NHRLoader;
import nl.b3p.brmo.nhr.loader.NHRLoaderUtils;
import nl.b3p.brmo.nhr.loader.cli.NHRLoadOptions;
import nl.b3p.brmo.nhr.loader.cli.NHRLoadUtils;
import nl.kvk.schemas.schemas.hrip.dataservice._2015._02.Dataservice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import picocli.CommandLine;

@CommandLine.Command(name="nhr-loader", mixinStandardHelpOptions=true, versionProvider=NHRLoaderMain.class, resourceBundle="NHRLoader", subcommands={})
public class NHRLoaderMain
implements CommandLine.IVersionProvider {
    private static Log log;
    @CommandLine.ArgGroup(validate=false, headingKey="loadOptions", heading="Load options:%n")
    private NHRLoadOptions loadOptions;
    @CommandLine.ArgGroup(validate=false, headingKey="certificateOptions", heading="Certificate options:%n")
    private NHRCertificateOptions certificateOptions;
    @CommandLine.ArgGroup(validate=false, headingKey="databaseOptions", heading="Database options:%n")
    private NHRDatabaseOptions databaseOptions;

    public static void configureLogging(boolean standAlone) {
        if (standAlone) {
            PropertyConfigurator.configure((InputStream)NHRLoaderMain.class.getResourceAsStream("/nhr-loader-cli-log4j.properties"));
        }
        log = LogFactory.getLog(NHRLoaderMain.class);
    }

    public static void main(String ... args) {
        NHRLoaderMain.configureLogging(true);
        CommandLine cmd = new CommandLine((Object)new NHRLoaderMain()).setUsageHelpAutoWidth(true);
        System.exit(cmd.execute(args));
    }

    public String[] getVersion() {
        return new String[]{NHRLoaderUtils.getLoaderVersion(), NHRLoaderUtils.getUserAgent()};
    }

    @CommandLine.Command(name="request", sortOptions=false)
    public int process(@CommandLine.Parameters(paramLabel="<nummers>") String[] nummers, @CommandLine.Option(names={"-q", "--quit-early"}) boolean quitEarly, @CommandLine.Option(names={"-h", "--help"}, usageHelp=true) boolean showHelp) throws Exception {
        log.info((Object)NHRLoaderUtils.getUserAgent());
        Dataservice dataservice = NHRLoadUtils.getDataservice(this.loadOptions.getLocation(), this.loadOptions.getPreprod(), this.certificateOptions);
        BrmoFramework brmoFramework = NHRLoadUtils.getFramework(this.databaseOptions);
        for (String nummer : nummers) {
            try {
                NHRLoader.sendSingleRequest(dataservice, brmoFramework, nummer, null);
            }
            catch (Exception e) {
                log.error((Object)e);
                if (!quitEarly) continue;
                brmoFramework.closeBrmoFramework();
                return 1;
            }
        }
        brmoFramework.closeBrmoFramework();
        return 0;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CommandLine.Command(name="file", sortOptions=false)
    public int file(@CommandLine.Parameters(paramLabel="<bestanden>") String[] files, @CommandLine.Option(names={"-q", "--quit-early"}) boolean quitEarly, @CommandLine.Option(names={"-h", "--help"}, usageHelp=true) boolean showHelp) throws Exception {
        log.info((Object)NHRLoaderUtils.getUserAgent());
        Dataservice dataservice = NHRLoadUtils.getDataservice(this.loadOptions.getLocation(), this.loadOptions.getPreprod(), this.certificateOptions);
        BrmoFramework brmoFramework = NHRLoadUtils.getFramework(this.databaseOptions);
        boolean hasFailure = false;
        block9: for (String file : files) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file, StandardCharsets.US_ASCII));){
                while (reader.ready()) {
                    String nummer = reader.readLine();
                    try {
                        NHRLoader.sendSingleRequest(dataservice, brmoFramework, nummer, null);
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        hasFailure = true;
                        if (!quitEarly) continue;
                        reader.close();
                        break block9;
                    }
                }
            }
            catch (Exception e) {
                brmoFramework.closeBrmoFramework();
                throw e;
            }
        }
        brmoFramework.closeBrmoFramework();
        if (!hasFailure) return 0;
        return 1;
    }
}

