/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.BouwplanAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.BouwplanVariable;
import nl.b3p.pzh.rwbp.entity.Bouwplanopmerking;
import nl.b3p.pzh.rwbp.entity.Bouwplanvoortgang;
import nl.b3p.pzh.rwbp.entity.Extraveld;
import nl.b3p.pzh.rwbp.entity.Factmetperiode;
import nl.b3p.pzh.rwbp.entity.Gerealiseerd;
import nl.b3p.pzh.rwbp.entity.Periode;
import nl.b3p.pzh.rwbp.entity.Plantype;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariableValue;
import nl.b3p.pzh.rwbp.entity.Statusplanologisch;
import nl.b3p.pzh.rwbp.entity.Voortgangsoort;
import nl.b3p.pzh.rwbp.entity.Voortgangstatus;
import org.stripesstuff.stripersist.Stripersist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StrictBinding
public class ConverterActionBean
implements ActionBean {
    public static final int FACT_GEPLAND = 1;
    private ActionBeanContext context;
    @Validate
    private boolean commit = false;
    @Validate
    boolean removeOld = false;
    @Validate
    private Bouwplan bouwplan;
    @Validate
    private boolean makeVars = false;
    @Validate
    private Provincie provincie;
    private Map<Provincie, Map<String, ProvincieAdditionalVariable>> provvars = new HashMap<Provincie, Map<String, ProvincieAdditionalVariable>>();

    public Resolution convert() {
        final EntityManager em = Stripersist.getEntityManager();
        return new StreamingResolution("text/plain"){

            public void stream(HttpServletResponse response) throws Exception {
                PrintWriter out = new PrintWriter(response.getWriter());
                List toConvert = em.createQuery("From Bouwplan where gemeente.provincie = :provincie AND jaar_eerste_oplevering is null").setParameter("provincie", (Object)ConverterActionBean.this.provincie).getResultList();
                int counter = 0;
                for (Bouwplan bouwplan : toConvert) {
                    out.format("Converteren bouwplan #%d: %s \r\n: ", bouwplan.getId(), bouwplan.getNaam());
                    ConverterActionBean.this.convertBouwplan(bouwplan);
                    out.flush();
                    if (++counter <= 110) continue;
                    counter = 0;
                    out.write("Committing... \r\n");
                    out.write("*******************************************************\r\n");
                    if (!ConverterActionBean.this.commit) continue;
                    em.getTransaction().commit();
                }
                if (ConverterActionBean.this.commit) {
                    em.getTransaction().commit();
                }
            }
        };
    }

    public Resolution onlyRemove() {
        if (this.commit) {
            EntityManager em = Stripersist.getEntityManager();
            em.getTransaction().commit();
        }
        return new ForwardResolution("");
    }

    public Resolution convertOne() {
        this.convertBouwplan(this.bouwplan);
        if (this.commit) {
            EntityManager em = Stripersist.getEntityManager();
            em.getTransaction().commit();
        }
        return new ForwardResolution("");
    }

    @Before
    private void before() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.removeOld) {
            List old = em.createQuery("FROM Bouwplan where statusprojectid = 11").getResultList();
            for (Bouwplan old1 : old) {
                for (Bouwplanopmerking bouwplanOpmerkingen : old1.getBouwplanOpmerkingen()) {
                    em.remove((Object)bouwplanOpmerkingen);
                }
                em.remove((Object)old1);
            }
        }
        List provincies = em.createQuery("FROM Provincie").getResultList();
        List voortgangssoorten = em.createQuery("FROM Voortgangsoort").getResultList();
        if (this.makeVars) {
            List voortgangsstatus = em.createQuery("FROM Voortgangstatus").getResultList();
            for (Provincie prov : provincies) {
                List regioList = em.createQuery("select r from Regio r join r.provincie p where p = :provincie order by r.naam").setParameter("provincie", (Object)prov).getResultList();
                HashMap<String, ProvincieAdditionalVariable> vars = new HashMap<String, ProvincieAdditionalVariable>();
                for (Voortgangsoort voortgangssoort : voortgangssoorten) {
                    ProvincieAdditionalVariable pav = new ProvincieAdditionalVariable();
                    pav.setProvincie(prov);
                    pav.setAdditionField(false);
                    pav.setProvinceField(false);
                    pav.setAdditional_variable(voortgangssoort.getType());
                    pav.setUsedByMunicipalities(true);
                    pav.setRegios(regioList);
                    pav.setLocation("voortgang");
                    pav.setType("dropdown");
                    ArrayList<ProvincieAdditionalVariableValue> values = new ArrayList<ProvincieAdditionalVariableValue>();
                    Iterator iterator = voortgangsstatus.iterator();
                    while (iterator.hasNext()) {
                        Voortgangstatus status = (Voortgangstatus)iterator.next();
                        ProvincieAdditionalVariableValue val = new ProvincieAdditionalVariableValue();
                        val.setRegios(regioList);
                        val.setUsedByMunicipalities(true);
                        val.setValue(status.getType());
                        val.setProvincieadditionalvariable(pav);
                        values.add(val);
                        em.persist((Object)val);
                    }
                    pav.setValues(values);
                    em.persist((Object)pav);
                    vars.put(voortgangssoort.getType(), pav);
                }
                this.provvars.put(prov, vars);
            }
        } else {
            for (Provincie provincy : provincies) {
                HashMap<String, ProvincieAdditionalVariable> vars = new HashMap<String, ProvincieAdditionalVariable>();
                for (Voortgangsoort soort : voortgangssoorten) {
                    List pavs = em.createQuery("from ProvincieAdditionalVariable where provincie = :provincie and additional_variable = :var").setParameter("provincie", (Object)provincy).setParameter("var", (Object)soort.getType()).getResultList();
                    for (ProvincieAdditionalVariable pav : pavs) {
                        vars.put(soort.getType(), pav);
                    }
                }
                this.provvars.put(provincy, vars);
            }
        }
        int b = 1;
        int a = b + 10;
    }

    private void convertBouwplan(Bouwplan bouwplan) {
        List waardes = ConverterActionBean.makefactList(1, bouwplan);
        this.convertGlobalValues(waardes, bouwplan);
        this.convertDetails(waardes, bouwplan);
        this.calculateMinMaxYear(waardes, bouwplan);
        this.convertKnelpunten(bouwplan);
        this.convertOpmerkingen(bouwplan);
        this.convertStatus(bouwplan);
        EntityManager em = Stripersist.getEntityManager();
        em.persist((Object)bouwplan);
        boolean a = false;
    }

    private void convertStatus(Bouwplan bouwplan) {
        Object onbekend;
        EntityManager em = Stripersist.getEntityManager();
        Set<Bouwplanvoortgang> vg = bouwplan.getBouwplanvoortgang();
        Provincie p = bouwplan.getGemeente().getProvincie();
        for (Bouwplanvoortgang voortgang : vg) {
            ProvincieAdditionalVariable pav = this.provvars.get(p).get(voortgang.getVoortgangsoort().getType());
            BouwplanAdditionalVariable bav = new BouwplanAdditionalVariable();
            bav.setBouwplan(bouwplan);
            bav.setVariable(pav);
            List<ProvincieAdditionalVariableValue> vals = pav.getValues();
            for (ProvincieAdditionalVariableValue val : vals) {
                if (!val.getValue().equalsIgnoreCase(voortgang.getVoortgangstatus().getType())) continue;
                bav.setVariableValue("" + val.getId());
            }
            em.persist((Object)bav);
        }
        if (bouwplan.getPlantype() == null) {
            onbekend = (Plantype)em.find(Plantype.class, (Object)99);
            bouwplan.setPlantype((Plantype)onbekend);
        }
        if (bouwplan.getStatusplanologisch() == null) {
            onbekend = (Statusplanologisch)em.find(Statusplanologisch.class, (Object)1);
            bouwplan.setStatusplanologisch((Statusplanologisch)onbekend);
        }
        bouwplan.setDatumlaatstewijziging(bouwplan.getGebruikeractiontijd());
    }

    private void convertOpmerkingen(Bouwplan bouwplan) {
        Set<Bouwplanopmerking> opmerkingen = bouwplan.getBouwplanOpmerkingen();
        String value = "";
        String provincievalue = "";
        boolean prive = false;
        for (Bouwplanopmerking opmerking : opmerkingen) {
            if (opmerking.getGebruiker() != null && opmerking.getGebruiker().getProvincie() != null) {
                provincievalue = provincievalue + "\r\n";
                provincievalue = provincievalue + opmerking.getOpmerking();
            } else {
                value = value + "\r\n";
                value = value + opmerking.getOpmerking();
            }
            if (!opmerking.getAccesslevel().getType().equalsIgnoreCase("Prive")) continue;
            prive = true;
        }
        bouwplan.setOpmerkingen(value);
        bouwplan.setOpmerkingenprive(prive);
        bouwplan.setOpmerkingenprovincie(provincievalue);
    }

    private void convertKnelpunten(Bouwplan bouwplan) {
        String knelpunten = "";
        Set<Bouwplanvoortgang> bv = bouwplan.getBouwplanvoortgang();
        for (Bouwplanvoortgang bv1 : bv) {
            if (bv1.getToelichting() == null || bv1.getToelichting().isEmpty()) continue;
            knelpunten = knelpunten + "\r\n";
            knelpunten = knelpunten + bv1.getVoortgangsoort().getType() + " toelichting: " + bv1.getToelichting();
        }
        bouwplan.setKnelpunten(knelpunten);
    }

    private void convertDetails(List<Map<String, Object>> waardes, Bouwplan bouwplan) {
        EntityManager em = Stripersist.getEntityManager();
        boolean hasYear = false;
        for (Map<String, Object> jaar : waardes) {
            if (!jaar.containsKey("Jaar")) continue;
            hasYear = true;
            String yearString = (String)jaar.get("Jaar");
            Integer year = Integer.parseInt(yearString);
            year = this.correctYear(year);
            BouwplanVariable bv = new BouwplanVariable();
            bv.setBouwplan(bouwplan);
            bv.setYear(year);
            int gepland = jaar.containsKey("Nieuwbouw") ? (Integer)jaar.get("Nieuwbouw") : 0;
            int sloop = jaar.containsKey("Sloop") ? (Integer)jaar.get("Sloop") : 0;
            Object gerealiseerd = jaar.get("Gerealiseerd");
            bv.setSloop(sloop);
            bv.setGepland(gepland);
            if (gerealiseerd != null && ((Gerealiseerd)((Object)gerealiseerd)).compareTo(Gerealiseerd.Ja) == 0) {
                bv.setGerealiseerd(true);
            }
            em.persist((Object)bv);
        }
        if (hasYear) {
            bouwplan.setDetailType("normaal");
        }
    }

    private void convertGlobalValues(List<Map<String, Object>> waardes, Bouwplan bouwplan) {
        int huur1 = this.aggregate(waardes, "HuurGoedkoop");
        huur1 += this.aggregate(waardes, "HuurSociaal");
        huur1 += this.aggregate(waardes, "HuurSociaal3");
        huur1 += this.aggregate(waardes, "HuurSociaal4");
        int huur2 = this.aggregate(waardes, "HuurMarkt");
        int huur3 = this.aggregate(waardes, "HuurMarkt2");
        int huuronbekend = this.aggregate(waardes, "HuurOnbekend");
        int koop1 = this.aggregate(waardes, "KoopSociaal");
        int koop2 = this.aggregate(waardes, "KoopMarkt");
        int koop3 = this.aggregate(waardes, "KoopMarkt2");
        int koop4 = this.aggregate(waardes, "KoopMarkt3");
        koop4 += this.aggregate(waardes, "KoopMarkt4");
        int kooponbekend = this.aggregate(waardes, "KoopOnbekend");
        int meergezins = this.aggregateFuzzy(waardes, "Meergezins", false, false);
        int eensgezins = this.aggregateFuzzy(waardes, "Eensgezins", false, false);
        int onbekend = this.aggregateFuzzy(waardes, "OnbekendOnbekend", false, false);
        int sloop = this.aggregateFuzzy(waardes, "Sloop", false, false);
        int restcapaciteit = this.aggregateFuzzy(waardes, "Nieuwbouw", true, false);
        int gerealiseerdeCapaciteit = this.aggregateFuzzy(waardes, "Nieuwbouw", true, true);
        int totaalCapaciteit = restcapaciteit + gerealiseerdeCapaciteit;
        bouwplan.setKoop1(koop1);
        bouwplan.setKoop2(koop2);
        bouwplan.setKoop3(koop3);
        bouwplan.setKoop4(koop4);
        bouwplan.setKoopprijsonbekend(kooponbekend);
        bouwplan.setKooptotaal(koop1 + koop2 + koop3 + koop4 + kooponbekend);
        bouwplan.setHuur1(huur1);
        bouwplan.setHuur2(huur2);
        bouwplan.setHuur3(huur3);
        bouwplan.setHuur4(0);
        bouwplan.setHuurprijsonbekend(huuronbekend);
        bouwplan.setHuurtotaal(huur1 + huur2 + huur3 + huuronbekend);
        bouwplan.setEensgezins(eensgezins);
        bouwplan.setMeergezins(meergezins);
        bouwplan.setWoningtypeonbekend(onbekend);
        bouwplan.setRestcapaciteit(restcapaciteit);
        bouwplan.setResterendesloop(sloop);
        bouwplan.setGerealiseerdecapaciteit(gerealiseerdeCapaciteit);
        bouwplan.setTotaalcapaciteit(totaalCapaciteit);
    }

    private Integer correctYear(Integer year) {
        if (year > 2019) {
            year = year == 2020 ? Integer.valueOf(2024) : (year == 2025 ? Integer.valueOf(2029) : Integer.valueOf(2040));
        }
        return year;
    }

    private void calculateMinMaxYear(List<Map<String, Object>> values, Bouwplan bouwplan) {
        int min = 99999;
        int max = -1;
        for (Map<String, Object> jaar : values) {
            int sloop;
            if (!jaar.containsKey("Jaar")) continue;
            String yearString = (String)jaar.get("Jaar");
            Integer year = Integer.parseInt(yearString);
            year = this.correctYear(year);
            int gepland = jaar.containsKey("Nieuwbouw") ? (Integer)jaar.get("Nieuwbouw") : 0;
            int n = sloop = jaar.containsKey("Sloop") ? (Integer)jaar.get("Sloop") : 0;
            if (gepland <= 0 && sloop <= 0) continue;
            min = Math.min(year, min);
            max = Math.max(year, max);
        }
        if (min == 99999) {
            min = 2015;
        }
        if (min < 2013) {
            min = 2013;
        }
        if (max == -1) {
            max = 2015;
        }
        bouwplan.setJaar_eerste_oplevering(min);
        bouwplan.setJaar_laatste_oplevering(max);
    }

    private int aggregateFuzzy(List<Map<String, Object>> values, String index, boolean useRealised, boolean realised) {
        int value = 0;
        for (Map<String, Object> jaar : values) {
            String yearString = (String)jaar.get("Jaar");
            Integer year = Integer.parseInt(yearString);
            if (year < 2013) continue;
            for (String key : jaar.keySet()) {
                if (!key.contains(index)) continue;
                value += jaar.containsKey(key) ? (Integer)jaar.get(key) : 0;
            }
        }
        return value;
    }

    private int aggregate(List<Map<String, Object>> values, String index) {
        int value = 0;
        for (Map<String, Object> jaar : values) {
            String yearString = (String)jaar.get("Jaar");
            Integer year = Integer.parseInt(yearString);
            if (year < 2013 || !jaar.containsKey(index + "Eensgezins")) continue;
            value += jaar.containsKey(index + "Eensgezins") ? (Integer)jaar.get(index + "Eensgezins") : 0;
            value += jaar.containsKey(index + "Meergezins") ? (Integer)jaar.get(index + "Meergezins") : 0;
            value += jaar.containsKey(index + "Onbekend") ? (Integer)jaar.get(index + "Onbekend") : 0;
        }
        return value;
    }

    public static List makefactList(int resultType, Bouwplan bouwplan) {
        EntityManager em = Stripersist.getEntityManager();
        ArrayList tempList = new ArrayList();
        List jaren = em.createQuery("from Periode order by id asc").getResultList();
        for (Periode periode : jaren) {
            HashMap<String, Object> jaarmap = new HashMap<String, Object>();
            jaarmap.put("Jaar", periode.getJaar());
            jaarmap.put("JaarOmschrijving", periode.getOmschrijving());
            if (bouwplan != null && bouwplan.getId() != null) {
                List fmplist = em.createQuery("from Factmetperiode where bouwplan = :bouwplan and periode = :periode").setParameter("bouwplan", (Object)bouwplan).setParameter("periode", (Object)periode).getResultList();
                for (Factmetperiode fmp : fmplist) {
                    switch (fmp.getFactSoort().getId()) {
                        case 3: {
                            jaarmap.put("HuurGoedkoopEensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 6: {
                            jaarmap.put("HuurGoedkoopMeergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 9: {
                            jaarmap.put("HuurGoedkoopOnbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 4: {
                            jaarmap.put("HuurSociaalEensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 7: {
                            jaarmap.put("HuurSociaalMeergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 10: {
                            jaarmap.put("HuurSociaalOnbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 34: {
                            jaarmap.put("HuurSociaal3Eensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 35: {
                            jaarmap.put("HuurSociaal3Meergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 36: {
                            jaarmap.put("HuurSociaal3Onbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 37: {
                            jaarmap.put("HuurSociaal4Eensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 38: {
                            jaarmap.put("HuurSociaal4Meergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 39: {
                            jaarmap.put("HuurSociaal4Onbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 5: {
                            jaarmap.put("HuurMarktEensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 8: {
                            jaarmap.put("HuurMarktMeergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 11: {
                            jaarmap.put("HuurMarktOnbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 31: {
                            jaarmap.put("HuurMarkt2Eensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 32: {
                            jaarmap.put("HuurMarkt2Meergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 33: {
                            jaarmap.put("HuurMarkt2Onbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 21: {
                            jaarmap.put("HuurOnbekendEensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 22: {
                            jaarmap.put("HuurOnbekendMeergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 23: {
                            jaarmap.put("HuurOnbekendOnbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 12: {
                            jaarmap.put("KoopSociaalEensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 14: {
                            jaarmap.put("KoopSociaalMeergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 16: {
                            jaarmap.put("KoopSociaalOnbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 13: {
                            jaarmap.put("KoopMarktEensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 15: {
                            jaarmap.put("KoopMarktMeergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 17: {
                            jaarmap.put("KoopMarktOnbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 28: {
                            jaarmap.put("KoopMarkt2Eensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 29: {
                            jaarmap.put("KoopMarkt2Meergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 30: {
                            jaarmap.put("KoopMarkt2Onbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 42: {
                            jaarmap.put("KoopMarkt3Eensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 44: {
                            jaarmap.put("KoopMarkt3Meergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 46: {
                            jaarmap.put("KoopMarkt3Onbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 43: {
                            jaarmap.put("KoopMarkt4Eensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 45: {
                            jaarmap.put("KoopMarkt4Meergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 47: {
                            jaarmap.put("KoopMarkt4Onbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 24: {
                            jaarmap.put("KoopOnbekendEensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 25: {
                            jaarmap.put("KoopOnbekendMeergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 26: {
                            jaarmap.put("KoopOnbekendOnbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 18: {
                            jaarmap.put("OnbekendOnbekend", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 40: {
                            jaarmap.put("OnbekendEensgezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 41: {
                            jaarmap.put("OnbekendMeergezins", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 2: {
                            jaarmap.put("Sloop", ConverterActionBean.factAantal(resultType, fmp));
                            break;
                        }
                        case 27: {
                            jaarmap.put("Gerealiseerd", (Object)Gerealiseerd.fromOrdinal(ConverterActionBean.factAantal(resultType, fmp)));
                        }
                    }
                }
                jaarmap.put("Nieuwbouw", ConverterActionBean.factAantalNieuwbouw(resultType, periode, bouwplan));
                List extravelden = em.createQuery("from Extraveld where bouwplan = :bouwplan and periode = :periode").setParameter("bouwplan", (Object)bouwplan).setParameter("periode", (Object)periode).getResultList();
                ArrayList velden = new ArrayList();
                for (Extraveld extraveld : extravelden) {
                    HashMap<String, Object> extra = new HashMap<String, Object>();
                    extra.put("id", extraveld.getId());
                    extra.put("soort", extraveld.getExtraveldsoort().getId());
                    extra.put("soortnaam", extraveld.getExtraveldsoort().getType());
                    if (resultType == 1) {
                        extra.put("aantal", extraveld.getAantalgepland());
                    }
                    velden.add(extra);
                }
                jaarmap.put("extravelden", velden);
                tempList.add(jaarmap);
                continue;
            }
            jaarmap.put("HuurGoedkoopEensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurGoedkoopMeergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurGoedkoopOnbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurSociaalEensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurSociaalMeergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurSociaalOnbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurSociaal3Eensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurSociaal3Meergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurSociaal3Onbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurSociaal4Eensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurSociaal4Meergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurSociaal4Onbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurMarktEensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurMarktMeergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurMarktOnbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurMarkt2Eensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurMarkt2Meergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurMarkt2Onbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurOnbekendEensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurOnbekendMeergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("HuurOnbekendOnbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopSociaalEensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopSociaalMeergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopSociaalOnbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarktEensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarktMeergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarktOnbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarkt2Eensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarkt2Meergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarkt2Onbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarkt3Eensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarkt3Meergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarkt3Onbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarkt4Eensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarkt4Meergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopMarkt4Onbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopOnbekendEensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopOnbekendMeergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("KoopOnbekendOnbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("OnbekendOnbekend", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("OnbekendEensgezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("OnbekendMeergezins", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("Nieuwbouw", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("Sloop", ConverterActionBean.factAantal(resultType, null));
            jaarmap.put("Gerealiseerd", ConverterActionBean.factAantal(resultType, null));
            tempList.add(jaarmap);
        }
        return tempList;
    }

    private static Integer factAantal(int resultType, Factmetperiode fmp) {
        Integer result = null;
        if (fmp == null) {
            result = 0;
        } else if (resultType == 1) {
            result = fmp.getPlanningaantal();
        }
        return result;
    }

    private static Integer factAantalNieuwbouw(int resultType, Periode p, Bouwplan bouwplan) {
        Long aantal;
        EntityManager em = Stripersist.getEntityManager();
        Integer result = 0;
        if (p == null) {
            result = 0;
        } else if (resultType == 1 && (aantal = (Long)em.createQuery("select sum(planningaantal) from Factmetperiode where bouwplan = :bouwplan and periode = :periode and factsoortid != 1 and factsoortid != 2 and factsoortid != 27").setParameter("bouwplan", (Object)bouwplan).setParameter("periode", (Object)p).getSingleResult()) != null) {
            result = aantal.intValue();
        }
        return result;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public Bouwplan getBouwplan() {
        return this.bouwplan;
    }

    public void setBouwplan(Bouwplan bouwplan) {
        this.bouwplan = bouwplan;
    }

    public Provincie getProvincie() {
        return this.provincie;
    }

    public void setProvincie(Provincie provincie) {
        this.provincie = provincie;
    }

    public boolean isRemoveOld() {
        return this.removeOld;
    }

    public void setRemoveOld(boolean removeOld) {
        this.removeOld = removeOld;
    }

    public boolean isMakeVars() {
        return this.makeVars;
    }

    public void setMakeVars(boolean makeVars) {
        this.makeVars = makeVars;
    }
}

