/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.pzh.rwbp.stripes;

import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.RedirectResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.validation.OneToManyTypeConverter;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.pzh.rwbp.entity.Bouwplan;
import nl.b3p.pzh.rwbp.entity.BouwplanAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.Gemeente;
import nl.b3p.pzh.rwbp.entity.Provincie;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariable;
import nl.b3p.pzh.rwbp.entity.ProvincieAdditionalVariableValue;
import nl.b3p.pzh.rwbp.entity.Regio;
import nl.b3p.pzh.rwbp.entity.VariableType;
import nl.b3p.pzh.rwbp.printen.PrintExtraInfo;
import nl.b3p.pzh.rwbp.printen.PrintGenerator;
import nl.b3p.pzh.rwbp.printen.PrintInfo;
import nl.b3p.pzh.rwbp.printen.PrintInfoList;
import nl.b3p.pzh.rwbp.stripes.BouwplanUtils;
import nl.b3p.pzh.rwbp.stripes.EditActionBean;
import nl.b3p.pzh.rwbp.stripes.ViewerActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@StrictBinding
public class PrintActionBean
extends ViewerActionBean {
    private static final Log log = LogFactory.getLog(PrintActionBean.class);
    protected static Logger fopLogger = Logger.getLogger((String)"org.apache.fop");
    public static final String A5_Landscape = "A5_Landscape.xsl";
    public static final String A5_Portrait = "A5_Portrait.xsl";
    public static final String A4_Landscape = "A4_Landscape.xsl";
    public static final String A4_Portrait = "A4_Portrait.xsl";
    public static final String A3_Landscape = "A3_Landscape.xsl";
    public static final String A3_Portrait = "A3_Portrait.xsl";
    public static final String A0_Landscape = "A0_Landscape.xsl";
    public static final String A0_Portrait = "A0_Portrait.xsl";
    public static final String DEFAULT_TEMPLATE_PATH = "/WEB-INF/print/";
    public static final String A5 = "a5";
    public static final String A4 = "a4";
    public static final String A3 = "a3";
    public static final String A0 = "a0";
    public static final String LANDSCAPE = "landscape";
    public static final String PORTRAIT = "portrait";
    public static SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy", new Locale("NL"));
    @Validate(converter=OneToManyTypeConverter.class, required=true)
    private List<Integer> bouwplans = new ArrayList<Integer>();

    @DefaultHandler
    public Resolution print() throws JSONException, Exception {
        final PrintInfoList pil = new PrintInfoList();
        final EntityManager em = Stripersist.getEntityManager();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        for (Integer id : this.bouwplans) {
            Bouwplan bouwplan = (Bouwplan)em.find(Bouwplan.class, (Object)id);
            CombineImageSettings cis = EditActionBean.createCombineImageSettings(bouwplan, this.getMapserverUrl(), this.getLayers(), 800, 900, this.getHttpRequestParams());
            PrintInfo info = new PrintInfo();
            if (cis != null) {
                String imageUrl = this.getImageUrl(bouwplan);
                info.setImageUrl(imageUrl + "&key=" + cis.hashCode());
                info.setBbox(BouwplanUtils.makeBboxBouwplan(bouwplan));
            }
            info.setTitle(bouwplan.getNaam());
            info.setSubtitle("www.planmonitorwonen.nl");
            info.setDate(df.format(new Date()));
            info.setRemark("Extratesk");
            log.debug((Object)"Print Parse 'extra'");
            JSONArray jarray = this.getExtra(bouwplan);
            ArrayList<PrintExtraInfo> peis = new ArrayList<PrintExtraInfo>();
            for (int i = 0; i < jarray.length(); ++i) {
                JSONObject extraObj = jarray.getJSONObject(i);
                PrintExtraInfo pei = new PrintExtraInfo();
                String className = extraObj.getString("className");
                String componentName = extraObj.getString("componentName");
                pei.setClassName(className);
                pei.setComponentName(componentName);
                pei.setInfoText(extraObj);
                peis.add(pei);
            }
            PrintExtraInfo additionalVars = new PrintExtraInfo();
            JSONObject vars = this.getAdditionalVars(bouwplan);
            additionalVars.setClassName("AdditionalVariables");
            additionalVars.setComponentName("AdditionalVariables");
            additionalVars.setInfoText(vars);
            peis.add(additionalVars);
            info.setExtra(peis);
            pil.getInfos().add(info);
        }
        String pageFormat = A4;
        String orientation = PORTRAIT;
        final String templateName = this.getTemplateName(pageFormat, orientation);
        String mimeType = "application/pdf";
        final String templateUrl = this.context.getServletContext().getRealPath(DEFAULT_TEMPLATE_PATH + templateName);
        StreamingResolution res = new StreamingResolution("application/pdf"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stream(HttpServletResponse response) throws Exception {
                String filename = "Kaart_";
                if (PrintActionBean.this.bouwplans.size() == 1) {
                    Bouwplan bp = (Bouwplan)em.find(Bouwplan.class, PrintActionBean.this.bouwplans.get(0));
                    filename = bp.getNaam();
                }
                filename = filename + pil.getInfos().get(0).getDate() + ".pdf";
                File f = new File(templateUrl);
                if (!f.exists()) {
                    f = new File(PrintActionBean.this.context.getServletContext().getRealPath(templateUrl));
                }
                if (!f.exists()) {
                    log.error((Object)("Can't find template: " + f.getAbsolutePath() + ". Using the default templates"));
                    f = new File(PrintActionBean.this.context.getServletContext().getRealPath(PrintActionBean.DEFAULT_TEMPLATE_PATH + templateName));
                }
                try {
                    PrintGenerator.createOutput(pil, "application/pdf", f, true, response, filename);
                }
                finally {
                    for (PrintInfo info : pil.getInfos()) {
                        info.removeLegendImagesCache();
                    }
                }
            }
        };
        return res;
    }

    private JSONObject getAdditionalVars(Bouwplan bouwplan) throws JSONException {
        EntityManager em = Stripersist.getEntityManager();
        List vars = null;
        Gemeente gemeente = bouwplan.getGemeente();
        Provincie p = gemeente.getProvincie();
        vars = gemeente.getRegio() != null ? em.createQuery("select p FROM ProvincieAdditionalVariable p join p.regios r where p.label = false and r.id = :regio order by additional_variable", ProvincieAdditionalVariable.class).setParameter("regio", (Object)gemeente.getRegio().getId()).getResultList() : em.createQuery("FROM ProvincieAdditionalVariable where label = false and provincie = :provincie and usedByMunicipalities = true order by additional_variable", ProvincieAdditionalVariable.class).setParameter("provincie", (Object)p).getResultList();
        JSONObject additionalVars = new JSONObject();
        for (ProvincieAdditionalVariable var : vars) {
            String location = var.getLocation();
            if (!additionalVars.has(location)) {
                JSONArray loc = new JSONArray();
                additionalVars.put(location, (Object)loc);
            }
            JSONArray locationArray = additionalVars.getJSONArray(location);
            JSONObject jsonVar = new JSONObject();
            jsonVar.put("var", (Object)var.getAdditional_variable());
            locationArray.put((Object)jsonVar);
            try {
                BouwplanAdditionalVariable bav = (BouwplanAdditionalVariable)em.createQuery("FROM BouwplanAdditionalVariable WHERE bouwplan = :bouwplan and variable = :var", BouwplanAdditionalVariable.class).setParameter("bouwplan", (Object)bouwplan).setParameter("var", (Object)var).getSingleResult();
                List<ProvincieAdditionalVariableValue> values = var.getValues();
                ProvincieAdditionalVariableValue value = null;
                for (ProvincieAdditionalVariableValue val : values) {
                    if (Integer.parseInt(bav.getVariableValue()) != val.getId()) continue;
                    value = val;
                    break;
                }
                if (value != null) {
                    jsonVar.put("value", (Object)value.getValue());
                    continue;
                }
                jsonVar.put("value", (Object)bav.getVariableValue());
            }
            catch (NoResultException bav) {}
        }
        List optionalLabelVars = em.createQuery("SELECT label FROM ConfigurableVariable WHERE type = :type", String.class).setParameter("type", (Object)VariableType.LABEL).getResultList();
        List labelVars = null;
        labelVars = optionalLabelVars.size() > 0 ? em.createQuery("FROM ProvincieAdditionalVariable WHERE label = true and additional_variable in :vars and provincie = :provincie").setParameter("vars", (Object)optionalLabelVars).setParameter("provincie", (Object)p).getResultList() : new ArrayList();
        HashMap<String, String> labelMap = new HashMap<String, String>();
        Regio regio = gemeente.getRegio();
        for (String optionalLabelVar : optionalLabelVars) {
            String value = null;
            for (ProvincieAdditionalVariable labelVar : labelVars) {
                if (!labelVar.getAdditional_variable().equals(optionalLabelVar)) continue;
                for (ProvincieAdditionalVariableValue pavv : labelVar.getValues()) {
                    if (regio == null && pavv.isUsedByMunicipalities()) {
                        value = pavv.getValue();
                    }
                    if (!pavv.getRegios().contains(gemeente.getRegio())) continue;
                    value = pavv.getValue();
                }
            }
            labelMap.put("" + optionalLabelVar, value != null ? value : optionalLabelVar);
        }
        JSONObject labels = new JSONObject(labelMap);
        additionalVars.put("labels", (Object)labels);
        return additionalVars;
    }

    private String getImageUrl(Bouwplan bouwplan) throws Exception {
        RedirectResolution cia = (RedirectResolution)((RedirectResolution)((RedirectResolution)((RedirectResolution)new RedirectResolution(EditActionBean.class).addParameter("bouwplan", new Object[]{bouwplan.getId()})).addParameter("width", new Object[]{800})).addParameter("height", new Object[]{616})).addParameter("bouwplanImage", new Object[]{Boolean.TRUE});
        String url = this.context.getRequest().getRequestURL().toString();
        String pm = "planmonitor/";
        int index = url.indexOf(pm);
        url = url.substring(0, index + pm.length());
        url = url + cia.getUrl(new Locale("NL"));
        return url;
    }

    private String getTemplateName(String pageFormat, String orientation) {
        if (A5.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A5_Landscape;
        }
        if (A5.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A5_Portrait;
        }
        if (A4.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A4_Landscape;
        }
        if (A3.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A3_Portrait;
        }
        if (A3.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A3_Landscape;
        }
        if (A0.equalsIgnoreCase(pageFormat) && PORTRAIT.equalsIgnoreCase(orientation)) {
            return A0_Portrait;
        }
        if (A0.equalsIgnoreCase(pageFormat) && LANDSCAPE.equalsIgnoreCase(orientation)) {
            return A0_Landscape;
        }
        return A4_Portrait;
    }

    public List<Integer> getBouwplans() {
        return this.bouwplans;
    }

    public void setBouwplans(List<Integer> bouwplans) {
        this.bouwplans = bouwplans;
    }

    private String printInfoToString(PrintInfo info) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PrintInfo.class});
        Marshaller m = context.createMarshaller();
        m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        StringWriter sw = new StringWriter();
        m.marshal((Object)info, (Writer)sw);
        String s = sw.toString();
        return s;
    }

    private JSONArray getExtra(Bouwplan bouwplan) throws JSONException {
        JSONArray ar = new JSONArray();
        ar.put((Object)this.getBasisgegevens(bouwplan));
        ar.put((Object)this.getSoort(bouwplan));
        ar.put((Object)this.getVoortgang(bouwplan));
        ar.put((Object)this.getAantallen(bouwplan));
        ar.put((Object)this.getWoningtypen(bouwplan));
        ar.put((Object)this.getKoop(bouwplan));
        ar.put((Object)this.getHuur(bouwplan));
        ar.put((Object)this.getOverig(bouwplan));
        return ar;
    }

    private JSONObject getBasisgegevens(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"basisgegevens");
        json.put("componentName", (Object)"Basisgegevens");
        json.put("PlanID", (Object)bouwplan.getId());
        json.put("Plannaam", (Object)bouwplan.getNaam());
        json.put("Gemeente", (Object)bouwplan.getGemeente().getNaam());
        json.put("Referentienummer", (Object)bouwplan.getReferentienummer());
        json.put("Bestemmingsplan", (Object)bouwplan.getBestemmingsplannaam());
        json.put("IMRO-nummer", (Object)bouwplan.getImronummer());
        json.put("Masterplan", (Object)bouwplan.getMasterplan());
        if (bouwplan.getOntwikkelaartype() != null) {
            json.put("Oprachtgevertype", (Object)bouwplan.getOntwikkelaartype().getType());
        }
        json.put("Opdrachtgever", (Object)bouwplan.getOntwikkelaar_namelijk());
        json.put("Vertrouwelijk", (Object)bouwplan.getGebruikgegevens().getNaam());
        return json;
    }

    private JSONObject getSoort(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Soortplan");
        json.put("componentName", (Object)"Soortplan");
        json.put("Plantype", (Object)bouwplan.getPlantype().getType());
        return json;
    }

    private JSONObject getVoortgang(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Voortgang");
        json.put("componentName", (Object)"Voortgang");
        json.put("Statusplanologisch", (Object)bouwplan.getStatusplanologisch().getType());
        json.put("Statusproject", (Object)bouwplan.getStatusproject().getType());
        json.put("Knelpunten", (Object)bouwplan.getKnelpunten());
        return json;
    }

    private JSONObject getAantallen(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Aantallen");
        json.put("componentName", (Object)"Aantallen");
        json.put("eersteoplevering", (Object)bouwplan.getJaar_eerste_oplevering());
        json.put("laatsteoplevering", (Object)bouwplan.getJaar_laatste_oplevering());
        json.put("restcapaciteit", (Object)bouwplan.getRestcapaciteit());
        json.put("resterendesloop", (Object)bouwplan.getResterendesloop());
        return json;
    }

    private JSONObject getWoningtypen(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Woningtypen");
        json.put("componentName", (Object)"Woningtypen");
        json.put("Meergezins", (Object)bouwplan.getMeergezins());
        json.put("Eengezins", (Object)bouwplan.getEensgezins());
        json.put("Woningtypeonbekend", (Object)bouwplan.getWoningtypeonbekend());
        return json;
    }

    private JSONObject getKoop(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Koop");
        json.put("componentName", (Object)"Koop");
        json.put("Koop1", (Object)bouwplan.getKoop1());
        json.put("Koop2", (Object)bouwplan.getKoop2());
        json.put("Koop3", (Object)bouwplan.getKoop3());
        json.put("Koop4", (Object)bouwplan.getKoop4());
        json.put("Kooponbekend", (Object)bouwplan.getKoopprijsonbekend());
        json.put("Kooptotaal", (Object)bouwplan.getKooptotaal());
        return json;
    }

    private JSONObject getHuur(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Huur");
        json.put("componentName", (Object)"Huur");
        json.put("Huur1", (Object)bouwplan.getHuur1());
        json.put("Huur2", (Object)bouwplan.getHuur2());
        json.put("Huur3", (Object)bouwplan.getHuur3());
        json.put("Huur4", (Object)bouwplan.getHuur4());
        json.put("Huuronbekend", (Object)bouwplan.getHuurprijsonbekend());
        json.put("Huurtotaal", (Object)bouwplan.getHuurtotaal());
        return json;
    }

    private JSONObject getOverig(Bouwplan bouwplan) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("className", (Object)"Overig");
        json.put("componentName", (Object)"Overig");
        if (!bouwplan.isOpmerkingenprive()) {
            json.put("opmerking", (Object)bouwplan.getOpmerkingen());
        }
        return json;
    }
}

